/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.Legend;
import oracle.sdovis.LegendEntry;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.BarChartStyle;
import oracle.sdovis.stylex.CollectionStyle;
import oracle.sdovis.stylex.PieChartStyle;

public class LegendColumn {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final String SEPARATOR = "_-_SEPARATOR_-_";
    private static Style defaultTitleStyle = new StyleText(new Font("Dialog", 1, 14), Color.blue, 2.0f);
    Legend owner = null;
    Vector items = new Vector(5);
    Rectangle2D mbr = null;
    private StyleText descriptionTextStyle = (StyleText)StyleFactory.getDefaultTextStyle();

    public LegendColumn(Legend legend) {
        this.owner = legend;
    }

    public int getProfile() {
        return this.owner.profile;
    }

    public Color getBackground() {
        return this.owner.background;
    }

    public Color getBorderColor() {
        return this.owner.borderColor;
    }

    public Rectangle2D getMBR() {
        return this.mbr;
    }

    public int getBorderWidth() {
        return this.owner.borderWidth;
    }

    public Color getTextColor() {
        return this.owner.textColor;
    }

    public LegendEntry setTitle(String string) {
        LegendEntry legendEntry = new LegendEntry(string);
        legendEntry.setProfile(this.owner.profile);
        legendEntry.setBackground(this.owner.background);
        legendEntry.setFontFamily(this.owner.fontFamily);
        this.items.add(legendEntry);
        return legendEntry;
    }

    public void addEntry(LegendEntry legendEntry) {
        legendEntry.setProfile(this.owner.profile);
        this.items.add(legendEntry);
    }

    public LegendEntry addStyle(String string, String string2) {
        LegendEntry legendEntry = new LegendEntry(string, string2);
        legendEntry.setProfile(this.owner.profile);
        legendEntry.setFontFamily(this.owner.fontFamily);
        legendEntry.setBackground(this.owner.background);
        this.items.addElement(legendEntry);
        return legendEntry;
    }

    public LegendEntry addStyleWithCustomDimension(String string, String string2, int n, int n2) {
        LegendEntry legendEntry = new LegendEntry(string, string2);
        legendEntry.setProfile(this.owner.profile);
        legendEntry.setUserSpcifiedDimensioin(n, n2);
        legendEntry.setFontFamily(this.owner.fontFamily);
        legendEntry.setBackground(this.owner.background);
        this.items.addElement(legendEntry);
        return legendEntry;
    }

    public void addSeparator() {
        LegendEntry legendEntry = new LegendEntry();
        legendEntry.setProfile(this.owner.profile);
        legendEntry.setBackground(this.owner.background);
        this.items.addElement(legendEntry);
    }

    public void deleteAllEntries() {
        this.items.removeAllElements();
    }

    public int getNumEntries() {
        return this.items.size();
    }

    public void prepare(VisContext visContext) {
        LegendEntry legendEntry = null;
        int n = this.items.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            legendEntry = (LegendEntry)this.items.get(i);
            legendEntry.setProfile(this.owner.profile);
            legendEntry.prepare(visContext);
        }
        this.mbr = this.getMaxTextBounds();
    }

    public void destroy() {
        if (this.items == null) {
            return;
        }
        LegendEntry legendEntry = null;
        for (int i = 0; i < this.items.size(); ++i) {
            legendEntry = (LegendEntry)this.items.get(i);
            legendEntry.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics2D, int n, int n2) {
        int n3 = this.items.size();
        if (n3 == 0) {
            return;
        }
        String string = graphics2D.toString();
        AttributedCharacterIterator attributedCharacterIterator = null;
        Color color = this.owner.background;
        Color color2 = this.owner.textColor;
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, (int)this.mbr.getWidth(), (int)this.mbr.getHeight());
        }
        graphics2D.translate(n, n2);
        graphics2D.setColor(color2);
        try {
            int n4 = 3;
            for (int i = 0; i < this.items.size(); ++i) {
                LegendEntry legendEntry = (LegendEntry)this.items.get(i);
                int n5 = legendEntry.getPreferredHeight();
                if (string.indexOf("XDOGraphics2D") < 0 || legendEntry.getType() == 1 || legendEntry.getType() == 2 || legendEntry.getStyle() == null) {
                    AttributedString attributedString = legendEntry.getAttrString();
                    if (attributedString == null) continue;
                    attributedCharacterIterator = attributedString.getIterator();
                    graphics2D.drawString(attributedCharacterIterator, 2, (n4 += n5) - n5 / 2);
                    continue;
                }
                int n6 = legendEntry.getPreferredWidth();
                if (!legendEntry.hasAdvancedStyle() || legendEntry.getStyle() instanceof PieChartStyle || legendEntry.getStyle() instanceof BarChartStyle || legendEntry.getStyle() instanceof CollectionStyle) {
                    n6 = LegendEntry.PROFILE_IMAGE_WIDTH[this.getProfile()];
                    if (legendEntry.getUserWidth() > 0) {
                        n6 = legendEntry.getUserWidth();
                    }
                }
                double d = (double)(legendEntry.getNumSpaces() * legendEntry.getTextSize()) / 2.0;
                Rectangle2D.Double double_ = new Rectangle2D.Double(2.0 + d, n4, n6, n5);
                StyleModifiers styleModifiers = legendEntry.getStyle().convertToPixelSize(null);
                legendEntry.getStyle().apply(null, graphics2D, (Rectangle2D)double_, styleModifiers);
                if (legendEntry.getText() != null && legendEntry.getText().trim().length() > 0) {
                    Font font = legendEntry.getFont();
                    if (font == null) {
                        font = new Font("Serif", 0, LegendEntry.PROFILE_TEXT_SIZE[this.getProfile()]);
                    }
                    graphics2D.setFont(font);
                    Color color3 = legendEntry.getForeground();
                    if (color3 == null) {
                        color3 = Color.black;
                    }
                    graphics2D.setColor(color3);
                    if (legendEntry.hasAdvancedStyle() && !(legendEntry.getStyle() instanceof PieChartStyle) && !(legendEntry.getStyle() instanceof BarChartStyle) && !(legendEntry.getStyle() instanceof CollectionStyle)) {
                        graphics2D.drawString(legendEntry.getText(), 10 + ((AdvancedStyle)legendEntry.getStyle()).getMaxLegendWidth(null, legendEntry.getTextSize()), n4 + (int)((double)n5 / 2.0 + 0.5));
                    } else {
                        graphics2D.drawString(legendEntry.getText(), 10 + n6, 3 + n4 + (int)((double)n5 / 2.0 + 0.5));
                    }
                }
                n4 += n5;
            }
        }
        catch (Exception exception) {
        }
        finally {
            graphics2D.translate(-n, -n2);
        }
    }

    public LegendEntry getEntry(int n) {
        if (n >= this.items.size()) {
            return null;
        }
        return (LegendEntry)this.items.get(n);
    }

    private Rectangle2D getMaxTextBounds() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            LegendEntry legendEntry = (LegendEntry)this.items.get(i);
            if (legendEntry.type == 1) {
                n2 += legendEntry.getPreferredHeight();
                continue;
            }
            int n3 = legendEntry.getPreferredWidth();
            int n4 = legendEntry.getPreferredHeight();
            n2 += n4;
            if (n >= n3) continue;
            n = n3;
        }
        return new Rectangle2D.Double(0.0, 0.0, n += 5, n2 += LegendEntry.PROFILE_IMAGE_HEIGHT[this.owner.profile]);
    }
}

