/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.PointWithAlpha;
import oracle.sdovis.util.RectArray;

public class LabelHelper {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final int MIN_TEXT_BOX_WIDTH = 10;
    static final int TOLERANCE = 5;

    public static float[] findLoc4RectInEllipse(Shape shape, double d, double d2, RectArray[] rectArrayArray, boolean bl, boolean bl2, Rectangle2D rectangle2D) {
        float[] fArray = new float[3];
        Ellipse2D ellipse2D = (Ellipse2D)shape;
        double d3 = ellipse2D.getCenterX();
        double d4 = ellipse2D.getCenterY();
        double d5 = ellipse2D.getWidth();
        double d6 = ellipse2D.getHeight();
        if (d5 >= d && d6 >= d2) {
            if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 - d / 2.0, d4 - d2 / 2.0, d, d2)) {
                LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 - d / 2.0, d4 - d2 / 2.0, d, d2);
                fArray[0] = (float)(d3 - d / 2.0);
                fArray[1] = (float)(d4 + d2 / 2.0);
                fArray[2] = 0.0f;
                return fArray;
            }
            if (d5 / 3.0 > d / 2.0) {
                if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 - d5 / 6.0 - d / 2.0, d4 - d2 / 2.0, d, d2)) {
                    LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 - d5 / 6.0 - d / 2.0, d4 - d2 / 2.0, d, d2);
                    fArray[0] = (float)(d3 - d5 / 6.0 - d / 2.0);
                    fArray[1] = (float)(d4 + d2 / 2.0);
                    fArray[2] = 0.0f;
                    return fArray;
                }
                if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 + d5 / 6.0 - d / 2.0, d4 - d2 / 2.0, d, d2)) {
                    LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 + d5 / 6.0 - d / 2.0, d4 - d2 / 2.0, d, d2);
                    fArray[0] = (float)(d3 + d5 / 6.0 - d / 2.0);
                    fArray[1] = (float)(d4 + d2 / 2.0);
                    fArray[2] = 0.0f;
                    return fArray;
                }
            }
            if (d5 * 0.8 > d) {
                if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 - d / 2.0, d4 - d6 / 6.0 - d2 / 2.0, d, d2)) {
                    LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 - d / 2.0, d4 - d6 / 6.0 - d2 / 2.0, d, d2);
                    fArray[0] = (float)(d3 - d / 2.0);
                    fArray[1] = (float)(d4 - d6 / 6.0 + d2 / 2.0);
                    fArray[2] = 0.0f;
                    return fArray;
                }
                if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 - d / 2.0, d4 + d6 / 6.0 - d2 / 2.0, d, d2)) {
                    LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 - d / 2.0, d4 + d6 / 6.0 - d2 / 2.0, d, d2);
                    fArray[0] = (float)(d3 - d / 2.0);
                    fArray[1] = (float)(d4 + d6 / 6.0 + d2 / 2.0);
                    fArray[2] = 0.0f;
                    return fArray;
                }
            }
        }
        if (!bl2) {
            return null;
        }
        if (d5 < d6 && d5 >= d2 && d6 >= d) {
            double d7 = d2;
            d2 = d;
            d = d7;
            float f = -1.5707964f;
            if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 - d / 2.0, d4 - d2 / 2.0, d, d2)) {
                LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 - d / 2.0, d4 - d2 / 2.0, d, d2);
                fArray[0] = (float)(d3 + d / 2.0);
                fArray[1] = (float)(d4 + d2 / 2.0);
                fArray[2] = f;
                return fArray;
            }
            if (d6 / 3.0 > d2 / 2.0) {
                if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 - d / 2.0, d4 - d6 / 6.0 - d2 / 2.0, d, d2)) {
                    LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 - d / 2.0, d4 - d6 / 6.0 - d2 / 2.0, d, d2);
                    fArray[0] = (float)(d3 + d / 2.0);
                    fArray[1] = (float)(d4 - d6 / 6.0 + d2 / 2.0);
                    fArray[2] = f;
                    return fArray;
                }
                if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 - d / 2.0, d4 + d6 / 6.0 - d2 / 2.0, d, d2)) {
                    LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 - d / 2.0, d4 + d6 / 6.0 - d2 / 2.0, d, d2);
                    fArray[0] = (float)(d3 + d / 2.0);
                    fArray[1] = (float)(d4 + d6 / 6.0 + d2 / 2.0);
                    fArray[2] = f;
                    return fArray;
                }
            }
            if (d6 * 0.8 > d2) {
                if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 - d5 / 6.0 - d / 2.0, d4 - d2, d, d2)) {
                    LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 - d5 / 6.0 - d / 2.0, d4 - d2 / 2.0, d, d2);
                    fArray[0] = (float)(d3 - d5 / 6.0 + d / 2.0);
                    fArray[1] = (float)(d4 + d2 / 2.0);
                    fArray[2] = f;
                    return fArray;
                }
                if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d3 + d5 / 6.0 - d / 2.0, d4 - d2 / 2.0, d, d2)) {
                    LabelHelper.insertRectIntoRectArrays(rectArrayArray, d3 + d5 / 6.0 - d / 2.0, d4 - d2 / 2.0, d, d2);
                    fArray[0] = (float)(d3 + d5 / 6.0 + d / 2.0);
                    fArray[1] = (float)(d4 + d2 / 2.0);
                    fArray[2] = f;
                    return fArray;
                }
            }
        }
        return null;
    }

    public static float[] findLoc4RectInPolygon(Shape shape, double d, double d2, RectArray rectArray, boolean bl, boolean bl2, Rectangle2D rectangle2D) {
        return LabelHelper.findLoc4RectInPolygon(null, shape, d, d2, rectArray, bl, bl2, rectangle2D);
    }

    public static float[] findLoc4RectInPolygon(Graphics2D graphics2D, Shape shape, double d, double d2, RectArray rectArray, boolean bl, boolean bl2, Rectangle2D rectangle2D) {
        RectArray[] rectArrayArray = new RectArray[]{rectArray};
        return LabelHelper.findLoc4RectInPolygon(graphics2D, shape, d, d2, rectArrayArray, bl, bl2, rectangle2D);
    }

    public static float[] findLoc4RectInPolygon(Shape shape, double d, double d2, RectArray[] rectArrayArray, boolean bl, boolean bl2) {
        return LabelHelper.findLoc4RectInPolygon(null, shape, d, d2, rectArrayArray, bl, bl2, null);
    }

    public static float[] findLoc4RectInPolygon(Graphics2D graphics2D, Shape shape, double d, double d2, RectArray[] rectArrayArray, boolean bl, boolean bl2, Rectangle2D rectangle2D) {
        int n;
        if (shape instanceof Ellipse2D) {
            return LabelHelper.findLoc4RectInEllipse(shape, d, d2, rectArrayArray, bl, bl2, rectangle2D);
        }
        if (d == d2) {
            bl2 = false;
        }
        if (shape == null) {
            return null;
        }
        float f = 5.0f;
        Rectangle rectangle = shape.getBounds();
        if ((rectangle.getWidth() < d || rectangle.getHeight() < d2) && (rectangle.getWidth() < d2 || rectangle.getHeight() < d)) {
            if (!bl) {
                return null;
            }
            float[] fArray = new float[]{(float)(rectangle.getCenterX() - d / 2.0), (float)(rectangle.getCenterY() + d2 / 2.0), 0.0f};
            return fArray;
        }
        float f2 = (float)rectangle.getCenterX();
        float f3 = (float)rectangle.getCenterY();
        float f4 = (float)rectangle.getWidth();
        float f5 = (float)rectangle.getHeight();
        int[] nArray = new int[]{(int)rectangle.getCenterX(), (int)(rectangle.getCenterX() - d2), (int)(rectangle.getCenterX() + d2), (int)(rectangle.getCenterX() - rectangle.getWidth() / 4.0), (int)(rectangle.getCenterX() - rectangle.getWidth() / 4.0 - d2), (int)(rectangle.getCenterX() - rectangle.getWidth() / 4.0 + d2), (int)(rectangle.getCenterX() + rectangle.getWidth() / 4.0), (int)(rectangle.getCenterX() + rectangle.getWidth() / 4.0 - d2), (int)(rectangle.getCenterX() + rectangle.getWidth() / 4.0 + d2)};
        int[] nArray2 = new int[]{(int)rectangle.getCenterY(), (int)(rectangle.getCenterY() - d2), (int)(rectangle.getCenterY() + d2), (int)(rectangle.getCenterY() - rectangle.getHeight() / 6.0), (int)(rectangle.getCenterY() - rectangle.getHeight() / 6.0 - d2), (int)(rectangle.getCenterY() - rectangle.getHeight() / 6.0 + d2), (int)(rectangle.getCenterY() + rectangle.getHeight() / 6.0), (int)(rectangle.getCenterY() + rectangle.getHeight() / 6.0 - d2), (int)(rectangle.getCenterY() + rectangle.getHeight() / 6.0 + d2), (int)(rectangle.getCenterY() - rectangle.getHeight() / 3.0), (int)(rectangle.getCenterY() - rectangle.getHeight() / 3.0 - d2), (int)(rectangle.getCenterY() - rectangle.getHeight() / 3.0 + d2), (int)(rectangle.getCenterY() + rectangle.getHeight() / 3.0), (int)(rectangle.getCenterY() + rectangle.getHeight() / 3.0 - d2), (int)(rectangle.getCenterY() + rectangle.getHeight() / 3.0 + d2)};
        double[] dArray = new double[18];
        double[] dArray2 = new double[18];
        for (int i = 0; i < 9; ++i) {
            dArray[i] = -(rectangle.getHeight() / rectangle.getWidth());
            dArray[9 + i] = rectangle.getHeight() / rectangle.getWidth();
        }
        double d3 = d2 * Math.sqrt(1.0 + dArray[0] * dArray[0]);
        double d4 = rectangle.getMinY() - dArray[0] * rectangle.getMinX();
        dArray2[0] = rectangle.getHeight() + d4;
        dArray2[1] = dArray2[0] - d3;
        dArray2[2] = dArray2[0] + d3;
        dArray2[3] = rectangle.getHeight() / 2.0 + d4;
        dArray2[4] = dArray2[3] - d3;
        dArray2[5] = dArray2[3] + d3;
        dArray2[6] = rectangle.getHeight() * 1.5 + d4;
        dArray2[7] = dArray2[6] - d3;
        dArray2[8] = dArray2[6] + d3;
        dArray2[9] = d4 = rectangle.getMinY() - dArray[dArray.length / 2] * rectangle.getMinX();
        dArray2[10] = dArray2[9] - d3;
        dArray2[11] = dArray2[9] + d3;
        dArray2[12] = -rectangle.getHeight() / 2.0 + d4;
        dArray2[13] = dArray2[12] - d3;
        dArray2[14] = dArray2[12] + d3;
        dArray2[15] = rectangle.getHeight() / 2.0 + d4;
        dArray2[16] = dArray2[15] - d3;
        dArray2[17] = dArray2[15] + d3;
        int n2 = nArray.length + nArray2.length + dArray.length;
        ArrayList[] arrayListArray = new ArrayList[n2];
        for (int i = 0; i < n2; ++i) {
            arrayListArray[i] = new ArrayList(6);
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        if (pathIterator.isDone()) {
            return null;
        }
        double[] dArray3 = new double[6];
        pathIterator.currentSegment(dArray3);
        pathIterator.next();
        int n3 = (int)dArray3[0];
        int n4 = (int)dArray3[1];
        int n5 = n3;
        int n6 = n4;
        while (!pathIterator.isDone()) {
            int n7;
            int n8;
            block49: {
                block48: {
                    double d5;
                    int n9;
                    n = 0;
                    try {
                        n = pathIterator.currentSegment(dArray3);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    pathIterator.next();
                    n8 = (int)dArray3[0];
                    n7 = (int)dArray3[1];
                    if (n == 0) {
                        n3 = n8;
                        n4 = n7;
                        n5 = n8;
                        n6 = n7;
                        continue;
                    }
                    if (n != 4 && Math.abs(n8 - n3) <= 5 && Math.abs(n7 - n4) <= 5 || n8 == n3 && n7 == n4) continue;
                    double d6 = 0.0;
                    if (n3 - n8 != 0) {
                        d6 = (double)(n7 - n4) / (double)(n8 - n3);
                    }
                    double d7 = (double)n4 - d6 * (double)n3;
                    if (n3 == n8) {
                        if ((double)f4 >= d) {
                            for (n9 = 0; n9 < nArray2.length; ++n9) {
                                if ((nArray2[n9] < n4 || nArray2[n9] > n7) && (nArray2[n9] > n4 || nArray2[n9] < n7)) continue;
                                arrayListArray[n9].add(new PointWithAlpha(n3, nArray2[n9], LabelHelper.getAlphaValue(n8, n7, n3, n4, n3, nArray2[n9], true, false, 0.0, 0.0)));
                            }
                            for (n9 = 0; n9 < nArray.length; ++n9) {
                                if (nArray[n9] != n3) continue;
                                arrayListArray[nArray2.length + n9].add(new PointWithAlpha(n3, n4, 1));
                                arrayListArray[nArray2.length + n9].add(new PointWithAlpha(n8, n7, 1));
                                break;
                            }
                        }
                        if (bl2) {
                            for (n9 = 0; n9 < dArray.length; ++n9) {
                                d5 = dArray[n9] * (double)n3 + dArray2[n9];
                                if (!(d5 >= (double)n4 && d5 <= (double)n7) && (!(d5 <= (double)n4) || !(d5 >= (double)n7))) continue;
                                arrayListArray[nArray.length + nArray2.length + n9].add(new PointWithAlpha(n3, (int)d5, LabelHelper.getAlphaValue(n8, n7, n3, n4, n3, (int)d5, false, false, dArray[n9], dArray2[n9])));
                            }
                        }
                    } else if (n4 == n7) {
                        for (n9 = 0; n9 < nArray2.length; ++n9) {
                            if (nArray2[n9] != n4) continue;
                            arrayListArray[n9].add(new PointWithAlpha(n3, n4, 1));
                            arrayListArray[n9].add(new PointWithAlpha(n8, n7, 1));
                            break;
                        }
                        if (bl2) {
                            if ((double)f5 >= d) {
                                for (n9 = 0; n9 < nArray.length; ++n9) {
                                    if ((nArray[n9] < n3 || nArray[n9] > n8) && (nArray[n9] > n3 || nArray[n9] < n8)) continue;
                                    arrayListArray[nArray2.length + n9].add(new PointWithAlpha(nArray[n9], n4, LabelHelper.getAlphaValue(n8, n7, n3, n4, nArray[n9], n4, false, true, 0.0, 0.0)));
                                }
                            }
                            for (n9 = 0; n9 < dArray.length; ++n9) {
                                d5 = ((double)n4 - dArray2[n9]) / dArray[n9];
                                if (!(d5 >= (double)n3 && d5 <= (double)n8) && (!(d5 <= (double)n3) || !(d5 >= (double)n8))) continue;
                                arrayListArray[nArray.length + nArray2.length + n9].add(new PointWithAlpha((int)d5, n4, LabelHelper.getAlphaValue(n8, n7, n3, n4, (int)d5, n4, false, false, dArray[n9], dArray2[n9])));
                            }
                        }
                    } else {
                        for (n9 = 0; n9 < nArray2.length; ++n9) {
                            d5 = nArray2[n9] == n4 ? (double)n3 : (nArray2[n9] == n7 ? (double)n8 : ((double)nArray2[n9] - d7) / d6);
                            if (!((double)f4 > d) || !(d5 <= (double)n3 && d5 >= (double)n8) && (!(d5 >= (double)n3) || !(d5 <= (double)n8))) continue;
                            arrayListArray[n9].add(new PointWithAlpha((int)d5, nArray2[n9], LabelHelper.getAlphaValue(n8, n7, n3, n4, (int)d5, nArray2[n9], true, false, 0.0, 0.0)));
                        }
                        if (bl2) {
                            for (n9 = 0; n9 < nArray.length; ++n9) {
                                d5 = nArray[n9] == n8 ? (double)n7 : (nArray[n9] == n3 ? (double)n4 : d6 * (double)nArray[n9] + d7);
                                if (!((double)f5 > d) || !(d5 <= (double)n4 && d5 >= (double)n7) && (!(d5 >= (double)n4) || !(d5 <= (double)n7))) continue;
                                arrayListArray[n9 + nArray2.length].add(new PointWithAlpha(nArray[n9], (int)d5, LabelHelper.getAlphaValue(n8, n7, n3, n4, nArray[n9], (int)d5, false, true, 0.0, 0.0)));
                            }
                            for (n9 = 0; n9 < dArray.length; ++n9) {
                                if (d6 != dArray[n9]) {
                                    d5 = (d7 - dArray2[n9]) / (dArray[n9] - d6);
                                    if (!(d5 <= (double)n8 && d5 >= (double)n3) && (!(d5 >= (double)n8) || !(d5 <= (double)n3))) continue;
                                    arrayListArray[nArray.length + nArray2.length + n9].add(new PointWithAlpha((int)d5, (int)(d5 * d6 + d7), LabelHelper.getAlphaValue(n8, n7, n3, n4, (int)d5, (int)(d5 * d6 + d7), false, false, dArray[n9], dArray2[n9])));
                                    continue;
                                }
                                arrayListArray[nArray.length + nArray2.length + n9].add(new PointWithAlpha(n3, n4, 1));
                                arrayListArray[nArray.length + nArray2.length + n9].add(new PointWithAlpha(n8, n7, 1));
                                break;
                            }
                        }
                    }
                    if (n == 0) break block48;
                    if (n != 4) break block49;
                }
                n3 = (int)dArray3[0];
                n4 = (int)dArray3[1];
                continue;
            }
            n3 = n8;
            n4 = n7;
        }
        for (n = 0; n < arrayListArray.length; n += 3) {
            Point2D point2D = LabelHelper.findPointInPointArray(graphics2D, arrayListArray, n, rectangle, d, d2, rectArrayArray, bl, rectangle2D);
            if (point2D == null) continue;
            double d8 = 0.0;
            d8 = n < nArray2.length ? 0.0 : (n < nArray.length + nArray2.length ? -1.5707963267948966 : Math.atan(dArray[n - nArray.length - nArray2.length]));
            float[] fArray = new float[]{(float)point2D.getX(), (float)point2D.getY(), (float)d8};
            return fArray;
        }
        if (!bl) {
            return null;
        }
        float[] fArray = new float[]{(float)(rectangle.getCenterX() - d / 2.0), (float)(rectangle.getCenterY() + d2 / 2.0), 0.0f};
        if (rectangle2D != null) {
            if (rectangle2D.getWidth() < d || rectangle2D.getHeight() < d2) {
                return null;
            }
            if ((double)fArray[0] < rectangle2D.getMinX()) {
                fArray[0] = (float)rectangle2D.getMinX();
            } else if ((double)fArray[0] + d > rectangle2D.getMaxX()) {
                fArray[0] = (float)(rectangle2D.getMaxX() - d);
            }
            if ((double)fArray[1] < rectangle2D.getMinY()) {
                fArray[1] = (float)rectangle2D.getMinY();
            } else if ((double)fArray[1] + d > rectangle2D.getMaxY()) {
                fArray[1] = (float)(rectangle2D.getMaxY() - d2);
            }
        }
        return fArray;
    }

    private static int getAlphaValue(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, double d, double d2) {
        if (!(n == n5 && n2 == n6 || n3 == n5 && n4 == n6)) {
            return 0;
        }
        if (n3 == n5 && n4 == n6) {
            int n7 = n;
            n = n3;
            n3 = n7;
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if (bl) {
            if (n4 < n6) {
                return -1;
            }
            return 1;
        }
        if (bl2) {
            if (n3 < n5) {
                return -1;
            }
            return 1;
        }
        if ((double)n4 < d * (double)n3 + d2) {
            return -1;
        }
        return 1;
    }

    private static Point2D findPointInPointArray(Graphics2D graphics2D, ArrayList[] arrayListArray, int n, Rectangle rectangle, double d, double d2, RectArray[] rectArrayArray, boolean bl, Rectangle2D rectangle2D) {
        int n2;
        PointWithAlpha pointWithAlpha;
        PointWithAlpha pointWithAlpha2;
        int n3;
        ArrayList arrayList = arrayListArray[n];
        ArrayList arrayList2 = arrayListArray[n + 1];
        ArrayList arrayList3 = arrayListArray[n + 2];
        LabelHelper.sortPointArray(arrayList);
        LabelHelper.sortPointArray(arrayList2);
        LabelHelper.sortPointArray(arrayList3);
        int n4 = -1;
        Point2D.Double double_ = null;
        if (arrayList.size() == 0) {
            return null;
        }
        double d3 = rectangle.getCenterX();
        double d4 = rectangle.getCenterY();
        if (((PointWithAlpha)arrayList.get(0)).getX() != ((PointWithAlpha)arrayList.get(arrayList.size() - 1)).getX()) {
            for (n3 = 0; n3 < arrayList.size() - 1; n3 += 2) {
                pointWithAlpha2 = (PointWithAlpha)arrayList.get(n3);
                pointWithAlpha = (PointWithAlpha)arrayList.get(n3 + 1);
                if ((double)pointWithAlpha2.getX() >= d3) {
                    n4 = n3;
                    break;
                }
                if (n3 + 1 >= arrayList.size()) {
                    n4 = n3;
                    break;
                }
                if (!((double)pointWithAlpha2.getX() <= d3) || !((double)pointWithAlpha.getX() >= d3)) continue;
                n4 = n3;
                break;
            }
            if (n4 < 0) {
                n4 = (arrayList.size() - 2) / 2 * 2;
            }
        } else {
            for (n3 = 0; n3 < arrayList.size() - 1; n3 += 2) {
                pointWithAlpha2 = (PointWithAlpha)arrayList.get(n3);
                pointWithAlpha = (PointWithAlpha)arrayList.get(n3 + 1);
                if ((double)pointWithAlpha2.getY() >= d4) {
                    n4 = n3;
                    break;
                }
                if (n3 + 1 >= arrayList.size()) {
                    n4 = n3;
                    break;
                }
                if (!((double)pointWithAlpha2.getY() <= d4) || !((double)pointWithAlpha.getY() >= d4)) continue;
                n4 = n3;
                break;
            }
            if (n4 < 0) {
                n4 = (arrayList.size() - 2) / 2 * 2;
            }
        }
        if (n4 == arrayList.size() - 1) {
            n4 -= 2;
        }
        for (n2 = n4; n2 >= 0; n2 -= 2) {
            double_ = LabelHelper.findPointOnSegment((PointWithAlpha)arrayList.get(n2), (PointWithAlpha)arrayList.get(n2 + 1), arrayList2, arrayList3, d, d2, arrayListArray, rectArrayArray, bl, rectangle2D);
            if (double_ == null) continue;
            return double_;
        }
        for (n2 = n4 + 2; n2 < arrayList.size() - 1; n2 += 2) {
            double_ = LabelHelper.findPointOnSegment((PointWithAlpha)arrayList.get(n2), (PointWithAlpha)arrayList.get(n2 + 1), arrayList2, arrayList3, d, d2, arrayListArray, rectArrayArray, bl, rectangle2D);
            if (double_ == null) continue;
            return double_;
        }
        return double_;
    }

    private static boolean segmentValidInPointArray(ArrayList arrayList, double d, double d2, double d3) {
        if (arrayList.size() < 2) {
            return false;
        }
        PointWithAlpha pointWithAlpha = (PointWithAlpha)arrayList.get(0);
        PointWithAlpha pointWithAlpha2 = (PointWithAlpha)arrayList.get(arrayList.size() - 1);
        if (pointWithAlpha.getX() == pointWithAlpha2.getX() && pointWithAlpha.getY() == pointWithAlpha2.getY()) {
            return false;
        }
        if (pointWithAlpha.getX() - pointWithAlpha2.getX() == 0) {
            for (int i = 0; i < arrayList.size() - 1; i += 2) {
                pointWithAlpha = (PointWithAlpha)arrayList.get(i);
                pointWithAlpha2 = (PointWithAlpha)arrayList.get(i + 1);
                if ((double)pointWithAlpha.getY() > d2) {
                    return false;
                }
                if (!(d2 >= (double)pointWithAlpha.getY()) || !(d2 <= (double)pointWithAlpha2.getY()) || !((double)pointWithAlpha2.getY() - d2 > d3)) continue;
                return true;
            }
        } else {
            for (int i = 0; i < arrayList.size() - 1; i += 2) {
                pointWithAlpha = (PointWithAlpha)arrayList.get(i);
                pointWithAlpha2 = (PointWithAlpha)arrayList.get(i + 1);
                if ((double)pointWithAlpha.getX() > d) {
                    return false;
                }
                if (!(d >= (double)pointWithAlpha.getX()) || !(d <= (double)pointWithAlpha2.getX()) || !((d - (double)pointWithAlpha2.getX()) * (d - (double)pointWithAlpha2.getX()) + (d2 - (double)pointWithAlpha2.getY()) * (d2 - (double)pointWithAlpha2.getY()) > d3 * d3)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean rectConflictsWithRectArrays(RectArray[] rectArrayArray, Rectangle2D rectangle2D) {
        if (rectArrayArray == null) {
            return false;
        }
        for (int i = 0; i < rectArrayArray.length; ++i) {
            if (!rectArrayArray[i].conflicts(rectangle2D)) continue;
            return true;
        }
        return false;
    }

    public static boolean rectConflictsWithRectArrays(RectArray[] rectArrayArray, double d, double d2, double d3, double d4) {
        if (rectArrayArray == null) {
            return false;
        }
        for (int i = 0; i < rectArrayArray.length; ++i) {
            if (rectArrayArray[i] == null || !rectArrayArray[i].conflicts(d, d2, d3, d4)) continue;
            return true;
        }
        return false;
    }

    public static void insertRectIntoRectArrays(RectArray[] rectArrayArray, Rectangle2D rectangle2D) {
        if (rectArrayArray == null) {
            return;
        }
        for (int i = 0; i < rectArrayArray.length; ++i) {
            if (rectArrayArray[i] == null) continue;
            rectArrayArray[i].insert(rectangle2D);
        }
    }

    public static void insertRectIntoRectArrays(RectArray[] rectArrayArray, double d, double d2, double d3, double d4) {
        if (rectArrayArray == null) {
            return;
        }
        for (int i = 0; i < rectArrayArray.length; ++i) {
            if (rectArrayArray[i] == null) continue;
            rectArrayArray[i].insert(d, d2, d3, d4);
        }
    }

    private static Point2D.Double findPointOnSegment(PointWithAlpha pointWithAlpha, PointWithAlpha pointWithAlpha2, ArrayList arrayList, ArrayList arrayList2, double d, double d2, ArrayList[] arrayListArray, RectArray[] rectArrayArray, boolean bl, Rectangle2D rectangle2D) {
        Point2D.Double double_ = null;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl2 = false;
        if (pointWithAlpha.getX() == pointWithAlpha2.getX()) {
            d3 = pointWithAlpha2.getY() - pointWithAlpha.getY();
            if (d3 > d) {
                Rectangle2D.Double double_2;
                double d8;
                double d9 = (double)pointWithAlpha.getX() - d2;
                if (LabelHelper.segmentValidInPointArray(arrayList, d9, d8 = (double)pointWithAlpha.getY() + (d3 - d) / 2.0, d)) {
                    double_2 = new Rectangle2D.Double(d9, d8, d2, d);
                    if (rectangle2D == null || rectangle2D.contains(double_2)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, double_2)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, double_2);
                            return new Point2D.Double(d9 + d2, d8 + d);
                        }
                        if (bl) {
                            bl2 = true;
                            d6 = d9;
                            d7 = d8 + d;
                            d4 = d9;
                            d5 = d8;
                        }
                    }
                }
                if (LabelHelper.segmentValidInPointArray(arrayList2, d9, d8, d)) {
                    double_2 = new Rectangle2D.Double(d9 + d2, d8, d2, d);
                    if (rectangle2D == null || rectangle2D.contains(double_2)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d9 + d2, d8, d2, d)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d9 + d2, d8, d2, d);
                            return new Point2D.Double(d9 + d2 + d2, d8 + d);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d9 + d2;
                            d7 = d8 + d;
                            d4 = d9 + d2;
                            d5 = d8;
                        }
                    }
                }
                if (d3 > d * 2.0) {
                    d8 = (double)pointWithAlpha.getY() + (d3 / 2.0 - d) / 2.0;
                    double_2 = new Rectangle2D.Double(d9, d8, d2, d);
                    if ((rectangle2D == null || rectangle2D.contains(double_2)) && LabelHelper.segmentValidInPointArray(arrayList, d9, d8, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d9, d8, d2, d)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d9, d8, d2, d);
                            return new Point2D.Double(d9 + d2, d8 + d);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d9;
                            d7 = d8 + d;
                            d4 = d9;
                            d5 = d8;
                        }
                    }
                    double_2 = new Rectangle2D.Double(d9 + d2, d8, d2, d);
                    if ((rectangle2D == null || rectangle2D.contains(double_2)) && LabelHelper.segmentValidInPointArray(arrayList2, d9, d8, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d9 + d2, d8, d2, d)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d9 + d2, d8, d2, d);
                            return new Point2D.Double(d9 + d2 + d2, d8 + d);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d9 + d2;
                            d7 = d8 + d;
                            d4 = d9 + d2;
                            d5 = d8;
                        }
                    }
                    d8 = (double)pointWithAlpha.getY() + (3.0 * d3 / 2.0 - d) / 2.0;
                    double_2 = new Rectangle2D.Double(d9, d8, d2, d);
                    if ((rectangle2D == null || rectangle2D.contains(double_2)) && LabelHelper.segmentValidInPointArray(arrayList, d9, d8, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d9, d8, d2, d)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d9, d8, d2, d);
                            return new Point2D.Double(d9 + d2, d8 + d);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d9;
                            d7 = d8 + d;
                            d4 = d9;
                            d5 = d8;
                        }
                    }
                    double_2 = new Rectangle2D.Double(d9 + d2, d8, d2, d);
                    if ((rectangle2D == null || rectangle2D.contains(double_2)) && LabelHelper.segmentValidInPointArray(arrayList2, d9, d8, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d9 + d2, d8, d2, d)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d9 + d2, d8, d2, d);
                            return new Point2D.Double(d9 + d2 + d2, d8 + d);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d9 + d2;
                            d7 = d8 + d;
                            d4 = d9 + d2;
                            d5 = d8;
                        }
                    }
                }
            }
            double d10 = d;
            d2 = d = d2;
        } else if (pointWithAlpha.getY() == pointWithAlpha2.getY()) {
            d3 = pointWithAlpha2.getX() - pointWithAlpha.getX();
            if (d3 > d) {
                double d11 = (double)pointWithAlpha.getX() + (d3 - d) / 2.0;
                double d12 = (double)pointWithAlpha.getY() - d2;
                Rectangle2D.Double double_3 = new Rectangle2D.Double(d11, d12, d, d2);
                if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList, d11, d12, d)) {
                    if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12, d, d2)) {
                        LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12, d, d2);
                        return new Point2D.Double(d11, d12 + d2);
                    }
                    if (bl && !bl2) {
                        bl2 = true;
                        d6 = d11;
                        d7 = d12;
                        d4 = d11;
                        d5 = d12;
                    }
                }
                double_3 = new Rectangle2D.Double(d11, d12 + d2, d, d2);
                if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList2, d11, d12 + d2, d)) {
                    if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12 + d2, d, d2)) {
                        LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12 + d2, d, d2);
                        return new Point2D.Double(d11, d12 + d2 + d2);
                    }
                    if (bl && !bl2) {
                        bl2 = true;
                        d6 = d11;
                        d7 = d12 + d2;
                        d4 = d11;
                        d5 = d12 + d2;
                    }
                }
                if (d3 > d * 1.5) {
                    d11 = (double)pointWithAlpha.getX() + (d3 / 3.0 - d / 2.0);
                    double_3 = new Rectangle2D.Double(d11, d12, d, d2);
                    if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList, d11, d12, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12, d, d2)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12, d, d2);
                            return new Point2D.Double(d11, d12 + d2);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d11;
                            d7 = d12;
                            d4 = d11;
                            d5 = d12;
                        }
                    }
                    double_3 = new Rectangle2D.Double(d11, d12 + d2, d, d2);
                    if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList2, d11, d12 + d2, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12 + d2, d, d2)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12 + d2, d, d2);
                            return new Point2D.Double(d11, d12 + d2 + d2);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d11;
                            d7 = d12 + d2;
                            d4 = d11;
                            d5 = d12 + d2;
                        }
                    }
                    d11 = (double)pointWithAlpha.getX() + (2.0 * d3 / 3.0 - d / 2.0);
                    double_3 = new Rectangle2D.Double(d11, d12, d, d2);
                    if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList, d11, d12, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12, d, d2)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12, d, d2);
                            return new Point2D.Double(d11, d12 + d2);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d11;
                            d7 = d12;
                            d4 = d11;
                            d5 = d12;
                        }
                    }
                    double_3 = new Rectangle2D.Double(d11, d12 + d2, d, d2);
                    if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList2, d11, d12 + d2, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12 + d2, d, d2)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12 + d2, d, d2);
                            return new Point2D.Double(d11, d12 + d2 + d2);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d11;
                            d7 = d12 + d2;
                            d4 = d11;
                            d5 = d12 + d2;
                        }
                    }
                }
                if (d3 > d * 3.0) {
                    d11 = (double)pointWithAlpha.getX() + (d3 / 6.0 - d / 2.0);
                    double_3 = new Rectangle2D.Double(d11, d12, d, d2);
                    if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList, d11, d12, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12, d, d2)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12, d, d2);
                            return new Point2D.Double(d11, d12 + d2);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d11;
                            d7 = d12;
                            d4 = d11;
                            d5 = d12;
                        }
                    }
                    double_3 = new Rectangle2D.Double(d11, d12 + d2, d, d2);
                    if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList2, d11, d12 + d2, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12 + d2, d, d2)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12 + d2, d, d2);
                            return new Point2D.Double(d11, d12 + d2 + d2);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d11;
                            d7 = d12 + d2;
                            d4 = d11;
                            d5 = d12 + d2;
                        }
                    }
                    d11 = (double)pointWithAlpha.getX() + (5.0 * d3 / 6.0 - d / 2.0);
                    double_3 = new Rectangle2D.Double(d11, d12, d, d2);
                    if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList, d11, d12, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12, d, d2)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12, d, d2);
                            return new Point2D.Double(d11, d12 + d2);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d11;
                            d7 = d12;
                            d4 = d11;
                            d5 = d12;
                        }
                    }
                    double_3 = new Rectangle2D.Double(d11, d12 + d2, d, d2);
                    if ((rectangle2D == null || rectangle2D.contains(double_3)) && LabelHelper.segmentValidInPointArray(arrayList2, d11, d12 + d2, d)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, d11, d12 + d2, d, d2)) {
                            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d11, d12 + d2, d, d2);
                            return new Point2D.Double(d11, d12 + d2 + d2);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d11;
                            d7 = d12 + d2;
                            d4 = d11;
                            d5 = d12 + d2;
                        }
                    }
                }
            }
        } else {
            d3 = Math.sqrt((pointWithAlpha2.getX() - pointWithAlpha.getX()) * (pointWithAlpha2.getX() - pointWithAlpha.getX()) + (pointWithAlpha2.getY() - pointWithAlpha.getY()) * (pointWithAlpha2.getY() - pointWithAlpha.getY()));
            if (d3 > d) {
                double d13 = Math.atan((double)(pointWithAlpha2.getY() - pointWithAlpha.getY()) / (double)(pointWithAlpha2.getX() - pointWithAlpha.getX()));
                double d14 = Math.cos(d13);
                double d15 = Math.sin(d13);
                double d16 = d14 * (d + d2);
                double d17 = Math.abs(d15 * (d + d2));
                double d18 = d15 * d2;
                double d19 = d14 * d2;
                double d20 = (double)pointWithAlpha.getX() + (d3 - d) * (double)(pointWithAlpha2.getX() - pointWithAlpha.getX()) / (2.0 * d3);
                double d21 = (double)pointWithAlpha.getY() + (d3 - d) * (double)(pointWithAlpha2.getY() - pointWithAlpha.getY()) / (2.0 * d3);
                double d22 = (double)pointWithAlpha.getX() + (d3 + d) * (double)(pointWithAlpha2.getX() - pointWithAlpha.getX()) / (2.0 * d3);
                double d23 = (double)pointWithAlpha.getY() + (d3 + d) * (double)(pointWithAlpha2.getY() - pointWithAlpha.getY()) / (2.0 * d3);
                if ((rectangle2D == null || rectangle2D.contains(d20, d21) && rectangle2D.contains(d22, d23)) && LabelHelper.segmentValidInPointArray(arrayList, d20 + d18, d21 - d19, d)) {
                    if (!LabelHelper.lineConflictsWithRectArray(rectArrayArray, d20, d21, d22, d23, d2)) {
                        return new Point2D.Double(d20, d21);
                    }
                    if (bl && !bl2) {
                        bl2 = true;
                        d6 = d20;
                        d7 = d21;
                        d4 = d20;
                        double d24 = d5 = d15 > 0.0 ? d21 : d21 - d17;
                    }
                }
                if ((rectangle2D == null || rectangle2D.contains(d20 - d18, d21 + d19) && rectangle2D.contains(d22 - d18, d23 + d19)) && LabelHelper.segmentValidInPointArray(arrayList2, d20 - d18, d21 + d19, d)) {
                    if (!LabelHelper.lineConflictsWithRectArray(rectArrayArray, d20 - d18, d21 + d19, d22 - d18, d23 + d19, d2)) {
                        return new Point2D.Double(d20 - d18, d21 + d19);
                    }
                    if (bl && !bl2) {
                        bl2 = true;
                        d6 = d20 - d18;
                        d7 = d21 + d19;
                        d4 = d6;
                        d5 = (d15 > 0.0 ? d21 : d21 - d17) + d19;
                    }
                }
                if (d3 > d * 2.0) {
                    d20 = (double)pointWithAlpha.getX() + (d3 / 2.0 - d) * (double)(pointWithAlpha2.getX() - pointWithAlpha.getX()) / (2.0 * d3);
                    d21 = (double)pointWithAlpha.getY() + (d3 / 2.0 - d) * (double)(pointWithAlpha2.getY() - pointWithAlpha.getY()) / (2.0 * d3);
                    d22 = (double)pointWithAlpha.getX() + (d3 / 2.0 + d) * (double)(pointWithAlpha2.getX() - pointWithAlpha.getX()) / (2.0 * d3);
                    d23 = (double)pointWithAlpha.getY() + (d3 / 2.0 + d) * (double)(pointWithAlpha2.getY() - pointWithAlpha.getY()) / (2.0 * d3);
                    if ((rectangle2D == null || rectangle2D.contains(d20, d21) && rectangle2D.contains(d22, d23)) && LabelHelper.segmentValidInPointArray(arrayList, d20 + d18, d21 - d19, d)) {
                        if (!LabelHelper.lineConflictsWithRectArray(rectArrayArray, d20, d21, d22, d23, d2)) {
                            return new Point2D.Double(d20, d21);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d20;
                            d7 = d21;
                            d4 = d20;
                            double d25 = d5 = d15 > 0.0 ? d21 : d21 - d17;
                        }
                    }
                    if ((rectangle2D == null || rectangle2D.contains(d20 - d18, d21 + d19) && rectangle2D.contains(d22 - d18, d23 + d19)) && LabelHelper.segmentValidInPointArray(arrayList2, d20 - d18, d21 + d19, d)) {
                        if (!LabelHelper.lineConflictsWithRectArray(rectArrayArray, d20 - d18, d21 + d19, d22 - d18, d23 + d19, d2)) {
                            return new Point2D.Double(d20 - d18, d21 + d19);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d20 - d18;
                            d7 = d21 + d19;
                            d4 = d6;
                            d5 = (d15 > 0.0 ? d21 : d21 - d17) + d19;
                        }
                    }
                    d20 = (double)pointWithAlpha.getX() + (3.0 * d3 / 2.0 - d) * (double)(pointWithAlpha2.getX() - pointWithAlpha.getX()) / (2.0 * d3);
                    d21 = (double)pointWithAlpha.getY() + (3.0 * d3 / 2.0 - d) * (double)(pointWithAlpha2.getY() - pointWithAlpha.getY()) / (2.0 * d3);
                    d22 = (double)pointWithAlpha.getX() + (3.0 * d3 / 2.0 + d) * (double)(pointWithAlpha2.getX() - pointWithAlpha.getX()) / (2.0 * d3);
                    d23 = (double)pointWithAlpha.getY() + (3.0 * d3 / 2.0 + d) * (double)(pointWithAlpha2.getY() - pointWithAlpha.getY()) / (2.0 * d3);
                    if ((rectangle2D == null || rectangle2D.contains(d20, d21) && rectangle2D.contains(d22, d23)) && LabelHelper.segmentValidInPointArray(arrayList, d20 + d18, d21 - d19, d)) {
                        if (!LabelHelper.lineConflictsWithRectArray(rectArrayArray, d20, d21, d22, d23, d2)) {
                            return new Point2D.Double(d20, d21);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d20;
                            d7 = d21;
                            d4 = d20;
                            double d26 = d5 = d15 > 0.0 ? d21 : d21 - d17;
                        }
                    }
                    if ((rectangle2D == null || rectangle2D.contains(d20 - d18, d21 + d19) && rectangle2D.contains(d22 - d18, d23 + d19)) && LabelHelper.segmentValidInPointArray(arrayList2, d20 - d18, d21 + d19, d)) {
                        if (!LabelHelper.lineConflictsWithRectArray(rectArrayArray, d20 - d18, d21 + d19, d22 - d18, d23 + d19, d2)) {
                            return new Point2D.Double(d20 - d18, d21 + d19);
                        }
                        if (bl && !bl2) {
                            bl2 = true;
                            d6 = d20 - d18;
                            d7 = d21 + d19;
                            d4 = d6;
                            d5 = (d15 > 0.0 ? d21 : d21 - d17) + d19;
                        }
                    }
                }
                d = d16;
                d2 = d17;
            }
        }
        if (bl && bl2) {
            LabelHelper.insertRectIntoRectArrays(rectArrayArray, d4, d5, d, d2);
            return new Point2D.Double(d6, d7);
        }
        return double_;
    }

    private static void sortPointArray(ArrayList arrayList) {
        PointWithAlpha pointWithAlpha;
        PointWithAlpha pointWithAlpha2;
        int n;
        boolean bl = true;
        while (bl) {
            bl = false;
            for (n = 0; n < arrayList.size() - 1; ++n) {
                pointWithAlpha2 = (PointWithAlpha)arrayList.get(n);
                pointWithAlpha = (PointWithAlpha)arrayList.get(n + 1);
                if (pointWithAlpha2.getX() > pointWithAlpha.getX()) {
                    arrayList.set(n, pointWithAlpha);
                    arrayList.set(n + 1, pointWithAlpha2);
                    bl = true;
                    continue;
                }
                if (pointWithAlpha2.getX() != pointWithAlpha.getX() || pointWithAlpha2.getY() <= pointWithAlpha.getY()) continue;
                arrayList.set(n, pointWithAlpha);
                arrayList.set(n + 1, pointWithAlpha2);
                bl = true;
            }
        }
        n = 0;
        while (n < arrayList.size() - 1) {
            pointWithAlpha2 = (PointWithAlpha)arrayList.get(n);
            pointWithAlpha = (PointWithAlpha)arrayList.get(n + 1);
            if (pointWithAlpha2.getY() == pointWithAlpha.getY() && pointWithAlpha2.getX() == pointWithAlpha.getX()) {
                if (pointWithAlpha2.getAlpha() * pointWithAlpha.getAlpha() == -1) {
                    arrayList.remove(n);
                    continue;
                }
                arrayList.remove(n);
                arrayList.remove(n);
                continue;
            }
            ++n;
        }
    }

    public static ArrayList getBoundingRectsWithoutConflicts(RectArray rectArray, double d, double d2, double d3, double d4, double d5) {
        RectArray[] rectArrayArray = new RectArray[]{rectArray};
        return LabelHelper.getBoundingRectsWithoutConflicts(rectArrayArray, d, d2, d3, d4, d5);
    }

    public static ArrayList getBoundingRectsWithoutConflicts(RectArray[] rectArrayArray, double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        if (d == d3) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d - d5, Math.min(d2, d4), d5, Math.abs(d4 - d2));
            if (LabelHelper.rectConflictsWithRectArrays(rectArrayArray, double_)) {
                return null;
            }
            ArrayList<Rectangle2D.Double> arrayList = new ArrayList<Rectangle2D.Double>(1);
            arrayList.add(double_);
            return arrayList;
        }
        if (d2 == d4) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(Math.min(d, d3), d2 - d5, Math.abs(d3 - d), d5);
            if (LabelHelper.rectConflictsWithRectArrays(rectArrayArray, double_)) {
                return null;
            }
            ArrayList<Rectangle2D.Double> arrayList = new ArrayList<Rectangle2D.Double>(1);
            arrayList.add(double_);
            return arrayList;
        }
        double d8 = Math.abs(d3 - d);
        double d9 = Math.abs(d4 - d2);
        double d10 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        double d11 = (d4 - d2) * 1.0 / (d3 - d);
        double d12 = d5 * d9 / d10;
        double d13 = d5 * d8 / d10;
        double d14 = (1.0 * d2 * d3 - d * d4) / (d3 - d);
        if (d < d3) {
            d7 = d14;
            d14 -= d5 * d10 / d8;
            if (d2 < d4) {
                d += d12;
                d2 -= d13;
                d3 += d12;
                d4 -= d13;
            } else {
                d -= d12;
                d2 -= d13;
                d3 -= d12;
                d4 -= d13;
            }
        } else {
            d7 = d14 + d5 * d10 / d8;
        }
        if (d2 > d4) {
            d6 = d;
            d = d3;
            d3 = d6;
            d6 = d2;
            d2 = d4;
            d4 = d6;
        }
        d6 = Math.max(10.0, d5);
        ArrayList<Rectangle2D.Double> arrayList = new ArrayList<Rectangle2D.Double>((int)(d8 / d6 + 1.0));
        d6 = d3 < d ? -d6 : d6;
        double d15 = d + (d < d3 ? -d12 : d12);
        double d16 = d2;
        while (d6 > 0.0 && d15 < d3 || d6 < 0.0 && d15 > d3) {
            double d17 = d15 + d6;
            if (d6 > 0.0 && d17 > d3 || d6 < 0.0 && d17 < d3) {
                d17 = d3;
            }
            double d18 = d17 * d11 + d7;
            d18 = Math.min(d18, d4 + d5);
            Rectangle2D.Double double_ = new Rectangle2D.Double(Math.min(d15, d17), Math.min(d16, d18), Math.abs(d17 - d15), Math.abs(d18 - d16));
            if (LabelHelper.rectConflictsWithRectArrays(rectArrayArray, double_)) {
                return null;
            }
            arrayList.add(double_);
            d15 = d17;
            d16 = d17 * d11 + d14;
        }
        return arrayList;
    }

    public static boolean lineConflictsWithRectArray(RectArray[] rectArrayArray, double d, double d2, double d3, double d4, double d5) {
        ArrayList arrayList = LabelHelper.getBoundingRectsWithoutConflicts(rectArrayArray, d, d2, d3, d4, d5);
        if (arrayList == null) {
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelHelper.insertRectIntoRectArrays(rectArrayArray, (Rectangle2D)arrayList.get(i));
        }
        return false;
    }
}

