/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CoordArray;
import oracle.sdovis.DataException;
import oracle.sdovis.Unpickle81;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class JSDOGeometry
extends JGeometry
implements Cloneable,
Serializable {
    static final long serialVersionUID = -4792272186565640701L;
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    boolean reoriented = false;

    protected JSDOGeometry(int n, int n2) {
        super(n, n2);
    }

    public JSDOGeometry(int n, int n2, double d, double d2, double d3, int[] nArray, double[] dArray) {
        super(n, n2, d, d2, d3, nArray, dArray);
    }

    public JSDOGeometry(int n, int n2, int[] nArray, double[] dArray) {
        super(n, n2, nArray, dArray);
    }

    public JSDOGeometry(double d, double d2, int n) {
        super(d, d2, n);
    }

    public JSDOGeometry(double d, double d2, double d3, int n) {
        super(d, d2, d3, n);
    }

    public JSDOGeometry(double d, double d2, double d3, double d4, int n) {
        super(d, d2, d3, d4, n);
    }

    public Object clone() {
        JSDOGeometry jSDOGeometry = (JSDOGeometry)super.clone();
        return jSDOGeometry;
    }

    public static JSDOGeometry recast(JGeometry jGeometry) {
        if (jGeometry == null) {
            return null;
        }
        double[] dArray = jGeometry.getLabelPointXYZ();
        int n = jGeometry.getType();
        int n2 = jGeometry.getDimensions();
        int n3 = jGeometry.getLRMDimension();
        int n4 = n2 * 1000 + n3 * 100 + n;
        JSDOGeometry jSDOGeometry = new JSDOGeometry(n4, jGeometry.getSRID(), dArray[0], dArray[1], dArray[2], jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        return jSDOGeometry;
    }

    public static JSDOGeometry setOrientation(JSDOGeometry jSDOGeometry, double d, double d2) {
        if (jSDOGeometry == null) {
            return null;
        }
        int n = jSDOGeometry.getType();
        if (n != 1) {
            return jSDOGeometry;
        }
        int n2 = jSDOGeometry.getDimensions();
        int n3 = jSDOGeometry.getLRMDimension();
        int n4 = n2 * 1000 + n3 * 100 + n;
        double[] dArray = jSDOGeometry.getLabelPointXYZ();
        int[] nArray = new int[]{1, 1, 1, 3, 1, 0};
        double[] dArray2 = new double[4];
        if (dArray != null) {
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
        } else {
            double[] dArray3 = jSDOGeometry.getOrdinatesArray();
            dArray2[0] = dArray3[0];
            dArray2[1] = dArray3[1];
        }
        dArray2[2] = d;
        dArray2[3] = d2;
        return new JSDOGeometry(n4, jSDOGeometry.getSRID(), nArray, dArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSDOGeometry(double d, double d2, double d3, double d4, int n, int n2, Connection connection) throws DataException, SQLException {
        super(3, n2);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(" SELECT count(*) from mdsys.geodetic_srids where srid = ?");
            preparedStatement.setInt(1, n2);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n3 = resultSet.getInt(1);
            if (n3 == 0) {
                throw new DataException("an srid exists in geodetic_srids view is required.");
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (n != 1003 && n != 2003) {
            throw new DataException("an SDO_ETYPE value of 1003 or 2003 is required.");
        }
        if (d2 > d4) {
            throw new DataException("minY must be less than maxY.");
        }
        this.elemInfo = new int[3];
        this.elemInfo[0] = 1;
        this.elemInfo[1] = n;
        this.elemInfo[2] = 5;
        this.ordinates = new double[4];
        this.ordinates[0] = d;
        this.ordinates[1] = d2;
        this.ordinates[2] = d3;
        this.ordinates[3] = d4;
    }

    public boolean LoadedAndReoriented() {
        return this.reoriented;
    }

    private void transformCoords(AffineTransform affineTransform) {
    }

    public static final JSDOGeometry loadFromDB(STRUCT sTRUCT) throws SQLException {
        double[] dArray;
        Datum[] datumArray;
        if (sTRUCT == null) {
            return null;
        }
        Datum[] datumArray2 = sTRUCT.getOracleAttributes();
        int n = datumArray2[0] != null ? datumArray2[0].intValue() : 0;
        int n2 = datumArray2[1] != null ? datumArray2[1].intValue() : 0;
        STRUCT sTRUCT2 = (STRUCT)datumArray2[2];
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        if (sTRUCT2 != null) {
            datumArray = sTRUCT2.getOracleAttributes();
            if (datumArray[0] != null && datumArray[1] != null) {
                d = datumArray[0].doubleValue();
                d2 = datumArray[1].doubleValue();
            }
            if (datumArray[2] != null) {
                d3 = datumArray[2].doubleValue();
            }
        }
        datumArray = datumArray2[3] != null ? ((ARRAY)datumArray2[3]).getIntArray() : null;
        double[] dArray2 = dArray = datumArray2[4] != null ? ((ARRAY)datumArray2[4]).getDoubleArray() : null;
        if (dArray != null && datumArray != null) {
            boolean bl = JSDOGeometry.nonOracleETypeExists((int[])datumArray);
            if (!bl) {
                return new JSDOGeometry(n, n2, d, d2, d3, (int[])datumArray, dArray);
            }
            return JSDOGeometry.removeEType0(n, n2, d, d2, d3, (int[])datumArray, dArray);
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            if (!Double.isNaN(d3)) {
                return new JSDOGeometry(d, d2, d3, n2);
            }
            return new JSDOGeometry(d, d2, n2);
        }
        return null;
    }

    public static boolean nonOracleETypeExists(int[] nArray) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nArray.length / 3; ++i) {
            if (nArray[3 * i] < 1) {
                throw new SQLException("Ordinate Starting Offset could not be less than 1");
            }
            if (nArray[3 * i + 1] != 0) continue;
            return true;
        }
        return false;
    }

    public static JSDOGeometry removeEType0(int n, int n2, double d, double d2, double d3, int[] nArray, double[] dArray) throws SQLException {
        int[] nArray2 = new int[nArray.length];
        double[] dArray2 = new double[dArray.length];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < nArray.length / 3; ++n3) {
            if (nArray[3 * n3] < 1) {
                throw new SQLException("Ordinate Starting Offset could not be less than 1");
            }
            if (nArray[3 * n3 + 1] == 0) {
                n8 = nArray[3 * n3] - 1;
                n9 = 3 * (n3 + 1) <= nArray.length - 1 ? nArray[3 * (n3 + 1)] - 2 : dArray.length - 1;
                n7 += n9 - n8 + 1;
                continue;
            }
            n8 = nArray[3 * n3] - 1;
            n9 = 3 * (n3 + 1) <= nArray.length - 1 ? nArray[3 * (n3 + 1)] - 2 : dArray.length - 1;
            for (n4 = n8; n4 <= n9; ++n4) {
                dArray2[n6] = dArray[n4];
                ++n6;
            }
            nArray2[n5] = nArray[3 * n3] - n7;
            ++n5;
            for (n4 = 1; n4 < 3; ++n4) {
                nArray2[n5] = nArray[3 * n3 + n4];
                ++n5;
            }
        }
        int[] nArray3 = new int[n5];
        double[] dArray3 = new double[n6];
        System.arraycopy(nArray2, 0, nArray3, 0, n5);
        System.arraycopy(dArray2, 0, dArray3, 0, n6);
        return new JSDOGeometry(n, n2, d, d2, d3, nArray3, dArray3);
    }

    static final JGeometry loadAndReorient(STRUCT sTRUCT) throws SQLException {
        JSDOGeometry jSDOGeometry = JSDOGeometry.loadFromDB(sTRUCT);
        return jSDOGeometry;
    }

    public static final JSDOGeometry loadFromDB(byte[] byArray) throws Exception {
        if (byArray == null || byArray.length < 8) {
            return null;
        }
        return Unpickle81.unpickle(byArray);
    }

    public static final JSDOGeometry loadAndReorient(byte[] byArray) throws Exception {
        JSDOGeometry jSDOGeometry = JSDOGeometry.loadFromDB(byArray);
        if (jSDOGeometry == null) {
            return null;
        }
        if (!(jSDOGeometry.gtype != 2 && jSDOGeometry.gtype != 6 && jSDOGeometry.gtype != 4 || jSDOGeometry.hasCircularArcs())) {
            jSDOGeometry.reOrientCurves();
        }
        return jSDOGeometry;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.gtype);
        objectOutputStream.writeInt(this.linfo);
        objectOutputStream.writeInt(this.srid);
        objectOutputStream.writeDouble(this.x);
        objectOutputStream.writeDouble(this.y);
        objectOutputStream.writeDouble(this.z);
        objectOutputStream.writeObject(this.elemInfo);
        objectOutputStream.writeObject(this.ordinates);
        objectOutputStream.writeInt(this.dim);
        objectOutputStream.writeObject(this.mbr);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.gtype = objectInputStream.readInt();
        this.linfo = objectInputStream.readInt();
        this.srid = objectInputStream.readInt();
        this.x = objectInputStream.readDouble();
        this.y = objectInputStream.readDouble();
        this.z = objectInputStream.readDouble();
        this.elemInfo = (int[])objectInputStream.readObject();
        this.ordinates = (double[])objectInputStream.readObject();
        this.dim = objectInputStream.readInt();
        this.mbr = (double[])objectInputStream.readObject();
    }

    public long getSize() {
        return 40 + (this.elemInfo == null ? 0 : 4 * this.elemInfo.length) + (this.ordinates == null ? 0 : 8 * this.ordinates.length);
    }

    public boolean pointInPolygon(double d, double d2) {
        if (this.gtype != 3 && this.gtype != 7) {
            return false;
        }
        this.getMBR();
        if (d < this.mbr[0] || d > this.mbr[2] || d2 < this.mbr[1] || d2 > this.mbr[3]) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        JGeometry.ElementIterator elementIterator = new JGeometry.ElementIterator((JGeometry)this);
        while (elementIterator.next()) {
            int n3 = elementIterator.ord_offset;
            int n4 = elementIterator.nCoord;
            int n5 = elementIterator.original_etype;
            try {
                n = 0;
                n2 = n4 - 1;
                while (n < n4) {
                    d3 = this.ordinates[n3 + n * this.dim];
                    d4 = this.ordinates[n3 + n * this.dim + 1];
                    d5 = this.ordinates[n3 + n2 * this.dim];
                    d6 = this.ordinates[n3 + n2 * this.dim + 1];
                    if ((d4 <= d2 && d2 < d6 || d6 <= d2 && d2 < d4) && d < (d5 - d3) * (d2 - d4) / (d6 - d4) + d3) {
                        bl = !bl;
                    }
                    n2 = n++;
                }
            }
            catch (Error error) {
                return false;
            }
            if (bl && (n5 == 1003 || n5 == 3)) {
                return true;
            }
            bl = false;
        }
        return bl;
    }

    public String toString() {
        String string = "JSDOGeometry (gtype=" + this.gtype + ", dim=" + this.dim + ", srid=" + this.srid;
        return string;
    }

    boolean crossing180() {
        if (this.gtype != 2 && this.gtype != 3 && this.gtype != 6 && this.gtype != 7) {
            return false;
        }
        this.getMBR();
        return this.mbr[0] < 0.0 && this.mbr[2] > 0.0 && this.mbr[2] - this.mbr[0] > 180.0 && this.mbr[3] > -60.0;
    }

    void elemMBR(int n, int n2, double[] dArray) {
        int n3 = 0;
        if (this.isOrientedMultiPoint()) {
            n3 = this.getOrientMultiPointOffset();
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n2; ++i) {
            double d5 = this.ordinates[n + i * (this.dim + n3)];
            double d6 = this.ordinates[n + i * (this.dim + n3) + 1];
            if (d > d5) {
                d = d5;
            }
            if (d2 < d5) {
                d2 = d5;
            }
            if (d3 > d6) {
                d3 = d6;
            }
            if (!(d4 < d6)) continue;
            d4 = d6;
        }
        dArray[0] = d;
        dArray[1] = d3;
        dArray[2] = d2;
        dArray[3] = d4;
    }

    boolean elemCrossing180(int n, int n2, double[] dArray) {
        this.elemMBR(n, n2, dArray);
        return dArray[0] < 0.0 && dArray[2] > 0.0 && dArray[2] - dArray[0] > 180.0 && dArray[3] > -60.0;
    }

    public boolean unwrapAt180() {
        double[] dArray = new double[4];
        boolean bl = false;
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        JGeometry.ElementIterator elementIterator = new JGeometry.ElementIterator((JGeometry)this);
        while (elementIterator.next()) {
            int n2;
            if (elementIterator.eitpr == 2 || elementIterator.eitpr == 4 || !this.elemCrossing180(n2 = elementIterator.ord_offset, elementIterator.nCoord, dArray)) continue;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                bl = true;
                if (!(this.ordinates[n2 + i * (this.dim + n)] < 0.0)) continue;
                int n3 = n2 + i * (this.dim + n);
                this.ordinates[n3] = this.ordinates[n3] + 360.0;
            }
        }
        if (bl) {
            this.mbr = null;
            this.getMBR();
        }
        return bl;
    }

    boolean _elemCrossing180(int n, int n2, double[] dArray) {
        this.elemMBR(n, n2, dArray);
        return dArray[2] > 180.0;
    }

    private void splitAt180() {
        double[] dArray = new double[4];
        JGeometry.ElementIterator elementIterator = new JGeometry.ElementIterator((JGeometry)this);
        while (elementIterator.next()) {
            int n;
            int n2;
            if (elementIterator.eitpr != 2 && elementIterator.eitpr != 4 && this._elemCrossing180(n2 = elementIterator.ord_offset, n = elementIterator.nCoord, dArray)) continue;
        }
    }

    private void elemSplitAt180(double[] dArray, int n, int n2, int n3) {
        double d = 180.0;
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = dArray[n + this.dim];
        double d5 = dArray[n + this.dim + 1];
        double d6 = dArray[n + this.dim + this.dim];
        double d7 = dArray[n + this.dim + this.dim + 1];
        boolean bl = JSDOGeometry.orientation((double)d2, (double)d3, (double)d4, (double)d5, (double)d6, (double)d7) < 0.0;
        CoordArray coordArray = new CoordArray(n2 / 2);
        CoordArray coordArray2 = new CoordArray(n2 / 2);
        for (int i = 1; i < n2 - 1; ++i) {
            double d8;
            if (i > 1) {
                d2 = d4;
                d3 = d5;
                d4 = dArray[n + this.dim * i];
                d5 = dArray[n + this.dim * i + 1];
            }
            if (d2 == d) {
                coordArray.add(d2, d3);
                coordArray2.add(d2, d3);
                continue;
            }
            if (d2 < d && d4 <= d) {
                coordArray.add(d2, d3);
                continue;
            }
            if (d2 > d && d4 >= d) {
                coordArray2.add(d2, d3);
                continue;
            }
            double d9 = d2 < 0.0 ? d2 + 360.0 : d2;
            double d10 = d4 < 0.0 ? d4 + 360.0 : d4;
            double d11 = (d3 - d5) / (d9 - d10);
            double d12 = d;
            double d13 = d8 = d3 == d5 ? d3 : d5 + (d - d10) * d11;
            if (d2 < d && d4 > d) {
                coordArray.add(d2, d3);
                coordArray.add(d12, d8);
                coordArray2.add(d12, d8);
                coordArray.add(Double.NaN, Double.NaN);
                continue;
            }
            if (!(d2 > d) || !(d4 < d)) continue;
            coordArray2.add(d2, d3);
            coordArray.add(d12, d8);
            coordArray2.add(d12, d8);
            coordArray2.add(Double.NaN, Double.NaN);
        }
        if (n3 % 10 == 3) {
            this.closeLeftClips(coordArray, bl, d);
            this.closeRightClips(coordArray2, bl, d);
        }
    }

    private void closeLeftClips(CoordArray coordArray, boolean bl, double d) {
        int n = 0;
        while (n < coordArray.getNumCoords()) {
            double d2 = coordArray.getX(n);
            if (Double.isNaN(d2)) {
                coordArray.remove(n);
                continue;
            }
            ++n;
        }
        if (coordArray.getX(0) != coordArray.getLastX() || coordArray.getY(0) != coordArray.getLastY()) {
            coordArray.add(coordArray.getX(0), coordArray.getY(0));
        }
    }

    private void closeRightClips(CoordArray coordArray, boolean bl, double d) {
        this.closeLeftClips(coordArray, bl, d);
    }
}

