/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.ThemeStyleInfo;
import oracle.mapviewer.share.stylex.HeatMapStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.LoadThemeData2;
import oracle.sdovis.MapMaker;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VectorRenderer;
import oracle.sdovis.VisContext;
import oracle.sdovis.sam.HeatMapCore;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.stylex.HeatMapStyle;
import oracle.sdovis.stylex.HeatMapStyleModifiers;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.ThemeUtils;

public class HeatMapRenderer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static void renderHeatMap(Graphics2D graphics2D, Theme theme, VisContext visContext) {
        log.finest("Heat map processing started for theme " + theme.getName() + "...");
        long l = System.currentTimeMillis();
        HeatMapStyle heatMapStyle = HeatMapRenderer.getStyle(theme, visContext);
        if (heatMapStyle == null) {
            log.warning("Heat map style not found or null.");
            return;
        }
        HeatMapStyleModel heatMapStyleModel = (HeatMapStyleModel)heatMapStyle.getModel();
        Rectangle2D rectangle2D = visContext.getDeviceWindow();
        double d = heatMapStyleModel.getGridSampleFactor();
        int n = (int)(rectangle2D.getWidth() / d);
        int n2 = (int)(rectangle2D.getHeight() / d);
        double d2 = heatMapStyleModel.getSpotLightRadius();
        HeatMapStyleModifiers heatMapStyleModifiers = (HeatMapStyleModifiers)heatMapStyle.convertToPixelSize(visContext);
        if (heatMapStyleModifiers != null) {
            d2 = heatMapStyleModifiers.getSpotLightRadius();
        }
        log.finest("Heat map info: grid width=" + n + ",grid height=" + n2 + ", spotlight radius=" + d2);
        HeatMapCore heatMapCore = new HeatMapCore(n, n2);
        heatMapCore.setSpotlightRadius(d2);
        double[][] dArray = HeatMapRenderer.getEventPoints(theme, visContext);
        heatMapCore.setData(dArray);
        heatMapCore.setCoordBounds(rectangle2D.getMinX(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxY());
        try {
            heatMapCore.computeHeatMap();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Error while computing heat map for theme: " + theme.getName() + ".", exception);
            return;
        }
        HeatMapRenderer.drawComputedHeatMap(graphics2D, heatMapCore, heatMapStyleModel, visContext);
        long l2 = System.currentTimeMillis();
        log.finest("Total time spent computing and rendering heat map for theme " + theme.getName() + ": " + (l2 - l) + "ms.");
        log.finest("Heat map processing completed for theme " + theme.getName() + "...");
    }

    private static HeatMapStyle getStyle(Theme theme, VisContext visContext) {
        StyledFeatureI styledFeatureI;
        Object object;
        ThemeDefinition themeDefinition = theme.getDefinition();
        ThemeStyleInfo[] themeStyleInfoArray = themeDefinition.getStyleList(visContext);
        if (themeStyleInfoArray == null) {
            return null;
        }
        for (int i = 0; i < themeStyleInfoArray.length; ++i) {
            String string;
            Style style;
            object = themeStyleInfoArray[i];
            if (!((ThemeStyleInfo)object).isRendering() || (style = MapMaker.getStyleWithName(string = ((ThemeStyleInfo)object).getName(), themeDefinition.getDataSourceName(), visContext)) == null || !(style instanceof HeatMapStyle)) continue;
            return (HeatMapStyle)style;
        }
        try {
            styledFeatureI = theme.getStyledFeature(0);
            if (styledFeatureI == null) {
                return null;
            }
        }
        catch (Exception exception) {
            log.warning("cannot get a styled feature from theme " + theme.getName());
            return null;
        }
        object = styledFeatureI.getFeatureStyle();
        if (object == null) {
            object = MapMaker.getStyleWithName(styledFeatureI.getFeatureStyleName(), styledFeatureI.getDataSource(), visContext);
        }
        if (object == null) {
            return null;
        }
        return (HeatMapStyle)object;
    }

    private static double[][] getEventPoints(Theme theme, VisContext visContext) {
        StyledFeatureI styledFeatureI = null;
        ArrayList<double[]> arrayList = new ArrayList<double[]>(theme.size());
        for (int i = 0; i < theme.size(); ++i) {
            Point2D point2D;
            styledFeatureI = theme.getStyledFeature(i);
            if (styledFeatureI == null || !VectorRenderer.visible(styledFeatureI, visContext) || (point2D = VectorRenderer.getPointOfPointFeature(styledFeatureI, visContext)) == null) continue;
            double[] dArray = new double[]{point2D.getX(), point2D.getY()};
            arrayList.add(dArray);
        }
        double[][] dArrayArray = new double[arrayList.size()][];
        for (int i = 0; i < arrayList.size(); ++i) {
            dArrayArray[i] = (double[])arrayList.get(i);
        }
        log.finest("Heat map theme " + theme.getName() + " contains " + dArrayArray.length + " points.");
        return dArrayArray;
    }

    public static void drawComputedHeatMap(Graphics2D graphics2D, HeatMapCore heatMapCore, HeatMapStyleModel heatMapStyleModel, VisContext visContext) {
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = null;
        BufferedImage bufferedImage3 = null;
        Color[] colorArray = heatMapStyleModel.createGradientColors();
        bufferedImage = HeatMapRenderer.drawData(heatMapCore, colorArray);
        bufferedImage2 = HeatMapRenderer.drawMaskTheme(heatMapStyleModel.getContainerThemeName(), visContext);
        bufferedImage3 = bufferedImage2 != null ? HeatMapRenderer.masking(bufferedImage, bufferedImage2) : bufferedImage;
        graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
        if (bufferedImage != null) {
            bufferedImage.flush();
            bufferedImage = null;
        }
        if (bufferedImage2 != null) {
            bufferedImage2.flush();
            bufferedImage2 = null;
        }
        if (bufferedImage3 != null) {
            bufferedImage3.flush();
            bufferedImage3 = null;
        }
    }

    private static BufferedImage drawData(HeatMapCore heatMapCore, Color[] colorArray) {
        BufferedImage bufferedImage = new BufferedImage(heatMapCore.getGridWidth(), heatMapCore.getGridHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        long l = 0L;
        for (int i = 0; i < heatMapCore.getGridWidth(); ++i) {
            for (int j = 0; j < heatMapCore.getGridHeight(); ++j) {
                Color color = heatMapCore.getMatchingColor(i, j, colorArray);
                if (color == null) {
                    color = Color.gray;
                    if (l < 50L) {
                        log.warning("invalid data range found.");
                    } else if (l == 50L) {
                        log.warning("invalid data range found. hiding more warnings like this... ");
                    }
                    ++l;
                }
                graphics2D.setColor(color);
                graphics2D.fillRect((int)Math.ceil(i), (int)Math.ceil(j), 1, 1);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private static BufferedImage drawMaskTheme(String string, VisContext visContext) {
        String string2 = visContext.getMasterDataSourceName();
        try {
            Theme theme = ThemeUtils.loadPredefinedGeometryTheme(string, string2, visContext);
            if (theme == null) {
                log.severe("Cannot load predefined geom theme " + string + " from data source " + string2 + ".");
                return null;
            }
            Rectangle2D rectangle2D = visContext.getQueryWindow();
            LoadThemeData2 loadThemeData2 = new LoadThemeData2(theme, rectangle2D, visContext);
            loadThemeData2.run();
            StyledFeatureI[] styledFeatureIArray = theme.getStyledFeatures();
            HeatMapRenderer.forceBlackStyle(styledFeatureIArray);
            return HeatMapRenderer.renderMaskThemeFeatures(styledFeatureIArray, visContext);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception loading or rendering heat map container theme.", exception);
            return null;
        }
    }

    private static void forceBlackStyle(StyledFeatureI[] styledFeatureIArray) {
        if (styledFeatureIArray == null || styledFeatureIArray.length == 0) {
            return;
        }
        StyleColor styleColor = new StyleColor(Color.black, Color.black);
        for (int i = 0; i < styledFeatureIArray.length; ++i) {
            StyledFeatureI styledFeatureI = styledFeatureIArray[i];
            if (styledFeatureI == null) continue;
            styledFeatureI.setFeatureStyleName(null);
            styledFeatureI.setFeatureStyle(styleColor);
        }
    }

    private static BufferedImage renderMaskThemeFeatures(StyledFeatureI[] styledFeatureIArray, VisContext visContext) {
        int n = (int)visContext.getDeviceWindow().getWidth();
        int n2 = (int)visContext.getDeviceWindow().getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        Color color = new Color(0, 0, 0, 0);
        graphics2D.setBackground(color);
        graphics2D.clearRect(0, 0, n, n2);
        boolean bl = visContext.getAntialiasing();
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        for (int i = 0; i < styledFeatureIArray.length; ++i) {
            StyledFeature styledFeature = (StyledFeature)styledFeatureIArray[i];
            if (styledFeature == null) continue;
            try {
                VectorRenderer.renderStyledFeature(graphics2D, styledFeature, visContext);
                continue;
            }
            catch (Exception exception) {
                log.warning("Exception rendering a feature. Msg: " + exception.getMessage() + ".");
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage masking(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage3.getGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n - 1, n2 - 1, 0, 0, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1, null);
        graphics2D.dispose();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n2; ++i) {
            bufferedImage3.getRGB(0, i, n, 1, nArray, 0, n);
            bufferedImage2.getRGB(0, i, n, 1, nArray2, 0, n);
            for (int j = 0; j < n; ++j) {
                int n3 = nArray2[j];
                if (n3 != 0) continue;
                nArray[j] = 0;
            }
            bufferedImage3.setRGB(0, i, n, 1, nArray, 0, n);
        }
        return bufferedImage3;
    }
}

