/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.util.Vector;
import oracle.sdovis.CoordArray;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.Proj;
import oracle.sdovis.SRS;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;

public class Graticule {
    double clon;
    double clat;
    double spacing;
    double density = 1.0;
    Proj proj;
    JSDOGeometry bg;
    JSDOGeometry[] res;
    int srid;
    private static StyleColor style = new StyleColor(null, new Color(85, 85, 204, 140));

    public Graticule(Proj proj, double d, double d2, double d3, double d4, int n) {
        this.proj = proj;
        this.clon = d;
        this.clat = d2;
        this.spacing = Math.abs(d3);
        this.density = Math.abs(d4);
        this.srid = n;
        this.getGraticule();
    }

    public JSDOGeometry[] get() {
        return this.res;
    }

    private void project(JSDOGeometry[] jSDOGeometryArray, JSDOGeometry[] jSDOGeometryArray2) {
        int n;
        int n2;
        JSDOGeometry[] jSDOGeometryArray3 = new JSDOGeometry[jSDOGeometryArray.length];
        JSDOGeometry[] jSDOGeometryArray4 = new JSDOGeometry[jSDOGeometryArray2.length];
        for (n2 = 0; n2 < jSDOGeometryArray3.length; ++n2) {
            jSDOGeometryArray3[n2] = SRS.proj(jSDOGeometryArray[n2], this.proj, this.srid);
        }
        for (n2 = 0; n2 < jSDOGeometryArray4.length; ++n2) {
            jSDOGeometryArray4[n2] = SRS.proj(jSDOGeometryArray2[n2], this.proj, this.srid);
        }
        n2 = jSDOGeometryArray3.length + jSDOGeometryArray4.length;
        if (this.bg != null) {
            ++n2;
        }
        this.res = new JSDOGeometry[n2];
        for (n = 0; n < jSDOGeometryArray3.length; ++n) {
            this.res[n] = jSDOGeometryArray3[n];
        }
        for (n = 0; n < jSDOGeometryArray4.length; ++n) {
            this.res[n + jSDOGeometryArray3.length] = jSDOGeometryArray4[n];
        }
        if (this.bg != null) {
            this.res[n2 - 1] = this.bg;
        }
    }

    public static Style getStyle() {
        return style;
    }

    private void getGraticule() {
        double[] dArray;
        Vector<JSDOGeometry> vector = new Vector<JSDOGeometry>(60);
        double d = this.clon;
        vector.add(this.getMeridian(d));
        for (d = this.clon + this.spacing; d <= 360.0; d += this.spacing) {
            vector.add(this.getMeridian(d));
        }
        for (d = this.clon - this.spacing; d >= -360.0; d -= this.spacing) {
            vector.add(this.getMeridian(d));
        }
        Vector<JSDOGeometry> vector2 = new Vector<JSDOGeometry>(60);
        double d2 = this.clat;
        JSDOGeometry jSDOGeometry = this.getParallel(d2);
        if (jSDOGeometry != null) {
            vector2.add(jSDOGeometry);
        }
        for (d2 = this.clat + this.spacing; d2 < 90.0; d2 += this.spacing) {
            jSDOGeometry = this.getParallel(d2);
            if (jSDOGeometry == null) continue;
            vector2.add(jSDOGeometry);
        }
        jSDOGeometry = this.getParallel(90.0);
        if (jSDOGeometry != null) {
            vector2.add(jSDOGeometry);
        }
        for (d2 = this.clat - this.spacing; d2 > -90.0; d2 -= this.spacing) {
            jSDOGeometry = this.getParallel(d2);
            if (jSDOGeometry == null) continue;
            vector2.add(jSDOGeometry);
        }
        jSDOGeometry = this.getParallel(-90.0);
        if (jSDOGeometry != null) {
            vector2.add(jSDOGeometry);
        }
        if ((dArray = this.proj.getBoundingGeom()) != null) {
            this.bg = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])dArray, (int)2, (int)0));
        }
        JSDOGeometry[] jSDOGeometryArray = vector.toArray(new JSDOGeometry[vector.size()]);
        JSDOGeometry[] jSDOGeometryArray2 = vector2.toArray(new JSDOGeometry[vector2.size()]);
        this.project(jSDOGeometryArray, jSDOGeometryArray2);
    }

    private JSDOGeometry getMeridian(double d) {
        CoordArray coordArray = new CoordArray(400);
        for (int i = 90; i >= -90; --i) {
            coordArray.add(d, i);
        }
        return JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])coordArray.getAll(), (int)2, (int)0));
    }

    private JSDOGeometry getParallel(double d) {
        double[] dArray = this.proj.getParallel(d, this.density);
        if (dArray != null) {
            return JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])dArray, (int)2, (int)0));
        }
        return null;
    }
}

