/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CustomImageRenderer;
import oracle.sdovis.CustomLogo;
import oracle.sdovis.style.Style;

public class GlobalVisContext {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static int dpi = 96;
    static CustomLogo logo;
    static Hashtable customImageRenderers;
    static boolean showQueryWindow;
    static boolean reorientOrdinates;
    static boolean fastUnpickle;
    static boolean ugp;
    static String footnoteFont;
    static String footnoteText;
    static String footnotePosition;
    static Style footnoteStyle;
    static String titleFont;
    static String titleText;
    static String titlePosition;
    static Style titleStyle;

    public static int getDPI() {
        return dpi;
    }

    public static boolean getUgp() {
        return ugp;
    }

    public static void setUgp(boolean bl) {
        ugp = bl;
    }

    public static CustomLogo getLogo() {
        return logo;
    }

    public static void setLogo(CustomLogo customLogo) {
        logo = customLogo;
    }

    public static void addCustomImageRenderer(String string, CustomImageRenderer customImageRenderer) {
        customImageRenderers.put(string, customImageRenderer);
    }

    public static CustomImageRenderer findCustomImageRenderer(String string) {
        if (string == null || string.length() == 0 || customImageRenderers == null || customImageRenderers.size() == 0) {
            return null;
        }
        Enumeration enumeration = customImageRenderers.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string2)) continue;
            return (CustomImageRenderer)customImageRenderers.get(string2);
        }
        return null;
    }

    public static boolean getReorientGeomOridnates() {
        return reorientOrdinates;
    }

    public static void setReorientGeomOrdinates(boolean bl) {
        reorientOrdinates = bl;
    }

    public static boolean getFastUnpickle() {
        return fastUnpickle;
    }

    public static void setFastUnpickle(boolean bl) {
        fastUnpickle = bl;
    }

    public static void setGlobalMapTitle(String string) {
        titleText = string;
    }

    public static String getGlobalMapTitle() {
        return titleText;
    }

    public static void setGlobalMapTitleFont(String string) {
        titleFont = string;
    }

    public static String getGlobalMaptitleFont() {
        return titleFont;
    }

    public static void setGlobalMapTitlePos(String string) {
        titlePosition = string;
    }

    public static String getGlobalMapTitlePos() {
        return titlePosition;
    }

    public static Style getGlobalMapTitleStyle() {
        return titleStyle;
    }

    public static void setGlobalMapTitleStyle(Style style) {
        titleStyle = style;
    }

    public static void setGlobalMapFootnote(String string) {
        footnoteText = string;
    }

    public static String getGlobalMapFootnote() {
        return footnoteText;
    }

    public static void setGlobalMapFootnoteFont(String string) {
        footnoteFont = string;
    }

    public static String getGlobalMapFootnoteFont() {
        return footnoteFont;
    }

    public static void setGlobalMapFootnotePos(String string) {
        footnotePosition = string;
    }

    public static String getGlobalMapFootnotePos() {
        return footnotePosition;
    }

    public static void setGlobalMapFootnoteStyle(Style style) {
        footnoteStyle = style;
    }

    public static Style getGlobalMapFootnoteStyle() {
        return footnoteStyle;
    }

    public static boolean getShowQueryWindow() {
        return showQueryWindow;
    }

    public static void setShowQueryWindow(boolean bl) {
        showQueryWindow = bl;
    }

    static {
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Exception exception) {
            log.warning("will use 96 as default dpi.");
        }
        customImageRenderers = new Hashtable(5);
        reorientOrdinates = true;
        fastUnpickle = false;
        ugp = false;
        footnoteFont = "Sans Serif";
        footnoteText = null;
        footnotePosition = "SOUTH_EAST";
        footnoteStyle = null;
        titleFont = "Dialog";
        titleText = null;
        titlePosition = "NORTH";
        titleStyle = null;
    }
}

