/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.Theme;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.DynGeomThemeProducer;
import oracle.sdovis.util.Util;

public class DynamicGeometryTheme
extends Theme {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public DynamicGeometryTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        int n;
        if (!Util.isQueryAllowed(string3)) {
            throw new IllegalArgumentException("Invalid query type!.");
        }
        DynGeomThemeDefinition dynGeomThemeDefinition = new DynGeomThemeDefinition();
        this.setDefinition(dynGeomThemeDefinition);
        this.setProducer(new DynGeomThemeProducer(this));
        dynGeomThemeDefinition.setName(string);
        dynGeomThemeDefinition.setDataSourceName(string2);
        dynGeomThemeDefinition.setQuery(string3);
        dynGeomThemeDefinition.setSpatialColumn(string4);
        dynGeomThemeDefinition.setLabelColumn(string7);
        dynGeomThemeDefinition.setFeatureStyleName(string6);
        dynGeomThemeDefinition.setLabelStyleName(string8);
        dynGeomThemeDefinition.setPassthrough(bl);
        if (string7 != null && string7.indexOf(46) >= 0) {
            n = string7.indexOf(46);
            string7 = string7.substring(n + 1, string7.length());
            dynGeomThemeDefinition.setLabelColumn(string7);
            log.finer("label column cannot have schema name in it; changing to: " + string7);
        }
        n = 0;
        try {
            n = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage(), exception);
        }
        dynGeomThemeDefinition.setSrid(n);
        DBDataSource dBDataSource = (DBDataSource)DSManager.get(string2);
        dynGeomThemeDefinition.set9i(dBDataSource.is9i());
        log.finest("new DynGeomTheme [name=" + string + ",query=" + string3 + ",spatialCol=" + string4 + ", srid=" + string5 + ", featureStyleName=" + string6 + ", labelCol=" + string7 + ", labelStyleName=" + string8 + ", passthrough=" + bl);
    }

    public DynamicGeometryTheme(DynGeomThemeDefinition dynGeomThemeDefinition, Object[] objectArray) {
        int n;
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                if (Util.isBindingParameterAllowed(objectArray[n])) continue;
                throw new IllegalArgumentException(objectArray[n] + ":Invalid binding variable!.");
            }
        }
        int n2 = n = objectArray == null ? 0 : objectArray.length;
        if (dynGeomThemeDefinition.getBindingVariablesNumber() > n) {
            throw new IllegalArgumentException("Not enough binding variables!.");
        }
        this.setDefinition(dynGeomThemeDefinition);
        this.setProducer(new DynGeomThemeProducer(this, objectArray));
    }

    public DynamicGeometryTheme(DynGeomThemeDefinition dynGeomThemeDefinition) {
        this.setDefinition(dynGeomThemeDefinition);
        this.setProducer(new DynGeomThemeProducer(this));
    }

    public void destroy() {
        this.decorator = null;
        this.producer.destroy();
        this.definition = null;
    }

    public boolean isTextLabelPresent() {
        DynGeomThemeDefinition dynGeomThemeDefinition = (DynGeomThemeDefinition)this.definition;
        return dynGeomThemeDefinition.getLabelColumn() != null && dynGeomThemeDefinition.getLabelStyleName() != null;
    }

    public String getFeatureStyleName() {
        DynGeomThemeDefinition dynGeomThemeDefinition = (DynGeomThemeDefinition)this.definition;
        return dynGeomThemeDefinition.getFeatureStyleName();
    }

    public String getLabelStyleName() {
        DynGeomThemeDefinition dynGeomThemeDefinition = (DynGeomThemeDefinition)this.definition;
        return dynGeomThemeDefinition.getLabelStyleName();
    }
}

