/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Hashtable;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.sdovis.DBMapMaker;
import oracle.sdovis.Theme;

public class BaseMap {
    protected String name;
    protected double initX;
    protected double initY;
    protected String description;
    protected PredefinedThemeDesc[] themes;
    protected Hashtable customTags = new Hashtable();

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setInitX(double d) {
        this.initX = d;
    }

    public double getInitX() {
        return this.initX;
    }

    public void setInitY(double d) {
        this.initY = d;
    }

    public double getInitY() {
        return this.initY;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setThemes(PredefinedThemeDesc[] predefinedThemeDescArray) {
        this.themes = predefinedThemeDescArray;
    }

    public PredefinedThemeDesc[] getThemes() {
        return this.themes;
    }

    public int addMapToMapMaker(DBMapMaker dBMapMaker) {
        if (this.themes == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.themes.length; ++i) {
            try {
                Theme theme = BaseMap.addPredefinedTheme(dBMapMaker, this.themes[i], n);
                if (theme == null) continue;
                ++n;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return n;
    }

    private static Theme addPredefinedTheme(DBMapMaker dBMapMaker, PredefinedThemeDesc predefinedThemeDesc, int n) throws Exception {
        return dBMapMaker.addPredefinedTheme(predefinedThemeDesc.name, dBMapMaker.getVisContext().getMasterDataSourceName(), n, predefinedThemeDesc.mods, null, null);
    }

    public Hashtable getCustomTags() {
        return this.customTags;
    }

    public void setCustomTags(Hashtable hashtable) {
        this.customTags = hashtable == null ? new Hashtable() : hashtable;
    }

    public String getCustomTag(String string) {
        if (string == null || this.customTags.size() == 0) {
            return null;
        }
        return (String)this.customTags.get(string);
    }

    public void addCustomTag(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this.customTags.put(string, string2);
    }

    public void removeCustomTag(String string) {
        if (string == null) {
            return;
        }
        this.customTags.remove(string);
    }

    public int getNumberOfCustomtags() {
        return this.customTags.size();
    }

    public void clearCustomTags() {
        this.customTags.clear();
    }

    public static final class PredefinedThemeDesc {
        public String name = null;
        public ThemeDecorator mods = new ThemeDecorator();
    }
}

