/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.util;

import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogFactory {
    public static String INTERNAL_LOGGER = "oracle.mapviewer.logger";
    public static String ACCESS_LOGGER = "oracle.mapviewer.access";
    public static Properties properties = new Properties();

    public static Logger getLogger(LoggerEnum loggerEnum) {
        if (loggerEnum == LoggerEnum.ACCESS) {
            return Logger.getLogger(ACCESS_LOGGER);
        }
        if (loggerEnum == LoggerEnum.SDOVIS) {
            return LogFactory.getODLLoger(INTERNAL_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.INTERNAL) {
            return LogFactory.getODLLoger(INTERNAL_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WMS) {
            return LogFactory.getODLLoger(INTERNAL_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPVIEWER) {
            return LogFactory.getODLLoger(INTERNAL_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPCACHE_SERVER) {
            return LogFactory.getODLLoger(INTERNAL_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.FOI_SERVER) {
            return LogFactory.getODLLoger(INTERNAL_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPBUILDER) {
            return LogFactory.getODLLoger("oracle.mapviewer.builder", null);
        }
        if (loggerEnum == LoggerEnum.SHARE) {
            return LogFactory.getODLLoger(INTERNAL_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.WEBCONSOLE) {
            return LogFactory.getODLLoger(INTERNAL_LOGGER, null);
        }
        if (loggerEnum == LoggerEnum.MAPEDITOR) {
            return LogFactory.getODLLoger("oracle.mapviewer.editor", null);
        }
        if (loggerEnum == LoggerEnum.SDOEDIT) {
            return LogFactory.getODLLoger(INTERNAL_LOGGER, null);
        }
        return null;
    }

    private static Logger getODLLoger(String string, String string2) {
        Logger logger = null;
        logger = string2 == null ? Logger.getLogger(string) : Logger.getLogger(string, string2);
        if (logger != null) {
            return logger;
        }
        return Logger.getLogger(string);
    }

    public static void setMapViewerGlobalConfigs(Properties properties, String[] stringArray) {
        String string;
        LogFactory.properties = properties;
        String string2 = (String)properties.get("log_level");
        Level level = Level.INFO;
        if ("finest".equalsIgnoreCase(string2)) {
            level = Level.FINEST;
        } else if ("debug".equalsIgnoreCase(string2)) {
            level = Level.FINER;
        } else if ("info".equalsIgnoreCase(string2)) {
            level = Level.INFO;
        } else if ("warn".equalsIgnoreCase(string2)) {
            level = Level.WARNING;
        } else if ("error".equalsIgnoreCase(string2)) {
            level = Level.SEVERE;
        } else if ("fatal".equalsIgnoreCase(string2)) {
            level = Level.SEVERE;
        }
        double d = 50.0;
        int n = 10;
        String string3 = (String)properties.get("file_limit");
        if (string3 != null && string3.length() > 0) {
            try {
                d = Double.parseDouble(string3);
            }
            catch (Exception exception) {
                System.err.println("invalid log file size limit specified: " + string3);
            }
        }
        if ((string = (String)properties.get("file_count")) != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                System.err.println("invalid rotating log file count specified: " + string);
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        boolean bl = false;
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if ("System.err".equalsIgnoreCase(string4) || "System.out".equalsIgnoreCase(string4)) {
                if (bl) continue;
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(level);
                vector.add(consoleHandler);
                bl = true;
                continue;
            }
            try {
                int n2 = (int)(1048576.0 * d);
                System.err.println("Log file size limit set to: " + n2 + " bytes.");
                System.err.println("Log file rotation count set to: " + n + ".");
                Object object = new FileHandler(string4, n2, n);
                ((Handler)object).setFormatter(new SimpleFormatter());
                ((Handler)object).setLevel(level);
                vector.add(object);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error creating file based log handler:" + string4);
            }
        }
        for (Object object : LoggerEnum.values()) {
            if (object != LoggerEnum.ACCESS && object != LoggerEnum.MAPBUILDER && object != LoggerEnum.INTERNAL && object != LoggerEnum.MAPEDITOR) continue;
            Logger logger = LogFactory.getLogger(object);
            if (logger == null) {
                System.err.println("cannot obtain logger for " + (Object)object);
                continue;
            }
            logger.setLevel(level);
            logger.setUseParentHandlers(false);
            for (int i = 0; i < vector.size(); ++i) {
                Handler handler = (Handler)vector.get(i);
                if (handler instanceof ConsoleHandler && LogFactory.hasConsoleHandler(logger)) continue;
                logger.addHandler(handler);
            }
            Handler[] handlerArray = logger.getHandlers();
            for (int i = 0; i < handlerArray.length; ++i) {
                Handler handler = handlerArray[i];
                handler.setLevel(level);
            }
        }
    }

    static boolean hasConsoleHandler(Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            Handler handler = handlerArray[i];
            if (!(handler instanceof ConsoleHandler)) continue;
            return true;
        }
        return false;
    }

    public static String getLogFileContents(String string, int n) {
        Logger logger = null;
        if ("INTERNAL".equalsIgnoreCase(string)) {
            logger = LogFactory.getLogger(LoggerEnum.INTERNAL);
        } else if ("ACCESS".equalsIgnoreCase(string)) {
            logger = LogFactory.getLogger(LoggerEnum.ACCESS);
        }
        return "";
    }

    public static void setGlobalLevel(String string) {
        Properties properties = new Properties();
        properties.put("log_level", string);
        String[] stringArray = new String[]{"system.out"};
        LogFactory.setMapViewerGlobalConfigs(properties, stringArray);
    }

    public static Properties getGlobalProperties() {
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoggerEnum {
        ACCESS,
        INTERNAL,
        MAPBUILDER,
        SDOVIS,
        WMS,
        MAPVIEWER,
        MAPCACHE_SERVER,
        FOI_SERVER,
        SHARE,
        WEBCONSOLE,
        MAPEDITOR,
        SDOEDIT;

    }
}

