/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.theme;

import java.io.Serializable;

public class ThemeDecorator
implements Serializable,
Cloneable {
    public static final double DEFAULT_MIN_DIST = 0.5;
    public static final int DEFAULT_FETCH_SIZE = 100;
    public static final double THEME_MIN_SCALE = Double.POSITIVE_INFINITY;
    public static final double THEME_MAX_SCALE = Double.NEGATIVE_INFINITY;
    public double minScale = Double.POSITIVE_INFINITY;
    public static final int MARKER_SEQUENCE_NONE = 0;
    public static final int MARKER_SEQUENCE_NUMERICAL = 1;
    public static final int MARKER_SEQUENCE_ALPHABETIC = 2;
    public double maxScale = Double.NEGATIVE_INFINITY;
    public double minLabelScale = Double.POSITIVE_INFINITY;
    public double maxLabelScale = Double.NEGATIVE_INFINITY;
    public String scaleType = "MAPVIEWER_NATIVE";
    public boolean labelAlwaysOn = false;
    public boolean clickable = false;
    public boolean fastUnpickle = true;
    public boolean sortingNeeded = false;
    public float opacity = 1.0f;
    public boolean enabled = true;
    public double minDistBetweenPoints = 0.5;
    public boolean fixedSVGLabel = false;
    public boolean reorientLines = true;
    public boolean visibleInSVG = true;
    public boolean selectableInSVG = false;
    public String onClickInSVG = null;
    public String onMouseMoveInSVG = null;
    public String onMouseOverInSVG = null;
    public String onMouseOutInSVG = null;
    public boolean prepared = false;
    public String workspaceName = null;
    public String workspaceSavedPoint = null;
    public String workspaceDate = null;
    public String workspaceDateFormat = "mmddyyyyhh24miss";
    public String workspaceDateNlsParam = null;
    public boolean workspaceDateTsWtz = false;
    public boolean partOfBaseMap = false;
    public long requestTimeout = 0L;
    public int minimumFeatureSizePx = 0;
    public boolean simplifiedShapes = true;
    public boolean renderLabels = true;
    public int fetchSize = 100;
    public String[] infoColumns;
    public boolean noRepetitiveLabel = false;
    public boolean allowNakedPoints = true;
    public int markerSequence = 0;
    public String renderStyleName;
    public boolean upsideDownLabels = false;

    public ThemeDecorator clone() {
        try {
            ThemeDecorator themeDecorator = (ThemeDecorator)super.clone();
            if (this.infoColumns != null) {
                themeDecorator.infoColumns = new String[this.infoColumns.length];
                for (int i = 0; i < this.infoColumns.length; ++i) {
                    themeDecorator.infoColumns[i] = this.infoColumns[i];
                }
            }
            return themeDecorator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void setReorientLines(boolean bl) {
        this.reorientLines = bl;
    }

    public boolean isReorientLines() {
        return this.reorientLines;
    }

    public void setVisibleInSVG(boolean bl) {
        this.visibleInSVG = bl;
    }

    public boolean isVisibleInSVG() {
        return this.visibleInSVG;
    }

    public void setSelectableInSVG(boolean bl) {
        this.selectableInSVG = bl;
    }

    public boolean isSelectableInSVG() {
        return this.selectableInSVG;
    }

    public void setOnClickInSVG(String string) {
        this.onClickInSVG = string;
    }

    public String getOnClickInSVG() {
        return this.onClickInSVG;
    }

    public void setOnMouseMoveInSVG(String string) {
        this.onMouseMoveInSVG = string;
    }

    public String getOnMouseMoveInSVG() {
        return this.onMouseMoveInSVG;
    }

    public void setOnMouseOverInSVG(String string) {
        this.onMouseOverInSVG = string;
    }

    public String getOnMouseOverInSVG() {
        return this.onMouseOverInSVG;
    }

    public void setOnMouseOutInSVG(String string) {
        this.onMouseOutInSVG = string;
    }

    public String getOnMouseOutInSVG() {
        return this.onMouseOutInSVG;
    }

    public void setPrepared(boolean bl) {
        this.prepared = bl;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setWorkspaceName(String string) {
        this.workspaceName = string;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceSavedPoint(String string) {
        this.workspaceSavedPoint = string;
    }

    public String getWorkspaceSavedPoint() {
        return this.workspaceSavedPoint;
    }

    public void setWorkspaceDate(String string) {
        this.workspaceDate = string;
    }

    public String getWorkspaceDate() {
        return this.workspaceDate;
    }

    public void setWorkspaceDateFormat(String string) {
        this.workspaceDateFormat = string;
    }

    public String getWorkspaceDateFormat() {
        return this.workspaceDateFormat;
    }

    public void setWorkspaceDateNlsParam(String string) {
        this.workspaceDateNlsParam = string;
    }

    public String getWorkspaceDateNlsParam() {
        return this.workspaceDateNlsParam;
    }

    public void setWorkspaceDateTsWtz(boolean bl) {
        this.workspaceDateTsWtz = bl;
    }

    public boolean isWorkspaceDateTsWtz() {
        return this.workspaceDateTsWtz;
    }

    public void setPartOfBaseMap(boolean bl) {
        this.partOfBaseMap = bl;
    }

    public boolean isPartOfBaseMap() {
        return this.partOfBaseMap;
    }

    public void setRequestTimeout(long l) {
        this.requestTimeout = l;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setSimplifiedShapes(boolean bl) {
        this.simplifiedShapes = bl;
    }

    public boolean isSimplifiedShapes() {
        return this.simplifiedShapes;
    }

    public void setRenderLabels(boolean bl) {
        this.renderLabels = bl;
    }

    public boolean isRenderLabels() {
        return this.renderLabels;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMinimumFeatureSizePx(int n) {
        this.minimumFeatureSizePx = n;
    }

    public int getMinimumFeatureSizePx() {
        return this.minimumFeatureSizePx;
    }

    public void setInfoColumns(String[] stringArray) {
        this.infoColumns = stringArray;
    }

    public String[] getInfoColumns() {
        return this.infoColumns;
    }

    public void setMinScale(double d) {
        this.minScale = d;
    }

    public double getMinScale() {
        return this.minScale;
    }

    public void setMaxScale(double d) {
        this.maxScale = d;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setLabelMinScale(double d) {
        this.minLabelScale = d;
    }

    public double getLabelMinScale() {
        return this.minLabelScale;
    }

    public void setLabelMaxScale(double d) {
        this.maxLabelScale = d;
    }

    public double getLabelMaxScale() {
        return this.maxLabelScale;
    }

    public void setScaleType(String string) {
        this.scaleType = string;
    }

    public String getScaleType() {
        return this.scaleType;
    }

    public void setLabelAlwaysOn(boolean bl) {
        this.labelAlwaysOn = bl;
    }

    public boolean isLabelAlwaysOn() {
        return this.labelAlwaysOn;
    }

    public void setClickable(boolean bl) {
        this.clickable = bl;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setFastUnpickle(boolean bl) {
        this.fastUnpickle = bl;
    }

    public boolean isFastUnpickle() {
        return this.fastUnpickle;
    }

    public void setSortingNeeded(boolean bl) {
        this.sortingNeeded = bl;
    }

    public boolean isSortingNeeded() {
        return this.sortingNeeded;
    }

    public void setOpacity(float f) {
        this.opacity = f;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMinDistBetweenPoints(double d) {
        this.minDistBetweenPoints = d;
    }

    public double getMinDistBetweenPoints() {
        return this.minDistBetweenPoints;
    }

    public void setFixedSVGLabel(boolean bl) {
        this.fixedSVGLabel = bl;
    }

    public boolean isFixedSVGLabel() {
        return this.fixedSVGLabel;
    }

    public boolean withinScaleLimits(double d) {
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY || d == 0.0) {
            return true;
        }
        return d > this.maxScale && d <= this.minScale;
    }

    public boolean withinLabelScaleLimits(double d) {
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY || d == 0.0) {
            return true;
        }
        return d > this.maxLabelScale && d <= this.minLabelScale;
    }

    public void setNoRepetitiveLabel(boolean bl) {
        this.noRepetitiveLabel = bl;
    }

    public boolean getNoRepetitiveLabel() {
        return this.noRepetitiveLabel;
    }

    public boolean getAllowNakedPoints() {
        return this.allowNakedPoints;
    }

    public void setAllowNakedPoints(boolean bl) {
        this.allowNakedPoints = bl;
    }

    public void setMarkerSequence(String string) {
        this.markerSequence = string != null ? (string.equalsIgnoreCase("N") ? 1 : (string.equalsIgnoreCase("A") ? 2 : 0)) : 0;
    }

    public boolean shouldRenderMarkerSequence() {
        return this.markerSequence != 0;
    }

    public boolean getUpsideDownLabels() {
        return this.upsideDownLabels;
    }

    public void setUpsideDownLabels(boolean bl) {
        this.upsideDownLabels = bl;
    }
}

