/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.awt.Color;
import java.util.List;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.SharedUtils;

public class HeatMapStyleModel
extends AbstractStyleModel {
    private Color[] colorStops;
    private int numSteps = 200;
    private int alpha = 255;
    private SizeDefinition spotLightRadius = new SizeDefinition(5.0, null);
    private String containerThemeName = null;
    private double gridSampleFactor = 2.5;

    public Object clone() {
        HeatMapStyleModel heatMapStyleModel = (HeatMapStyleModel)super.clone();
        if (this.colorStops != null) {
            heatMapStyleModel.colorStops = new Color[this.colorStops.length];
            for (int i = 0; i < 0; ++i) {
                try {
                    heatMapStyleModel.colorStops[i] = this.colorStops[i];
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return heatMapStyleModel;
    }

    public String getTypeName() {
        return "ADVANCED";
    }

    public void setColorStops(Color[] colorArray) {
        this.colorStops = colorArray;
    }

    public Color[] getColorStops() {
        return this.colorStops;
    }

    public void setNumSteps(int n) {
        this.numSteps = n;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public void setAlpha(int n) {
        this.alpha = n;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setSpotLightRadius(double d) {
        this.spotLightRadius.setValue(d);
    }

    public double getSpotLightRadius() {
        return this.spotLightRadius.getValue();
    }

    public SizeDefinition getSpotLightRadiusSize() {
        return this.spotLightRadius;
    }

    public void setSpotLightRadiusSize(SizeDefinition sizeDefinition) {
        this.spotLightRadius = new SizeDefinition(5.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.spotLightRadius.setValue(sizeDefinition.getValue());
        this.spotLightRadius.setUnit(sizeDefinition.getUnit());
    }

    public String getSpotLightRadiusUnit() {
        return this.spotLightRadius.getUnit();
    }

    public void setSpotLightRadiusUnit(String string) {
        this.spotLightRadius.setUnit(string);
    }

    public void setContainerThemeName(String string) {
        this.containerThemeName = string;
    }

    public String getContainerThemeName() {
        return this.containerThemeName;
    }

    public void setGridSampleFactor(double d) {
        this.gridSampleFactor = d;
    }

    public double getGridSampleFactor() {
        return this.gridSampleFactor;
    }

    public Color[] createGradientColors() {
        return StyleUtils.createMultiStopGradient(this.colorStops, this.numSteps, this.alpha);
    }

    public String toXMLString() {
        String string = "";
        if (this.spotLightRadius.getUnit() != null && !this.spotLightRadius.getUnit().equalsIgnoreCase("px")) {
            string = this.spotLightRadius.getUnit();
        }
        String string2 = StyleUtils.getUSLocaleFormat(this.spotLightRadius.getValue());
        string2 = StyleUtils.cleanDecimalZeros(string2, 1);
        if (this.spotLightRadius.isPixelUnit()) {
            string2 = String.valueOf((int)this.spotLightRadius.getValue());
        }
        String string3 = "<?xml version=\"1.0\" ?>\n";
        string3 = string3 + "<AdvancedStyle>\n   <HeatMapStyle>\n";
        string3 = string3 + "      <color_stops num_steps=\"" + this.numSteps + "\" alpha=\"" + this.alpha + "\">\n";
        String string4 = "";
        if (this.colorStops != null) {
            for (int i = 0; i < this.colorStops.length - 1; ++i) {
                String string5 = StyleUtils.getHexidecimalString(this.colorStops[i]);
                string5 = string5.substring(1);
                string4 = string4 + string5 + ",";
            }
            string4 = string4 + StyleUtils.getHexidecimalString(this.colorStops[this.colorStops.length - 1]).substring(1);
        }
        string3 = string3 + "           " + string4 + "\n";
        string3 = string3 + "      </color_stops>\n";
        string3 = string3 + "      <spot_light_radius>" + string2 + string + "</spot_light_radius>\n";
        string3 = string3 + "      <grid_sample_factor>" + this.gridSampleFactor + "</grid_sample_factor>\n";
        string3 = string3 + "      <container_theme>" + this.containerThemeName + "</container_theme>\n";
        string3 = string3 + "    </HeatMapStyle>\n";
        string3 = string3 + "</AdvancedStyle>\n";
        return string3;
    }

    public static Color[] stringToColorStops(String string) {
        String string2 = string.trim();
        if (string2.endsWith(",")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        List list = SharedUtils.splitBy(string2, ",");
        Color[] colorArray = new Color[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            if (!string3.startsWith("#")) {
                string3 = "#" + string3;
            }
            colorArray[i] = StyleUtils.getColor(string3);
        }
        return colorArray;
    }
}

