/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.util.ArrayList;
import java.util.Collection;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.stylex.Bucket;

public class CollectionBucket
extends Bucket {
    static final long serialVersionUID = -1138763220227156473L;
    Collection members = null;
    String delimiter = ",";
    String type = "string";
    boolean keepWhiteSpace = false;

    public CollectionBucket(String string) {
        super(string);
    }

    public CollectionBucket(String string, Collection collection) {
        super(string);
        this.members = collection;
        if (collection.contains(new Field("#DEFAULT#")) || collection.contains(new Field("#default#"))) {
            this.setDefaultBucket(true);
        }
    }

    public Object clone() {
        CollectionBucket collectionBucket = (CollectionBucket)super.clone();
        if (this.members != null && this.members.size() > 0) {
            collectionBucket.members = new ArrayList(this.members);
        }
        return collectionBucket;
    }

    public void setMembers(Collection collection) {
        this.members = collection;
    }

    public void setMembers(Field[] fieldArray) {
        this.members = new ArrayList(fieldArray.length);
        for (int i = 0; i < fieldArray.length; ++i) {
            this.members.add(fieldArray[i]);
        }
    }

    public Collection getMembers() {
        return this.members;
    }

    public Field[] getMembersAsArray() {
        if (this.members == null) {
            return null;
        }
        return this.members.toArray(new Field[this.members.size()]);
    }

    public boolean contains(Field field) {
        try {
            for (Field field2 : this.members) {
                if (field2.compareTo(field) != 0) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            field = Field.createField(field.getString(), "string");
            for (Field field3 : this.members) {
                if (field3.compareTo(field) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setKeepWhiteSpace(boolean bl) {
        this.keepWhiteSpace = bl;
    }

    public boolean keepWhiteSpace() {
        return this.keepWhiteSpace;
    }

    public void print() {
        if (this.members.size() > 0) {
            Object[] objectArray = this.members.toArray();
            System.out.println("Collection Bucket members");
            for (int i = 0; i < this.members.size(); ++i) {
                if (objectArray[i].toString() != null) {
                    System.out.println("Element: " + i + "= " + objectArray[i].toString());
                    continue;
                }
                System.out.println("Element: " + i + "= null");
            }
        }
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }
}

