/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.BarInfo;

public class BarChartStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 421486313470893323L;
    double minValue = Double.NaN;
    double maxValue = Double.NaN;
    int numBars = 0;
    BarInfo[] bars = null;
    SizeDefinition2D barSize = new SizeDefinition2D(45.0, 25.0, null);
    boolean shareScale = true;
    boolean showXAxis = false;

    public BarChartStyleModel() {
        this.type = 9;
        this.bars = new BarInfo[0];
    }

    public BarChartStyleModel(BarInfo[] barInfoArray) {
        this.type = 9;
        if (barInfoArray == null || barInfoArray.length == 0) {
            throw new IllegalArgumentException("invalid argument(s).");
        }
        this.bars = barInfoArray;
        this.numBars = barInfoArray.length;
    }

    public Object clone() {
        BarChartStyleModel barChartStyleModel = (BarChartStyleModel)super.clone();
        if (this.bars != null) {
            barChartStyleModel.bars = new BarInfo[this.bars.length];
            for (int i = 0; i < this.bars.length; ++i) {
                barChartStyleModel.bars[i] = new BarInfo(this.bars[i].name, this.bars[i].color);
            }
        }
        barChartStyleModel.setBarSize(this.barSize);
        return barChartStyleModel;
    }

    public String getTypeName() {
        return "ADVANCED";
    }

    public void setBarSize(SizeDefinition2D sizeDefinition2D) {
        this.barSize = new SizeDefinition2D(45.0, 25.0, null);
        if (sizeDefinition2D == null) {
            return;
        }
        this.barSize.setSize(sizeDefinition2D.getWidth(), sizeDefinition2D.getHeight());
        this.barSize.setUnit(sizeDefinition2D.getUnit());
    }

    public SizeDefinition2D getBarSize() {
        return this.barSize;
    }

    public String toXMLString() {
        String string = StyleUtils.getUSLocaleFormat(this.barSize.getWidth());
        string = StyleUtils.cleanDecimalZeros(string, 1);
        String string2 = StyleUtils.getUSLocaleFormat(this.barSize.getHeight());
        string2 = StyleUtils.cleanDecimalZeros(string2, 1);
        String string3 = "";
        if (this.barSize.getUnit() != null && !this.barSize.getUnit().equalsIgnoreCase("px")) {
            string3 = this.barSize.getUnit();
        }
        if (this.barSize.isPixelUnit()) {
            string = String.valueOf((int)this.barSize.getWidth());
            string2 = String.valueOf((int)this.barSize.getHeight());
        }
        String string4 = "<?xml version=\"1.0\" ?>\n";
        string4 = string4 + "<AdvancedStyle>\n   <BarChartStyle";
        string4 = string4 + " width=\"" + string + string3 + "\" height=\"" + string2 + string3 + "\" " + "share_scale=\"" + (this.shareScale ? "true" : "false") + "\"";
        if (!Double.isNaN(this.maxValue) && !Double.isNaN(this.minValue)) {
            string4 = string4 + "\n      min_value=\"" + this.minValue + "\" max_value=\"" + this.maxValue + "\"";
        }
        if (this.showXAxis) {
            string4 = string4 + " show_x_axis=\"true\"";
        }
        string4 = string4 + ">\n";
        if (this.bars != null) {
            for (int i = 0; i < this.bars.length; ++i) {
                BarInfo barInfo = this.bars[i];
                string4 = string4 + "       <Bar name=\"" + XMLUtil.replaceXMLEntities(barInfo.name) + "\"";
                if (barInfo.color != null) {
                    string4 = string4 + " color=\"" + StyleUtils.getHexidecimalString(barInfo.color) + "\"";
                }
                string4 = string4 + " />\n";
            }
        }
        string4 = string4 + "   </BarChartStyle>\n</AdvancedStyle>\n";
        return string4;
    }

    public void setWidth(int n) {
        this.barSize.setWidth(n);
    }

    public void setWidth(double d) {
        this.barSize.setWidth(d);
    }

    public int getWidth() {
        return (int)this.barSize.getWidth();
    }

    public double getDoubleWidth() {
        return this.barSize.getWidth();
    }

    public void setHeight(int n) {
        this.barSize.setHeight(n);
    }

    public void setHeight(double d) {
        this.barSize.setHeight(d);
    }

    public int getHeight() {
        return (int)this.barSize.getHeight();
    }

    public double getDoubleHeight() {
        return this.barSize.getHeight();
    }

    public String getSizeUnit() {
        return this.barSize.getUnit();
    }

    public void setSizeUnit(String string) {
        this.barSize.setUnit(string);
    }

    public int getNumBars() {
        return this.numBars;
    }

    public void setBars(BarInfo[] barInfoArray) {
        this.bars = barInfoArray;
        this.numBars = barInfoArray == null ? 0 : barInfoArray.length;
    }

    public BarInfo[] getBars() {
        return this.bars;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMinMaxValues(double d, double d2) {
        this.minValue = Math.min(d, d2);
        this.maxValue = Math.max(d, d2);
    }

    public void setShareScale(boolean bl) {
        this.shareScale = bl;
    }

    public boolean isShareScale() {
        return this.shareScale;
    }

    public BarInfo getBarInfo(int n) {
        return this.bars[n];
    }

    public void setShowXAxis(boolean bl) {
        this.showXAxis = bl;
    }

    public boolean isShowXAxis() {
        return this.showXAxis;
    }
}

