/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class AreaStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = -7936230043110821340L;
    public static final int AREA_STYLE_COLOR = 1;
    public static final int AREA_STYLE_TEXTURE = 2;
    public static final int AREA_STYLE_GRADIENT_COLOR = 3;
    int areaStyleType = 1;
    float borderWidth = 1.0f;
    Color borderColor = Color.gray;
    String borderStyleName = null;
    Color fillColor = new Color(128, 128, 128, 128);
    byte[] fillPatternImage = null;

    public AreaStyleModel() {
        this.type = 4;
    }

    public Object clone() {
        AreaStyleModel areaStyleModel = (AreaStyleModel)super.clone();
        return areaStyleModel;
    }

    public String getTypeName() {
        return "AREA";
    }

    public String toXMLString() {
        String string = "<?xml version=\"1.0\" standalone=\"yes\"?>\n";
        string = string + "<svg width=\"1in\" height=\"1in\">\n";
        string = string + "  <desc></desc>\n";
        string = string + "  <g class=\"area\" ";
        if (this.borderColor != null) {
            String string2 = ";stroke-width:" + this.borderWidth;
            String string3 = this.borderColor.getAlpha() < 255 ? ";stroke-opacity:" + (float)this.borderColor.getAlpha() / 255.0f : "";
            string = string + " style=\"stroke:" + StyleUtils.getHexidecimalString(this.borderColor) + string3 + string2 + "\"";
            if (this.borderStyleName != null) {
                string = string + ";line-style:" + XMLUtil.replaceXMLEntities(this.borderStyleName) + "\"";
            }
        } else if (this.borderStyleName != null) {
            string = string + " style=\"line-style:" + XMLUtil.replaceXMLEntities(this.borderStyleName) + "\"";
        }
        string = string + " >\n";
        string = string + "    <image x=\"0\" y=\"0\" width=\"9999\" height=\"9999\" type=\"gif\" href=\"dummy.gif\"/>";
        string = string + "\n  </g>\n</svg>";
        return string;
    }

    public void setAreaStyleType(int n) {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid area style sub-type code.");
        }
        this.areaStyleType = n;
    }

    public int getAreaStyleType() {
        return this.areaStyleType;
    }

    public void setBorderWidth(float f) {
        this.borderWidth = f;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderStyleName(String string) {
        this.borderStyleName = string;
    }

    public String getBorderStyleName() {
        return this.borderStyleName;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillPatternImage(byte[] byArray) {
        this.fillPatternImage = byArray;
        if (byArray != null) {
            this.areaStyleType = 2;
        }
    }

    public byte[] getFillPatternImage() {
        return this.fillPatternImage;
    }
}

