/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class Field
implements Serializable,
Cloneable,
Comparable {
    static final long serialVersionUID = -7506230808640711705L;
    private static byte _KEY = 1;
    private static byte _LABEL = (byte)4;
    private static byte _NODATA = (byte)8;
    public static final int T_BYTE = 1;
    public static final int T_SHORT = 2;
    public static final int T_INT = 3;
    public static final int T_LONG = 4;
    public static final int T_FLOAT = 5;
    public static final int T_DOUBLE = 6;
    public static final int T_CHAR = 7;
    public static final int T_STRING = 8;
    public static final int T_BOOLEAN = 9;
    public static final int T_DATE = 10;
    protected static String[] typeName = new String[]{"invalid-type", "byte", "short", "int", "long", "float", "double", "char", "string", "boolean", "date"};
    protected byte flag = 0;
    protected byte[] vbytes;
    protected String svalue;
    protected int type;
    protected String name;
    protected String displayName;
    protected String[] contexts = null;
    protected boolean isArray = false;

    public Object clone() {
        try {
            Field field = (Field)super.clone();
            if (this.vbytes != null) {
                field.vbytes = new byte[this.vbytes.length];
                System.arraycopy(this.vbytes, 0, field.vbytes, 0, this.vbytes.length);
            }
            return field;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public Field() {
    }

    public Field(String string) {
        this.svalue = string;
        this.vbytes = null;
        this.setType(8);
    }

    public Field(int n) {
        this.setInt(n);
    }

    public Field(double d) {
        this.setDouble(d);
    }

    public static Field createField(String string, String string2) {
        Field field = new Field();
        if (string2 == null || string2.length() == 0) {
            field.setString(string);
            return field;
        }
        if (string == null) {
            return field;
        }
        if ("string".equals(string2 = string2.toLowerCase())) {
            field.setString(string);
        } else if ("int".equals(string2) || "integer".equals(string2)) {
            field.setInt(Integer.parseInt(string));
        } else if ("float".equals(string2)) {
            field.setFloat(Float.parseFloat(string));
        } else if ("double".equals(string2)) {
            field.setDouble(Double.parseDouble(string));
        } else if ("long".equals(string2)) {
            field.setLong(Long.parseLong(string));
        } else if ("char".equals(string2)) {
            field.setChar(string.charAt(0));
        } else if ("short".equals(string2)) {
            field.setShort(Short.parseShort(string));
        } else if ("byte".equals(string2)) {
            field.setByte(Byte.parseByte(string));
        } else if ("date".equals(string2)) {
            field.setDate(Long.parseLong(string));
        } else if ("boolean".equals(string2)) {
            field.setBoolean(Boolean.parseBoolean(string));
        }
        return field;
    }

    public Field setByte(byte by) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = new byte[]{by};
        this.svalue = null;
        this.setType(1);
        return this;
    }

    public Field setBoolean(boolean bl) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = new byte[]{(byte)(bl ? 1 : 0)};
        this.svalue = null;
        this.setType(9);
        return this;
    }

    public Field setShort(int n) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = new byte[]{(byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
        this.svalue = null;
        this.setType(2);
        return this;
    }

    private static byte[] getIntBits(int n) {
        return new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
    }

    public Field setInt(int n) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = Field.getIntBits(n);
        this.svalue = null;
        this.setType(3);
        return this;
    }

    public Field setChar(int n) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = new byte[]{(byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
        this.svalue = null;
        this.setType(7);
        return this;
    }

    private static byte[] getLongBits(long l) {
        return new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)(l >>> 0)};
    }

    public Field setLong(long l) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = Field.getLongBits(l);
        this.svalue = null;
        this.setType(4);
        return this;
    }

    public Field setFloat(float f) {
        if (this.isArray) {
            return null;
        }
        int n = Float.floatToIntBits(f);
        this.vbytes = Field.getIntBits(n);
        this.svalue = null;
        this.setType(5);
        return this;
    }

    public Field setDouble(double d) {
        if (this.isArray) {
            return null;
        }
        long l = Double.doubleToLongBits(d);
        this.vbytes = Field.getLongBits(l);
        this.svalue = null;
        this.setType(6);
        return this;
    }

    public Field setString(String string) {
        if (this.isArray) {
            return null;
        }
        this.svalue = string;
        this.vbytes = null;
        this.setType(8);
        return this;
    }

    public Field setDate(long l) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = Field.getLongBits(l);
        this.svalue = null;
        this.setType(10);
        return this;
    }

    public Field setDate(Date date) {
        return this.setDate(date.getTime());
    }

    public boolean getBoolean() {
        if (this.isArray || this.vbytes == null) {
            return false;
        }
        return this.vbytes[0] != 0;
    }

    public char getChar() {
        if (this.isArray || this.vbytes == null) {
            return '\u0000';
        }
        byte by = this.vbytes[0];
        byte by2 = this.vbytes[1];
        return (char)((by << 8) + (by2 << 0));
    }

    public byte getByte() {
        if (this.isArray || this.vbytes == null) {
            return -128;
        }
        return this.vbytes[0];
    }

    public short getShort() {
        if (this.isArray || this.vbytes == null) {
            return Short.MIN_VALUE;
        }
        byte by = this.vbytes[0];
        byte by2 = this.vbytes[1];
        return (short)((by << 8) + (by2 << 0));
    }

    public int getInt() {
        if (this.isArray || this.vbytes == null) {
            return Integer.MIN_VALUE;
        }
        int n = this.vbytes[0] & 0xFF;
        int n2 = this.vbytes[1] & 0xFF;
        int n3 = this.vbytes[2] & 0xFF;
        int n4 = this.vbytes[3] & 0xFF;
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public long getLong() {
        if (this.isArray || this.vbytes == null) {
            return Long.MIN_VALUE;
        }
        return ((long)this.vbytes[0] << 56) + ((long)(this.vbytes[1] & 0xFF) << 48) + ((long)(this.vbytes[2] & 0xFF) << 40) + ((long)(this.vbytes[3] & 0xFF) << 32) + ((long)(this.vbytes[4] & 0xFF) << 24) + (long)((this.vbytes[5] & 0xFF) << 16) + (long)((this.vbytes[6] & 0xFF) << 8) + (long)((this.vbytes[7] & 0xFF) << 0);
    }

    public float getFloat() {
        if (this.isArray || this.vbytes == null) {
            return Float.NaN;
        }
        return Float.intBitsToFloat(this.getInt());
    }

    public double getDouble() {
        if (this.isArray || this.vbytes == null) {
            return Double.NaN;
        }
        return Double.longBitsToDouble(this.getLong());
    }

    public String getString() {
        return this.svalue;
    }

    public long getDate() {
        return this.getLong();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n < 0 || n > 10) {
            throw new IllegalArgumentException("Trying to set an invalid field type (" + n + ").");
        }
        this.type = n;
    }

    public void setKey(boolean bl) {
        this.flag = bl ? (byte)(this.flag | _KEY) : (byte)(this.flag & 15 - _KEY);
    }

    public boolean isKey() {
        return (this.flag & _KEY) > 0;
    }

    public boolean isNumeric() {
        return this.type == 3 || this.type == 6 || this.type == 5 || this.type == 2 || this.type == 1 || this.type == 4;
    }

    public double convertToDouble() {
        if (this.isNoData() || this.isArray) {
            return Double.NaN;
        }
        switch (this.type) {
            case 1: {
                return this.getByte();
            }
            case 2: {
                return this.getShort();
            }
            case 3: {
                return this.getInt();
            }
            case 4: {
                return this.getLong();
            }
            case 5: {
                return this.getFloat();
            }
            case 6: {
                return this.getDouble();
            }
        }
        return Double.NaN;
    }

    public Field setNameAndKey(String string, boolean bl, String string2) {
        this.name = string;
        this.setKey(bl);
        this.displayName = string2;
        return this;
    }

    public Field setName(String string) {
        this.name = string;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setLabelText(boolean bl) {
        this.flag = bl ? (byte)(this.flag | _LABEL) : (byte)(this.flag & 255 - _LABEL);
    }

    public boolean isLabelText() {
        return (this.flag & _LABEL) > 0;
    }

    public Object getValue() {
        return this.toString();
    }

    public String toString() {
        if (this.isNoData()) {
            return "nodata";
        }
        String string = "";
        switch (this.type) {
            case 1: {
                return string + this.getByte();
            }
            case 2: {
                return string + this.getShort();
            }
            case 3: {
                return string + this.getInt();
            }
            case 4: {
                return string + this.getLong();
            }
            case 5: {
                return string + this.getFloat();
            }
            case 7: {
                return string + this.getChar();
            }
            case 6: {
                return string + this.getDouble();
            }
            case 9: {
                return string + this.getBoolean();
            }
            case 8: {
                return this.getString();
            }
            case 10: {
                return string + DateFormat.getDateTimeInstance().format(new Date(this.getDate()));
            }
        }
        return string;
    }

    public String getShortJavaTypeName() {
        return typeName[this.type];
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Field field = null;
        try {
            field = (Field)object;
        }
        catch (Exception exception) {
            return false;
        }
        boolean bl = false;
        bl = (this.name == field.name || this.name != null && this.name.equals(field.name)) && (this.displayName == field.displayName || this.displayName != null && this.displayName.equals(field.displayName)) && this.bytesEqual(field.vbytes) && (this.svalue == field.svalue || this.svalue != null && this.svalue.equals(field.svalue)) && this.type == field.type && this.flag == field.flag;
        return bl;
    }

    private boolean bytesEqual(byte[] byArray) {
        if (this.vbytes == null && byArray == null) {
            return true;
        }
        if (this.vbytes != null && byArray != null) {
            if (this.vbytes.length != byArray.length) {
                return false;
            }
            for (int i = 0; i < this.vbytes.length; ++i) {
                if (this.vbytes[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object object) {
        Field field = (Field)object;
        if (field == null) {
            return this.isNoData() ? 0 : 1;
        }
        if (field.isNoData()) {
            return this.isNoData() ? 0 : 1;
        }
        if (this.isNoData() || this.isNoData()) {
            return -1;
        }
        switch (this.type) {
            case 8: {
                if (this.svalue == null) {
                    return field.svalue == null ? 0 : -1;
                }
                if (field.svalue == null) {
                    return -1;
                }
                return this.svalue.compareTo(field.svalue);
            }
            case 10: {
                long l = this.getDate();
                long l2 = field.getDate();
                return l > l2 ? 1 : (l < l2 ? -1 : 0);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                double d = this.convertToDouble();
                double d2 = field.convertToDouble();
                return d > d2 ? 1 : (d < d2 ? -1 : 0);
            }
            case 7: {
                char c = this.getChar();
                char c2 = field.getChar();
                return c > c2 ? 1 : (c < c2 ? -1 : 0);
            }
            case 1: 
            case 9: {
                byte by = this.getByte();
                byte by2 = field.getByte();
                return by > by2 ? 1 : (by < by2 ? -1 : 0);
            }
        }
        return 1;
    }

    public void setContexts(String[] stringArray) {
        this.contexts = stringArray;
    }

    public String[] getContexts() {
        return this.contexts;
    }

    public boolean isNoData() {
        return (this.flag & _NODATA) > 0;
    }

    public void setNoData() {
        this.flag = (byte)(this.flag | _NODATA);
        this.svalue = null;
        this.vbytes = null;
        this.type = 0;
    }

    public boolean isArray() {
        return this.isArray;
    }
}

