/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IPMonitor {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.MAPVIEWER);
    public static boolean enabled = false;
    public static Hashtable ipAllow = new Hashtable();
    public static Hashtable ipExclude = new Hashtable();
    static Integer dummy = new Integer(0);
    static int maxLength = 15;
    static int minLength = 1;

    public static boolean allow(String string) {
        if (!enabled) {
            return true;
        }
        if (IPMonitor.foundIP(ipExclude, string)) {
            return false;
        }
        return IPMonitor.foundIP(ipAllow, string);
    }

    public static void clearAll() {
        enabled = false;
        ipAllow.clear();
        ipExclude.clear();
    }

    private static boolean foundIP(Hashtable hashtable, String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (hashtable.isEmpty()) {
            return false;
        }
        if (hashtable.get("*") != null) {
            return true;
        }
        if (hashtable.get(string) != null) {
            return true;
        }
        try {
            int n = string.lastIndexOf(".");
            while (n > 0) {
                String string2 = string.substring(0, string.lastIndexOf(".")) + ".*";
                if (hashtable.get(string2) != null) {
                    return true;
                }
                string = string.substring(0, n);
                n = string.lastIndexOf(".");
            }
        }
        catch (Exception exception) {
            log.log(Level.FINER, exception.getMessage(), exception);
        }
        return false;
    }

    private static void putIP(String string, Hashtable hashtable) {
        hashtable.put(string, dummy);
    }

    private static void putIPs(String string, Hashtable hashtable) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!IPMonitor.validateIP(string2)) continue;
            hashtable.put(string2, dummy);
        }
    }

    private static void putIPRange(String string, Hashtable hashtable) {
        int n;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " -\t\n\r\f");
        int n3 = 0;
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            if (n3 == 0) {
                string2 = stringTokenizer.nextToken();
            } else if (n3 == 1) {
                string3 = stringTokenizer.nextToken();
            }
            ++n3;
        }
        System.out.println("ip1=" + string2 + ", ip2=" + string3);
        if (!IPMonitor.validateIP(string2) || !IPMonitor.validateIP(string3)) {
            log.severe("invalid form of IP(s) when adding IP range.");
            return;
        }
        try {
            n2 = Integer.parseInt(string2.substring(string2.lastIndexOf(".") + 1, string2.length()));
            n = Integer.parseInt(string3.substring(string3.lastIndexOf(".") + 1, string3.length()));
        }
        catch (Exception exception) {
            log.severe("could not get last digits in ip addr.");
            return;
        }
        if (n2 > n) {
            log.severe("start ip is greater than end ip.");
            return;
        }
        String string4 = string2.substring(0, string2.lastIndexOf(".") + 1);
        for (int i = n2; i <= n; ++i) {
            String string5 = string4 + i;
            hashtable.put(string5, dummy);
        }
    }

    public static void loadFromConfig(XMLDocument xMLDocument) throws XSLException {
        enabled = false;
        IPMonitor.clearAll();
        NodeList nodeList = xMLDocument.getElementsByTagName("ip_monitor");
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        XMLElement xMLElement = (XMLElement)nodeList.item(0);
        if (xMLElement == null) {
            return;
        }
        String string = null;
        nodeList = xMLElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string2 = node.getNodeName().toLowerCase();
            string = node.getFirstChild().getNodeValue();
            System.out.println("value=" + string);
            if (string2.equals("ips")) {
                IPMonitor.putIPs(string, ipAllow);
                continue;
            }
            if (string2.equals("ip_range")) {
                IPMonitor.putIPRange(string, ipAllow);
                continue;
            }
            if (string2.equals("ips_exclude")) {
                IPMonitor.putIPs(string, ipExclude);
                continue;
            }
            if (!string2.equals("ip_range_exclude")) continue;
            IPMonitor.putIPRange(string, ipExclude);
        }
        if (!ipAllow.isEmpty() || !ipExclude.isEmpty()) {
            enabled = true;
        }
    }

    private static boolean validateIP(String string) {
        if (string == null || string.length() < minLength || string.length() > maxLength) {
            return false;
        }
        int n = string.lastIndexOf("*");
        if (n > 0 && n != string.length() - 1) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || c == '.' || c == '*') continue;
            return false;
        }
        return true;
    }

    public static String print() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("\nAllowed IPs:\n");
        Enumeration enumeration = ipAllow.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("+ " + enumeration.nextElement() + "\n");
        }
        stringBuffer.append("Excluded IPs:\n");
        enumeration = ipExclude.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("- " + enumeration.nextElement() + "\n");
        }
        return stringBuffer.toString();
    }
}

