/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.Validator;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ideimpl.db.validate.DBValidationComponent;
import oracle.ideimpl.db.validate.SimpleListener;
import oracle.ideimpl.db.validate.TextListener;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.MissingValidatorException;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

public class DBValidationHandler {
    public static final Object DB_VALIDATION_KEY = "DB_VALIDATION_KEY";
    private final PropertyHelper m_propHelper = new PropertyHelper();
    private boolean m_suspendValidation;
    private AbstractDBObjectProvider m_pro;
    private DBObject m_original;
    private DBObject m_update;
    private final Collection<DBValidationComponent> m_components = new ArrayList<DBValidationComponent>();

    public void init(DBObjectProvider pro, DBObject orig, DBObject update) {
        this.m_pro = (AbstractDBObjectProvider)pro;
        this.m_original = orig;
        this.m_update = update;
    }

    public void registerComponent(Component comp, String path) {
        DBValidationComponent vc = null;
        if (comp instanceof JTextComponent) {
            vc = new DBValidationComponent(comp, path);
            new TextListener((ValidationComponent)vc);
        } else if (comp instanceof AbstractButton) {
            vc = new DBValidationComponent(comp, path);
            new SimpleListener((ValidationComponent)vc);
        }
        if (vc != null) {
            vc.addValidator(DB_VALIDATION_KEY, new VV(path));
            this.m_components.add(vc);
        }
    }

    public Collection<ValidationComponent> getValidationComponents() {
        return Collections.unmodifiableCollection(this.m_components);
    }

    public void setSuspendValidation(boolean suspend) {
        this.m_suspendValidation = suspend;
    }

    private class VV
    implements Validator {
        private String m_path;

        public VV(String path) {
            this.m_path = path;
        }

        public ValidationMessage[] validate(Component comp, Object data) {
            ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
            if (!DBValidationHandler.this.m_suspendValidation && DBValidationHandler.this.m_update != null && DBValidationHandler.this.m_pro != null && this.m_path != null) {
                Object existing = DBValidationHandler.this.m_propHelper.getPropertyValue((Object)(DBValidationHandler.this.m_original == null ? DBValidationHandler.this.m_update : DBValidationHandler.this.m_original), this.m_path);
                String lastPath = Property.getLastProperty((String)this.m_path);
                try {
                    if ("name".equals(lastPath)) {
                        DBValidationHandler.this.m_pro.validateName(DBValidationHandler.this.m_update.getType(), (String)data);
                    } else if (ModelUtil.areDifferent((Object)existing, (Object)data)) {
                        DBValidationHandler.this.m_propHelper.setPropertyValue((Object)DBValidationHandler.this.m_update, this.m_path, data);
                        DBValidationHandler.this.m_pro.validateObjectProperty(DBValidationHandler.this.m_original, DBValidationHandler.this.m_update, this.m_path);
                    }
                }
                catch (MissingValidatorException mve) {
                    DBLog.getLogger((Object)this).log(Level.FINE, mve.getMessage());
                }
                catch (ValidationException ve) {
                    messages.add(new ValidationMessage(1, ve.getMessage()));
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Error validating", e);
                }
                if (ModelUtil.areDifferent((Object)existing, (Object)data)) {
                    PropertyManager pm = DBValidationHandler.this.m_pro.getPropertyManager();
                    if (DBValidationHandler.this.m_original != null) {
                        PropertyAction action = pm.canChangeProperty(DBValidationHandler.this.m_original, DBValidationHandler.this.m_update, this.m_path);
                        if (action == null) {
                            DBLog.getLogger((Object)this).log(Level.FINE, "Unknown property: " + this.m_path);
                        } else if (action.getType() != PropertyAction.Type.ALTER) {
                            String msg = UIArb.format(116, PropertyDisplayRegistry.getDisplayName(lastPath.toString()));
                            messages.add(new ValidationMessage(2, msg));
                        }
                    }
                }
            }
            return messages.isEmpty() ? null : messages.toArray(new ValidationMessage[messages.size()]);
        }
    }
}

