/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.tablespace.CommonTablespacePanel;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.property.Property;

public class UndoTablespacePanel
extends BaseEditorPanel<Tablespace>
implements ItemListener,
ActionListener {
    private CommonTablespacePanel m_commonPanel;
    private JLabel m_lblRetention = new JLabel();
    private JComboBox m_cmbRetention = new JComboBox();
    private DefaultComboBoxModel m_mdlRetention = new NonNullableComboBoxModel();
    private boolean m_listening;

    public UndoTablespacePanel() {
        this.layoutComponents();
    }

    protected void layoutComponents() {
        DBUIHelper helper = this.getHelper();
        helper.registerComponent(this.m_lblRetention, this.m_cmbRetention, UIArb.getString(307), "Retention", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "retention"}));
        this.m_commonPanel = new CommonTablespacePanel(this, helper);
        this.m_commonPanel.setName("UNDO_TBSP_COMMON_PANEL");
        DBUILayoutHelper topLayout = new DBUILayoutHelper((JPanel)((Object)this));
        topLayout.setMargins(0);
        topLayout.add(this.m_commonPanel, 4, 1, true, false);
        topLayout.nextRow();
        topLayout.add(this.m_lblRetention);
        topLayout.add(this.m_cmbRetention);
        topLayout.pushUp();
        topLayout.layout();
        this.m_cmbRetention.setModel(this.m_mdlRetention);
    }

    @Override
    protected void initialisePanel() {
        OracleTablespaceProperties otp;
        Tablespace model = (Tablespace)this.getDBObject();
        this.m_commonPanel.initialisePanel(model);
        if (this.m_mdlRetention.getSize() == 0) {
            this.m_mdlRetention.addElement(UIArb.getString(327));
            this.m_mdlRetention.addElement(UIArb.getString(328));
        }
        if ((otp = (OracleTablespaceProperties)model.getProperty("OracleTablespaceProperties")) != null && otp.getRetention() != null) {
            if (otp.getRetention().equals((Object)OracleTablespaceProperties.RetentionType.GUARANTEE)) {
                this.m_mdlRetention.setSelectedItem(UIArb.getString(327));
            } else {
                this.m_mdlRetention.setSelectedItem(UIArb.getString(328));
            }
        }
    }

    @Override
    protected void commitPanel() {
        Tablespace tbsp = (Tablespace)this.getDBObject();
        this.m_commonPanel.commitPanel(tbsp);
        OracleTablespaceProperties otp = (OracleTablespaceProperties)tbsp.getProperty("OracleTablespaceProperties");
        if (otp == null) {
            otp = new OracleTablespaceProperties();
            tbsp.setProperty("OracleTablespaceProperties", (Object)otp);
        }
        if (this.m_mdlRetention.getSelectedItem().equals(UIArb.getString(327))) {
            otp.setRetention(OracleTablespaceProperties.RetentionType.GUARANTEE);
        } else {
            otp.setRetention(OracleTablespaceProperties.RetentionType.NOGUARANTEE);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_listening) {
            Object object = ae.getSource();
        }
    }
}

