/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.db.UIArb;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.tablespace.CommonTablespacePanel;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

public class TemporaryTablespacePanel
extends BaseEditorPanel<Tablespace>
implements ItemListener,
ActionListener {
    private CommonTablespacePanel m_commonPanel;
    private JLabel m_lblTbspGroup = new JLabel();
    private JTextField m_fldTbspGroup = new JTextField();
    private boolean m_listening;

    public TemporaryTablespacePanel() {
        this.layoutComponents();
    }

    protected void layoutComponents() {
        DBUIHelper helper = this.getHelper();
        helper.registerComponent(this.m_lblTbspGroup, this.m_fldTbspGroup, UIArb.getString(300), "TablespaceGroup", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "tablespaceGroup"}));
        this.m_fldTbspGroup.setColumns(20);
        this.m_commonPanel = new CommonTablespacePanel(this, helper);
        this.m_commonPanel.setName("TEMP_TBSP_COMMON_PANEL");
        DBUILayoutHelper topLayout = new DBUILayoutHelper((JPanel)((Object)this));
        topLayout.setMargins(0);
        topLayout.add(this.m_commonPanel, 4, 1, true, false);
        topLayout.nextRow();
        topLayout.add(this.m_lblTbspGroup);
        topLayout.add(this.m_fldTbspGroup);
        topLayout.pushUp();
        topLayout.layout();
    }

    @Override
    protected void initialisePanel() {
        Tablespace model = (Tablespace)this.getDBObject();
        this.m_commonPanel.initialisePanel(model);
        OracleTablespaceProperties otp = (OracleTablespaceProperties)model.getProperty("OracleTablespaceProperties");
        if (otp != null) {
            this.m_fldTbspGroup.setText(otp.getTablespaceGroup());
        }
    }

    @Override
    protected void commitPanel() {
        Tablespace tbsp = (Tablespace)this.getDBObject();
        this.m_commonPanel.commitPanel(tbsp);
        OracleTablespaceProperties otp = (OracleTablespaceProperties)tbsp.getProperty("OracleTablespaceProperties");
        if (otp == null) {
            otp = new OracleTablespaceProperties();
            tbsp.setProperty("OracleTablespaceProperties", (Object)otp);
        }
        if (ModelUtil.hasLength((String)this.m_fldTbspGroup.getText())) {
            otp.setTablespaceGroup(this.m_fldTbspGroup.getText());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_listening) {
            Object object = ae.getSource();
        }
    }
}

