/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.db.UIArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Tablespace;

public class TablespaceTypePanel
extends JPanel
implements ActionListener {
    private ActionListener m_actionListener;
    private ButtonGroup m_group = new ButtonGroup();
    private JRadioButton m_permanentRadio = new JRadioButton();
    private JRadioButton m_temporaryRadio = new JRadioButton();
    private JRadioButton m_undoRadio = new JRadioButton();

    public TablespaceTypePanel(boolean incTitle) {
        try {
            this.layoutComponents(incTitle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents(boolean incTitle) {
        this.m_permanentRadio.setName("RDB_PERM_TABLESPACE");
        this.m_temporaryRadio.setName("RDB_TEMP_TABLESPACE");
        this.m_undoRadio.setName("RDB_UNDO_TABLESPACE");
        this.m_group.add(this.m_permanentRadio);
        this.m_group.add(this.m_temporaryRadio);
        this.m_group.add(this.m_undoRadio);
        this.m_permanentRadio.addActionListener(this);
        this.m_undoRadio.addActionListener(this);
        this.m_temporaryRadio.addActionListener(this);
        this.m_permanentRadio.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this.m_permanentRadio, (String)UIArb.getString(549));
        ResourceUtils.resButton((AbstractButton)this.m_temporaryRadio, (String)UIArb.getString(550));
        ResourceUtils.resButton((AbstractButton)this.m_undoRadio, (String)UIArb.getString(551));
        this.setLayout(new GridBagLayout());
        int y = 0;
        int x = 0;
        if (incTitle) {
            JLabel title = new JLabel(UIArb.getString(548));
            this.add((Component)title, new GridBagConstraints(x, y, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        }
        this.add((Component)this.m_permanentRadio, new GridBagConstraints(x, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_temporaryRadio, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_undoRadio, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(++x, y, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void enableAllComponents(boolean boo) {
        this.m_permanentRadio.setEnabled(boo);
        this.m_temporaryRadio.setEnabled(boo);
        this.m_undoRadio.setEnabled(boo);
    }

    public Tablespace.TablespaceType getTablespaceType() {
        if (this.m_temporaryRadio.isSelected()) {
            return Tablespace.TablespaceType.TEMPORARY;
        }
        if (this.m_undoRadio.isSelected()) {
            return Tablespace.TablespaceType.UNDO;
        }
        return Tablespace.TablespaceType.PERMANENT;
    }

    public void setTablespaceType(Tablespace.TablespaceType type) {
        switch (type) {
            case UNDO: {
                this.m_undoRadio.setSelected(true);
                break;
            }
            case TEMPORARY: {
                this.m_temporaryRadio.setSelected(true);
                break;
            }
            default: {
                this.m_permanentRadio.setSelected(true);
            }
        }
        this.actionPerformed(null);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.m_actionListener = AWTEventMulticaster.add(this.m_actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.m_actionListener = AWTEventMulticaster.remove(this.m_actionListener, l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            e.setSource(this);
            this.m_actionListener.actionPerformed(e);
        }
    }
}

