/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.tablespace.CommonTablespacePanel;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.property.Property;

public class PermanentTablespacePanel
extends BaseEditorPanel<Tablespace>
implements ItemListener,
ActionListener {
    private CommonTablespacePanel m_commonPanel;
    private JLabel m_lblBlockSize = new JLabel();
    private NumberTextField m_fldBlockSize = new NumberTextField();
    private JLabel m_lblLogging = new JLabel();
    private JComboBox m_cmblogging = new JComboBox();
    private DefaultComboBoxModel m_mdlLogging = new NonNullableComboBoxModel();
    private JCheckBox m_chkForceLogging = new JCheckBox();
    private JLabel m_lblCompress = new JLabel();
    private JComboBox m_cmbCompress = new JComboBox();
    private DefaultComboBoxModel m_mdlCompress = new NonNullableComboBoxModel();
    private JLabel m_lblOnline = new JLabel();
    private JComboBox m_cmbOnline = new JComboBox();
    private DefaultComboBoxModel m_mdlOnline = new NonNullableComboBoxModel();
    private JLabel m_lblSegMgmnt = new JLabel();
    private JComboBox m_cmbSegMgmnt = new JComboBox();
    private DefaultComboBoxModel m_mdlSegMgmnt = new NonNullableComboBoxModel();
    private boolean m_listening;

    public PermanentTablespacePanel() {
        this.layoutComponents();
    }

    protected void layoutComponents() {
        DBUIHelper helper = this.getHelper();
        helper.registerComponent(this.m_lblBlockSize, (Component)this.m_fldBlockSize, UIArb.getString(298), "BlockSize", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "blockSize"}));
        helper.registerComponent(this.m_lblLogging, this.m_cmblogging, UIArb.getString(301), "Logging", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "logging"}));
        helper.registerComponent(this.m_chkForceLogging, UIArb.getString(302), "Forcelogging", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "forceLogging"}));
        helper.registerComponent(this.m_lblCompress, this.m_cmbCompress, UIArb.getString(303), "DefaultTableCimpression", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "defaultTableCompression"}));
        helper.registerComponent(this.m_lblOnline, this.m_cmbOnline, UIArb.getString(305), "OnlineStatus", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "onlineStatus"}));
        helper.registerComponent(this.m_lblSegMgmnt, this.m_cmbSegMgmnt, UIArb.getString(306), "SegmentManangement", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "segmentManagement"}));
        this.m_commonPanel = new CommonTablespacePanel(this, helper);
        this.m_commonPanel.setName("PERM_TBSP_COMMON_PANEL");
        DBUILayoutHelper topLayout = new DBUILayoutHelper((JPanel)((Object)this));
        topLayout.setMargins(0);
        topLayout.add(this.m_commonPanel, 4, 1, true, false);
        topLayout.nextRow();
        topLayout.add(this.m_lblBlockSize);
        topLayout.add((Component)this.m_fldBlockSize);
        topLayout.add(this.m_lblOnline);
        topLayout.add(this.m_cmbOnline);
        topLayout.setMinWidth(this.m_cmbOnline, 50);
        topLayout.nextRow();
        topLayout.add(this.m_lblLogging);
        topLayout.add(this.m_cmblogging);
        topLayout.add(this.m_chkForceLogging, 2, 1);
        topLayout.nextColumn();
        topLayout.nextRow();
        topLayout.add(this.m_lblSegMgmnt);
        topLayout.add(this.m_cmbSegMgmnt);
        topLayout.add(this.m_lblCompress);
        topLayout.add(this.m_cmbCompress);
        topLayout.setMinWidth(this.m_cmbCompress, 50);
        topLayout.nextRow();
        topLayout.pushUp();
        topLayout.layout();
        this.m_cmblogging.setModel(this.m_mdlLogging);
        this.m_cmbCompress.setModel(this.m_mdlCompress);
        this.m_cmbOnline.setModel(this.m_mdlOnline);
        this.m_cmbSegMgmnt.setModel(this.m_mdlSegMgmnt);
        this.m_listening = true;
    }

    @Override
    protected void initialisePanel() {
        OracleTablespaceProperties otp;
        Tablespace model = (Tablespace)this.getDBObject();
        this.m_commonPanel.initialisePanel(model);
        if (this.m_mdlLogging.getSize() == 0) {
            this.m_mdlLogging.addElement(UIArb.getString(308));
            this.m_mdlLogging.addElement(UIArb.getString(309));
            this.m_mdlLogging.addElement(UIArb.getString(310));
        }
        if (this.m_mdlCompress.getSize() == 0) {
            this.m_mdlCompress.addElement(UIArb.getString(314));
            if (112 <= this.getProvider().getDescriptor().getDatabaseVersion()) {
                this.m_mdlCompress.addElement(UIArb.getString(315));
                this.m_mdlCompress.addElement(UIArb.getString(1009));
                this.m_mdlCompress.addElement(UIArb.getString(317));
                this.m_mdlCompress.addElement(UIArb.getString(316));
                this.m_mdlCompress.addElement(UIArb.getString(318));
                this.m_mdlCompress.addElement(UIArb.getString(319));
            } else {
                this.m_mdlCompress.addElement(UIArb.getString(311));
                this.m_mdlCompress.addElement(UIArb.getString(312));
                this.m_mdlCompress.addElement(UIArb.getString(313));
            }
        }
        if (this.m_mdlOnline.getSize() == 0) {
            this.m_mdlOnline.addElement(UIArb.getString(320));
            this.m_mdlOnline.addElement(UIArb.getString(321));
            this.m_mdlOnline.addElement(UIArb.getString(322));
            this.m_mdlOnline.addElement(UIArb.getString(323));
            this.m_mdlOnline.addElement(UIArb.getString(324));
        }
        if (this.m_mdlSegMgmnt.getSize() == 0) {
            this.m_mdlSegMgmnt.addElement(UIArb.getString(325));
            this.m_mdlSegMgmnt.addElement(UIArb.getString(326));
        }
        if ((otp = (OracleTablespaceProperties)model.getProperty("OracleTablespaceProperties")) != null) {
            if (otp.getBlockSize() != null) {
                this.m_fldBlockSize.setNumber((Number)otp.getBlockSize());
            }
            if (otp.getLogging() != null) {
                if (otp.getLogging().equals((Object)OracleTablespaceProperties.LoggingType.LOGGING)) {
                    this.m_mdlLogging.setSelectedItem(UIArb.getString(308));
                } else if (otp.getLogging().equals((Object)OracleTablespaceProperties.LoggingType.NOLOGGING)) {
                    this.m_mdlLogging.setSelectedItem(UIArb.getString(309));
                } else {
                    this.m_mdlLogging.setSelectedItem(UIArb.getString(310));
                }
            }
            if (otp.getDefaultTableCompression() != null) {
                if (otp.getDefaultTableCompression().equals((Object)OracleTablespaceProperties.DefaultTableCompression.COMPRESS)) {
                    if (112 <= this.getProvider().getDescriptor().getDatabaseVersion()) {
                        this.m_mdlCompress.setSelectedItem(UIArb.getString(315));
                    } else {
                        this.m_mdlCompress.setSelectedItem(UIArb.getString(311));
                    }
                } else if (otp.getDefaultTableCompression().equals((Object)OracleTablespaceProperties.DefaultTableCompression.NOCOMPRESS)) {
                    this.m_mdlCompress.setSelectedItem(UIArb.getString(314));
                } else if (otp.getDefaultTableCompression().equals((Object)OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_ALL_OPERATIONS)) {
                    this.m_mdlCompress.setSelectedItem(UIArb.getString(312));
                } else if (otp.getDefaultTableCompression().equals((Object)OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_OLTP)) {
                    this.m_mdlCompress.setSelectedItem(UIArb.getString(1009));
                } else if (otp.getDefaultTableCompression().equals((Object)OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_QUERY_LOW)) {
                    this.m_mdlCompress.setSelectedItem(UIArb.getString(317));
                } else if (otp.getDefaultTableCompression().equals((Object)OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_QUERY_HIGH)) {
                    this.m_mdlCompress.setSelectedItem(UIArb.getString(316));
                } else if (otp.getDefaultTableCompression().equals((Object)OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_ARCHIVE_LOW)) {
                    this.m_mdlCompress.setSelectedItem(UIArb.getString(318));
                } else if (otp.getDefaultTableCompression().equals((Object)OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_ARCHIVE_HIGH)) {
                    this.m_mdlCompress.setSelectedItem(UIArb.getString(319));
                } else {
                    this.m_mdlCompress.setSelectedItem(UIArb.getString(313));
                }
            }
            if (otp.getOnlineStatus() != null) {
                if (otp.getOnlineStatus().equals((Object)OracleTablespaceProperties.OnlineStatus.ONLINE)) {
                    this.m_mdlOnline.setSelectedItem(UIArb.getString(320));
                } else if (otp.getOnlineStatus().equals((Object)OracleTablespaceProperties.OnlineStatus.OFFLINE)) {
                    this.m_mdlOnline.setSelectedItem(UIArb.getString(321));
                } else if (otp.getOnlineStatus().equals((Object)OracleTablespaceProperties.OnlineStatus.OFFLINE_NORMAL)) {
                    this.m_mdlOnline.setSelectedItem(UIArb.getString(322));
                } else if (otp.getOnlineStatus().equals((Object)OracleTablespaceProperties.OnlineStatus.OFFLINE_TEMPORARY)) {
                    this.m_mdlOnline.setSelectedItem(UIArb.getString(323));
                } else {
                    this.m_mdlOnline.setSelectedItem(UIArb.getString(324));
                }
            }
            if (otp.getSegmentManagement() != null) {
                if (otp.getSegmentManagement().equals((Object)OracleTablespaceProperties.SegmentManagement.AUTO)) {
                    this.m_mdlSegMgmnt.setSelectedItem(UIArb.getString(325));
                } else {
                    this.m_mdlSegMgmnt.setSelectedItem(UIArb.getString(326));
                }
            }
            if (otp.isForceLogging()) {
                this.m_chkForceLogging.setSelected(true);
            } else {
                this.m_chkForceLogging.setSelected(false);
            }
        }
    }

    @Override
    protected void commitPanel() {
        Tablespace tbsp = (Tablespace)this.getDBObject();
        this.m_commonPanel.commitPanel(tbsp);
        OracleTablespaceProperties otp = (OracleTablespaceProperties)tbsp.getProperty("OracleTablespaceProperties");
        if (otp == null) {
            otp = new OracleTablespaceProperties();
            tbsp.setProperty("OracleTablespaceProperties", (Object)otp);
        }
        otp.setBlockSize((Integer)this.m_fldBlockSize.getNumber());
        if (this.m_mdlLogging.getSelectedItem().equals(UIArb.getString(308))) {
            otp.setLogging(OracleTablespaceProperties.LoggingType.LOGGING);
        } else if (this.m_mdlLogging.getSelectedItem().equals(UIArb.getString(309))) {
            otp.setLogging(OracleTablespaceProperties.LoggingType.NOLOGGING);
        } else {
            otp.setLogging(OracleTablespaceProperties.LoggingType.FILESYSTEM_LIKE_LOGGING);
        }
        if (this.m_mdlCompress.getSelectedItem().equals(UIArb.getString(311)) || this.m_mdlCompress.getSelectedItem().equals(UIArb.getString(315))) {
            otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS);
        } else if (this.m_mdlCompress.getSelectedItem().equals(UIArb.getString(314))) {
            otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.NOCOMPRESS);
        } else if (this.m_mdlCompress.getSelectedItem().equals(UIArb.getString(312))) {
            otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_ALL_OPERATIONS);
        } else if (this.m_mdlCompress.getSelectedItem().equals(UIArb.getString(1009))) {
            otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_OLTP);
        } else if (this.m_mdlCompress.getSelectedItem().equals(UIArb.getString(317))) {
            otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_QUERY_LOW);
        } else if (this.m_mdlCompress.getSelectedItem().equals(UIArb.getString(316))) {
            otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_QUERY_HIGH);
        } else if (this.m_mdlCompress.getSelectedItem().equals(UIArb.getString(318))) {
            otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_ARCHIVE_LOW);
        } else if (this.m_mdlCompress.getSelectedItem().equals(UIArb.getString(319))) {
            otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_ARCHIVE_HIGH);
        } else {
            otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS);
        }
        if (this.m_mdlOnline.getSelectedItem().equals(UIArb.getString(320))) {
            otp.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.ONLINE);
        } else if (this.m_mdlOnline.getSelectedItem().equals(UIArb.getString(321))) {
            otp.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.OFFLINE);
        } else if (this.m_mdlOnline.getSelectedItem().equals(UIArb.getString(322))) {
            otp.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.OFFLINE_NORMAL);
        } else if (this.m_mdlOnline.getSelectedItem().equals(UIArb.getString(323))) {
            otp.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.OFFLINE_TEMPORARY);
        } else {
            otp.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.OFFLINE_IMMEDIATE);
        }
        if (this.m_mdlSegMgmnt.getSelectedItem().equals(UIArb.getString(325))) {
            otp.setSegmentManagement(OracleTablespaceProperties.SegmentManagement.AUTO);
        } else {
            otp.setSegmentManagement(OracleTablespaceProperties.SegmentManagement.MANUAL);
        }
        otp.setForceLogging(this.m_chkForceLogging.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_listening) {
            Object object = ae.getSource();
        }
    }
}

