/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBSizeChooser;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.AutoExtendProperties;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

public class FileSpecificationEditorPanel
extends ChildObjectEditorPanel<FileSpecification, Tablespace>
implements ActionListener {
    private JPanel m_autoExtendPanel = new JPanel();
    private JLabel m_lblFileName = new JLabel();
    private JTextField m_fldName = new JTextField();
    private final JLabel m_lblDirName = new JLabel();
    private final JTextField m_fldDirName = new JTextField();
    private JLabel m_lblFileSize = new JLabel();
    private DBSizeChooser m_fldFileSize = new DBSizeChooser();
    private JCheckBox m_chkResuse = new JCheckBox();
    private JCheckBox m_chkAutoExtend = new JCheckBox();
    private JLabel m_lblNextSize = new JLabel();
    private DBSizeChooser m_fldNextSize = new DBSizeChooser();
    private JLabel m_lblMaxSize = new JLabel();
    private DBSizeChooser m_fldMaxSize = new DBSizeChooser();
    private final JCheckBox m_chkUnlimited = new JCheckBox();
    private DBObjectProvider m_prov;
    private FileSpecification m_fileSpec;
    private boolean m_listening;

    public FileSpecificationEditorPanel() {
        super("FileSpecificationEditorPanel", "fileSpecifications");
        this.layoutComponents();
        this.enableAllComponents(false);
    }

    private void layoutComponents() {
        DBUIHelper helper = this.getHelper();
        helper.setBasePath("fileSpecifications");
        helper.registerComponent(this.m_lblFileName, this.m_fldName, UIArb.getString(592), "Name", "name");
        helper.registerComponent(this.m_lblDirName, this.m_fldDirName, UIArb.getString(1010), "Directory", "directory");
        helper.registerComponent(this.m_lblFileSize, this.m_fldFileSize, UIArb.getString(593), "Size", "fileSize");
        helper.registerComponent(this.m_chkResuse, UIArb.getString(594), "Reuse", "reuse");
        helper.registerComponent(this.m_chkAutoExtend, UIArb.getString(598), "AutoExtendOn", Property.createPath((String[])new String[]{"autoExtendProperties", "autoExtendOn"}));
        helper.registerComponent(this.m_lblNextSize, this.m_fldNextSize, UIArb.getString(599), "NextSize", Property.createPath((String[])new String[]{"autoExtendProperties", "nextSize"}));
        helper.registerComponent(this.m_lblMaxSize, this.m_fldMaxSize, UIArb.getString(600), "MaxSize", Property.createPath((String[])new String[]{"autoExtendProperties", "maxSize"}));
        helper.registerComponent(this.m_chkUnlimited, UIArb.getString(1011), "Unlimited", Property.createPath((String[])new String[]{"autoExtendProperties", "maxSize"}));
        this.m_fldName.setColumns(30);
        this.m_chkAutoExtend.setSelected(false);
        this.setLayout(new GridBagLayout());
        this.m_autoExtendPanel.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(UIArb.getString(602)));
        this.add(this.m_lblFileName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add(this.m_fldName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(10, 8, 0, 10), 0, 0));
        this.add(this.m_lblDirName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add(this.m_fldDirName, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 13, 2, new Insets(10, 8, 0, 10), 0, 0));
        this.add(this.m_lblFileSize, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 10, 0, 0), 0, 0));
        this.add(this.m_fldFileSize, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 13, 2, new Insets(6, 8, 0, 10), 0, 0));
        this.add(this.m_chkResuse, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 17, 0, new Insets(6, 10, 0, 0), 0, 0));
        JComboCardPanel cardPanel = new JComboCardPanel(new JLabel(), (JComponent)this.m_chkAutoExtend);
        cardPanel.setName("FS_AUTO_EXTEND_PANEL");
        this.m_autoExtendPanel.setName("FS_AUTO_EXTEND_SUBPANEL");
        cardPanel.showSubPanel((JComponent)this.m_autoExtendPanel);
        this.add((Component)cardPanel, new GridBagConstraints(0, 13, 4, 10, 1.0, 1.0, 18, 2, new Insets(16, 10, 0, 10), 0, 0));
        this.m_autoExtendPanel.add((Component)this.m_lblNextSize, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 10, 0, 0), 0, 0));
        this.m_autoExtendPanel.add((Component)this.m_fldNextSize, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(6, 8, 0, 10), 0, 0));
        this.m_autoExtendPanel.add((Component)this.m_lblMaxSize, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 10, 10, 0), 0, 0));
        this.m_autoExtendPanel.add((Component)this.m_fldMaxSize, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 13, 2, new Insets(6, 8, 10, 0), 0, 0));
        this.m_autoExtendPanel.add((Component)this.m_chkUnlimited, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 10, 10), 0, 0));
        this.m_chkAutoExtend.addActionListener(this);
        this.m_chkUnlimited.addActionListener(this);
        this.m_listening = true;
    }

    @Override
    protected JTextComponent getNameField() {
        return this.m_fldName;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        this.setFileSpecification((FileSpecification)this.getChildObject());
    }

    @Override
    protected void commitPanel() throws TraversalException {
        FileSpecification fileSpec = (FileSpecification)this.getChildObject();
        this.commit(fileSpec);
        Tablespace tbsp = (Tablespace)fileSpec.getParent();
        if (tbsp.getFileSpecification(fileSpec.getName()) == null) {
            tbsp.addFileSpecification(fileSpec);
        }
    }

    private void commit(FileSpecification fileSpec) throws TraversalException {
        FileSpecification newFileSpec = (FileSpecification)fileSpec.copyTo(null);
        newFileSpec.setParent(fileSpec.getParent());
        try {
            this.m_prov.validateName("FILE_SPECIFICATION", this.m_fldName.getText());
        }
        catch (InvalidNameException e) {
            throw new TraversalException(e.getMessage());
        }
        newFileSpec.setName(this.m_prov.getInternalName(this.m_fldName.getText()));
        if (ModelUtil.hasLength((String)this.m_fldDirName.getText())) {
            newFileSpec.setDirectory(this.m_fldDirName.getText());
        }
        if (this.m_chkResuse.isSelected()) {
            newFileSpec.setReuse(true);
        }
        if (this.m_chkAutoExtend.isSelected()) {
            AutoExtendProperties extendProps = new AutoExtendProperties();
            extendProps.setAutoExtendOn(true);
            if (this.m_fldMaxSize != null && ModelUtil.hasLength((String)this.m_fldMaxSize.getText())) {
                BigInteger maxSize = BigInteger.ZERO;
                if (!this.m_chkUnlimited.isSelected()) {
                    maxSize = new BigInteger(this.m_fldMaxSize.getText());
                }
                extendProps.setMaxSize(maxSize);
            } else if (this.m_chkUnlimited.isSelected()) {
                extendProps.setMaxSize(BigInteger.ZERO);
            }
            if (ModelUtil.hasLength((String)this.m_fldNextSize.getText())) {
                BigInteger nextSize = new BigInteger(this.m_fldNextSize.getText());
                extendProps.setNextSize(nextSize);
            }
            if (extendProps.getMaxSize() != null) {
                newFileSpec.setAutoExtendProperties(extendProps);
            }
        }
        newFileSpec.setFileSize(this.m_fldFileSize.getNumber() == null ? null : new BigInteger(this.m_fldFileSize.getText()));
        newFileSpec.copyTo((Object)fileSpec);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_listening) {
            Object src = ae.getSource();
            if (src == this.m_chkAutoExtend) {
                this.m_fldNextSize.setEnabled(((JCheckBox)src).isSelected());
                this.m_fldMaxSize.setEnabled(((JCheckBox)src).isSelected() && !this.m_chkUnlimited.isSelected());
                this.m_lblNextSize.setEnabled(((JCheckBox)src).isSelected());
                this.m_lblMaxSize.setEnabled(((JCheckBox)src).isSelected() && !this.m_chkUnlimited.isSelected());
                this.m_chkUnlimited.setEnabled(((JCheckBox)src).isSelected());
            } else if (src == this.m_chkUnlimited) {
                this.m_fldMaxSize.setEnabled(!((JCheckBox)src).isSelected());
            }
        }
    }

    private void initImpl(DBObjectProvider prov) {
        this.m_prov = prov;
    }

    public void setFileSpecification(FileSpecification fileSpec) {
        if (fileSpec == null) {
            this.m_fileSpec = null;
        } else {
            this.m_fileSpec = (FileSpecification)fileSpec.copyTo(null);
            this.m_fileSpec.setParent(fileSpec.getParent());
        }
        this.updateFileSpecification();
    }

    private void updateFileSpecification() {
        if (this.m_fileSpec == null) {
            this.m_fldName.setText(null);
            this.m_fldDirName.setText(null);
            this.m_chkResuse.setSelected(false);
            this.m_chkAutoExtend.setSelected(false);
            this.m_fldMaxSize.setEnabled(false);
            this.m_fldNextSize.setEnabled(false);
            this.m_lblMaxSize.setEnabled(false);
            this.m_lblNextSize.setEnabled(false);
            this.m_chkUnlimited.setEnabled(false);
            this.enableAllComponents(false);
        } else {
            this.enableAllComponents(true);
            this.m_fldName.setText(this.m_prov.getExternalName(this.m_fileSpec.getName()));
            this.m_fldDirName.setText(this.m_fileSpec.getDirectory());
            this.m_fldFileSize.setNumber(this.m_fileSpec.getFileSize());
            this.m_chkResuse.setSelected(this.m_fileSpec.isReuse());
            this.m_chkAutoExtend.setSelected(this.m_fileSpec.getAutoExtendProperties() != null && this.m_fileSpec.getAutoExtendProperties().isAutoExtendOn());
            AutoExtendProperties autoextendProps = this.m_fileSpec.getAutoExtendProperties();
            if (autoextendProps != null) {
                this.m_chkAutoExtend.setSelected(autoextendProps.isAutoExtendOn());
                if (autoextendProps.getMaxSize() != null && autoextendProps.getMaxSize().equals(BigInteger.ZERO)) {
                    this.m_chkUnlimited.setSelected(true);
                    this.m_fldMaxSize.setEnabled(false);
                } else {
                    this.m_fldMaxSize.setNumber(autoextendProps.getMaxSize());
                }
                this.m_fldNextSize.setNumber(autoextendProps.getNextSize());
            } else {
                this.m_chkAutoExtend.setSelected(false);
                this.m_fldMaxSize.setNumber(null);
                this.m_fldMaxSize.setEnabled(false);
                this.m_fldNextSize.setNumber(null);
                this.m_fldNextSize.setEnabled(false);
                this.m_lblMaxSize.setEnabled(false);
                this.m_lblNextSize.setEnabled(false);
                this.m_chkUnlimited.setSelected(false);
                this.m_chkUnlimited.setEnabled(false);
            }
        }
        this.validate();
        this.repaint();
    }

    private void enableAllComponents(boolean boo) {
        this.m_fldName.setEnabled(boo);
        this.m_fldDirName.setEnabled(boo);
        this.m_fldFileSize.setEnabled(boo);
        this.m_lblFileSize.setEnabled(boo);
        this.m_chkResuse.setEnabled(boo);
        this.m_chkAutoExtend.setEnabled(boo);
        this.m_fldMaxSize.setEnabled(this.m_chkAutoExtend.isEnabled() && boo);
        this.m_fldNextSize.setEnabled(this.m_chkAutoExtend.isEnabled() && boo);
        this.m_lblMaxSize.setEnabled(this.m_chkAutoExtend.isEnabled() && boo);
        this.m_lblNextSize.setEnabled(this.m_chkAutoExtend.isEnabled() && boo);
        this.m_chkUnlimited.setEnabled(this.m_chkAutoExtend.isEnabled() && boo);
    }
}

