/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBSizeChooser;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.property.Property;

public class CommonTablespacePanel
extends JPanel
implements ActionListener {
    private JLabel m_lblFileType = new JLabel();
    private JRadioButton m_rdbSmallFile = new JRadioButton();
    private JRadioButton m_rdbBigFile = new JRadioButton();
    private JLabel m_lblExtentMgmnt = new JLabel();
    private JComboBox m_cmbExtentMgmnt = new JComboBox();
    private DefaultComboBoxModel m_mdlExtentMgmnt = new NonNullableComboBoxModel();
    private JCheckBox m_chkAutoAllocate = new JCheckBox();
    private JCheckBox m_chkStorage = new JCheckBox();
    private DBSizeChooser m_fldUniformSize = new DBSizeChooser();
    private JLabel m_lblUniformSize = new JLabel();
    private JLabel m_lblInitExtent = new JLabel();
    private DBSizeChooser m_fldInitExtent = new DBSizeChooser();
    private JLabel m_lblNextExtent = new JLabel();
    private DBSizeChooser m_fldNextExtent = new DBSizeChooser();
    private JLabel m_lblMinExtents = new JLabel();
    private NumberTextField m_fldMinExtents = new NumberTextField();
    private JLabel m_lblMaxExtents = new JLabel();
    private NumberTextField m_fldMaxExtents = new NumberTextField();
    private JLabel m_lblPctIncr = new JLabel();
    private NumberTextField m_fldPctIncr = new NumberTextField();
    private boolean m_listening;

    public CommonTablespacePanel(BaseEditorPanel parentPanel, DBUIHelper dbUIHelper) {
        try {
            this.layoutComponents(parentPanel, dbUIHelper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents(BaseEditorPanel parentPanel, DBUIHelper helper) {
        helper.registerComponent(this.m_rdbSmallFile, UIArb.getString(282), "SmallFile", "fileType");
        helper.registerComponent(this.m_rdbBigFile, UIArb.getString(283), "BigFile", "fileType");
        helper.registerComponent(this.m_lblExtentMgmnt, this.m_cmbExtentMgmnt, UIArb.getString(288), "ExtentManagement", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "extentManagementType"}));
        helper.registerComponent(this.m_chkAutoAllocate, UIArb.getString(291), "AutoAllocate", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "autoAllocate"}));
        helper.registerComponent(this.m_chkStorage, UIArb.getString(304), "StorageProperties", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "properties", "OracleStorageProperties"}));
        helper.registerComponent(this.m_lblInitExtent, this.m_fldInitExtent, UIArb.getString(295), "InitialExtent", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "properties", "OracleStorageProperties", "initialExtent"}));
        helper.registerComponent(this.m_lblNextExtent, this.m_fldNextExtent, UIArb.getString(296), "NextExtent", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "properties", "OracleStorageProperties", "nextExtent"}));
        helper.registerComponent(this.m_lblMinExtents, (Component)this.m_fldMinExtents, UIArb.getString(299), "MinExtents", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "properties", "OracleStorageProperties", "minExtent"}));
        helper.registerComponent(this.m_lblMaxExtents, (Component)this.m_fldMaxExtents, UIArb.getString(294), "MaxExtents", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "properties", "OracleStorageProperties", "maxExtent"}));
        helper.registerComponent(this.m_lblPctIncr, (Component)this.m_fldPctIncr, UIArb.getString(297), "PctIncrease", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "properties", "OracleStorageProperties", "percentIncrease"}));
        helper.registerComponent(this.m_lblUniformSize, this.m_fldUniformSize, UIArb.getString(292), "UniformSize", Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "uniformSize"}));
        AccessibleContext actx = this.m_rdbSmallFile.getAccessibleContext();
        if (actx != null) {
            actx.setAccessibleName(DataTypeHelper.getNameFromLabel((String)UIArb.getString(281)) + DataTypeHelper.getNameFromLabel((String)UIArb.getString(282)));
        }
        if ((actx = this.m_rdbBigFile.getAccessibleContext()) != null) {
            actx.setAccessibleName(DataTypeHelper.getNameFromLabel((String)UIArb.getString(281)) + DataTypeHelper.getNameFromLabel((String)UIArb.getString(283)));
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbSmallFile);
        bg.add(this.m_rdbBigFile);
        this.m_rdbSmallFile.setSelected(true);
        this.m_lblFileType.setText(UIArb.getString(281));
        DBUILayoutHelper topLayout = new DBUILayoutHelper(this);
        topLayout.setMargins(0);
        DBUILayoutHelper fileTypeLayout = topLayout.newChildHelper(1, 1, true, false);
        fileTypeLayout.add(this.m_lblFileType);
        fileTypeLayout.add(this.m_rdbSmallFile);
        fileTypeLayout.add(this.m_rdbBigFile);
        fileTypeLayout.pushLeft();
        topLayout.nextRow();
        DBUILayoutHelper extMgmtLayout = topLayout.newTitledBorderHelper(UIArb.getString(287), 1, 3, true, false);
        extMgmtLayout.add(this.m_lblExtentMgmnt);
        extMgmtLayout.add(this.m_cmbExtentMgmnt, 2, 1, false, false);
        extMgmtLayout.nextRow();
        extMgmtLayout.add(this.m_chkAutoAllocate);
        extMgmtLayout.add(this.m_lblUniformSize);
        extMgmtLayout.add(this.m_fldUniformSize);
        extMgmtLayout.nextRow();
        DBUILayoutHelper storageLayout = extMgmtLayout.newTitledBorderHelper(UIArb.getString(304), 4, 1, true, false);
        storageLayout.add(this.m_lblInitExtent);
        storageLayout.add(this.m_fldInitExtent);
        storageLayout.add(this.m_lblNextExtent);
        storageLayout.add(this.m_fldNextExtent);
        storageLayout.nextRow();
        storageLayout.add(this.m_lblMinExtents);
        storageLayout.add((Component)this.m_fldMinExtents);
        storageLayout.add(this.m_lblMaxExtents);
        storageLayout.add((Component)this.m_fldMaxExtents);
        storageLayout.nextRow();
        storageLayout.add(this.m_lblPctIncr);
        storageLayout.add((Component)this.m_fldPctIncr);
        topLayout.layout();
        this.m_chkAutoAllocate.addActionListener(this);
        this.m_rdbBigFile.addActionListener(this);
        this.m_rdbSmallFile.addActionListener(this);
        this.m_cmbExtentMgmnt.addActionListener(this);
        this.m_cmbExtentMgmnt.setModel(this.m_mdlExtentMgmnt);
        this.m_listening = true;
    }

    void initialisePanel(Tablespace tbsp) {
        OracleTablespaceProperties otp;
        Tablespace.FileType fileType = tbsp.getFileType();
        if (fileType != null && fileType.equals((Object)Tablespace.FileType.BIGFILE)) {
            this.m_rdbBigFile.setSelected(true);
        } else {
            this.m_rdbSmallFile.setSelected(true);
        }
        if (this.m_mdlExtentMgmnt.getSize() == 0) {
            this.m_mdlExtentMgmnt.addElement(UIArb.getString(289));
            this.m_mdlExtentMgmnt.addElement(UIArb.getString(290));
        }
        if ((otp = (OracleTablespaceProperties)tbsp.getProperty("OracleTablespaceProperties")) != null) {
            OracleTablespaceProperties.ExtentManagementType emt = otp.getExtentManagementType();
            if (emt.equals((Object)OracleTablespaceProperties.ExtentManagementType.DICTIONARY)) {
                this.m_mdlExtentMgmnt.setSelectedItem(UIArb.getString(290));
                this.m_chkAutoAllocate.setEnabled(false);
                this.m_fldUniformSize.setEnabled(false);
                this.m_lblUniformSize.setEnabled(false);
                OracleStorageProperties osp = (OracleStorageProperties)otp.getProperty("OracleStorageProperties");
                if (osp != null) {
                    this.m_fldInitExtent.setNumber(osp.getInitialExtent());
                    this.m_fldNextExtent.setNumber(osp.getNextExtent());
                    this.m_fldMinExtents.setNumber((Number)osp.getMinExtent());
                    this.m_fldMaxExtents.setNumber((Number)osp.getMaxExtent());
                    this.m_fldPctIncr.setNumber((Number)osp.getPercentIncrease());
                }
            } else {
                this.m_mdlExtentMgmnt.setSelectedItem(UIArb.getString(289));
                this.m_chkAutoAllocate.setSelected(otp.isAutoAllocate());
                this.m_fldUniformSize.setEnabled(!otp.isAutoAllocate());
                this.m_lblUniformSize.setEnabled(!otp.isAutoAllocate());
                this.m_fldUniformSize.setNumber(otp.getUniformSize());
            }
        }
    }

    void commitPanel(Tablespace tbsp) {
        if (this.m_rdbBigFile.isSelected()) {
            tbsp.setFileType(Tablespace.FileType.BIGFILE);
        } else {
            tbsp.setFileType(Tablespace.FileType.SMALLFILE);
        }
        OracleTablespaceProperties otp = (OracleTablespaceProperties)tbsp.getProperty("OracleTablespaceProperties");
        if (otp == null) {
            otp = new OracleTablespaceProperties();
            tbsp.setProperty("OracleTablespaceProperties", (Object)otp);
        }
        if (this.m_mdlExtentMgmnt.getSelectedItem().equals(UIArb.getString(289))) {
            otp.setExtentManagementType(OracleTablespaceProperties.ExtentManagementType.LOCAL);
            otp.setAutoAllocate(this.m_chkAutoAllocate.isSelected());
            if (!this.m_chkAutoAllocate.isSelected()) {
                otp.setUniformSize(this.m_fldUniformSize.getNumber() == null ? null : Integer.valueOf(this.m_fldUniformSize.getNumber().intValue()));
            }
            otp.setProperty("OracleStorageProperties", null);
        } else {
            otp.setExtentManagementType(OracleTablespaceProperties.ExtentManagementType.DICTIONARY);
            Tablespace.TablespaceType type = (Tablespace.TablespaceType)tbsp.getProperty("TablespaceType");
            if (type.equals((Object)Tablespace.TablespaceType.PERMANENT)) {
                OracleStorageProperties osp = (OracleStorageProperties)otp.getProperty("OracleTablespaceProperties");
                if (osp == null) {
                    osp = new OracleStorageProperties();
                    otp.setProperty("OracleStorageProperties", (Object)osp);
                }
                osp.setMinExtent((Integer)this.m_fldMinExtents.getNumber());
                osp.setMaxExtent((Integer)this.m_fldMaxExtents.getNumber());
                osp.setInitialExtent(this.m_fldInitExtent.getNumber() == null ? null : Integer.valueOf(this.m_fldInitExtent.getNumber().intValue()));
                osp.setNextExtent(this.m_fldNextExtent.getNumber() == null ? null : Integer.valueOf(this.m_fldNextExtent.getNumber().intValue()));
                osp.setPercentIncrease((Integer)this.m_fldPctIncr.getNumber());
            }
        }
        tbsp.setProperty("OracleTablespaceProperties", (Object)otp);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_listening) {
            Object src = ae.getSource();
            if (src == this.m_cmbExtentMgmnt) {
                if (this.m_mdlExtentMgmnt.getSelectedItem().equals(UIArb.getString(289))) {
                    this.m_chkAutoAllocate.setEnabled(true);
                    this.m_fldUniformSize.setEnabled(!this.m_chkAutoAllocate.isSelected());
                    this.m_lblUniformSize.setEnabled(!this.m_chkAutoAllocate.isSelected());
                    this.m_fldInitExtent.setEnabled(false);
                    this.m_fldNextExtent.setEnabled(false);
                    this.m_fldMinExtents.setEnabled(false);
                    this.m_fldMaxExtents.setEnabled(false);
                    this.m_fldPctIncr.setEnabled(false);
                    this.m_lblInitExtent.setEnabled(false);
                    this.m_lblNextExtent.setEnabled(false);
                    this.m_lblMinExtents.setEnabled(false);
                    this.m_lblMaxExtents.setEnabled(false);
                    this.m_lblPctIncr.setEnabled(false);
                } else {
                    this.m_chkAutoAllocate.setEnabled(false);
                    this.m_fldUniformSize.setEnabled(false);
                    this.m_lblUniformSize.setEnabled(false);
                    this.m_fldInitExtent.setEnabled(true);
                    this.m_fldNextExtent.setEnabled(true);
                    this.m_fldMinExtents.setEnabled(true);
                    this.m_fldMaxExtents.setEnabled(true);
                    this.m_fldPctIncr.setEnabled(true);
                    this.m_lblInitExtent.setEnabled(true);
                    this.m_lblNextExtent.setEnabled(true);
                    this.m_lblMinExtents.setEnabled(true);
                    this.m_lblMaxExtents.setEnabled(true);
                    this.m_lblPctIncr.setEnabled(true);
                }
            } else if (src == this.m_chkAutoAllocate) {
                this.m_fldUniformSize.setEnabled(!this.m_chkAutoAllocate.isSelected());
                this.m_lblUniformSize.setEnabled(!this.m_chkAutoAllocate.isSelected());
            }
        }
    }
}

