/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyFilter;

public class TemporaryTableStoragePanel
extends BaseEditorPanel<Table> {
    private JLabel m_tablespaceLabel = new JLabel();
    private DBObjectChooser m_tablespaceChooser = new DBObjectChooser("TABLESPACE");

    public TemporaryTableStoragePanel() {
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        DBUIHelper helper = this.getHelper();
        helper.registerComponent(this.m_tablespaceLabel, this.m_tablespaceChooser, UIArb.getString(709), Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "tablespaceID"}));
        this.add(this.m_tablespaceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add(this.m_tablespaceChooser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void initialisePanel() {
        this.m_tablespaceChooser.setFilter((DBObjectFilter)new PropertyFilter("properties/TablespaceType", (Object)Tablespace.TablespaceType.TEMPORARY));
        this.m_tablespaceChooser.setProvider(this.getProvider());
        this.m_tablespaceChooser.setNullText(UIArb.getString(1007));
        this.m_tablespaceLabel.setEnabled(!this.isEditing() || !(this.getProvider() instanceof Database));
        this.m_tablespaceChooser.setEnabled(!this.isEditing() || !(this.getProvider() instanceof Database));
        Table table = (Table)this.getDBObject();
        OracleStorageProperties osp = (OracleStorageProperties)table.getProperty("OracleStorageProperties");
        if (osp == null) {
            osp = new OracleStorageProperties();
        }
        this.m_tablespaceChooser.setDBObjectID(osp.getTablespaceID());
    }

    @Override
    protected void commitPanel() {
        OracleStorageProperties osp = (OracleStorageProperties)((Table)this.getDBObject()).getProperty("OracleStorageProperties");
        if (this.m_tablespaceChooser.getDBObjectID() != null && osp == null) {
            osp = new OracleStorageProperties();
            ((Table)this.getDBObject()).setProperty("OracleStorageProperties", (Object)osp);
        }
        if (osp != null) {
            osp.setTablespaceID(this.m_tablespaceChooser.getDBObjectID());
        }
    }
}

