/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;

public class CopyColumnPanel
extends JPanel {
    private DBObjectProvider m_pro;
    private Relation m_table;
    private Relation m_sourceTable;
    private boolean m_edit = false;
    private JLabel m_lblSchema = new JLabel();
    private JLabel m_lblTable = new JLabel();
    private JLabel m_lblColumns = new JLabel();
    private DBObjectChooser m_schemas = new DBObjectChooser("SCHEMA");
    private DBObjectChooser m_tables = new DBObjectChooser(this.m_schemas, "TABLE");
    private JList m_columns = new JList();
    private JScrollPane m_scrCols = new JScrollPane(this.m_columns);
    private JRadioButton m_radCopy = new JRadioButton();
    private JRadioButton m_radMove = new JRadioButton();
    private DBUIResourceHelper m_helper = new DBUIResourceHelper("ColumnInfoPanel.CopyColumnPanel");

    public CopyColumnPanel(DBObjectProvider pro, Relation table, boolean edit) {
        this.m_pro = pro;
        this.m_table = table;
        this.m_edit = edit;
        this.setLayout(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_radCopy);
        bg.add(this.m_radMove);
        JPanel buttPanel = new JPanel(new GridLayout());
        buttPanel.add(this.m_radCopy);
        buttPanel.add(this.m_radMove);
        this.m_helper.resLabel(this.m_lblSchema, this.m_schemas, UIArb.getString(604), "m_schemas");
        this.m_helper.resLabel(this.m_lblTable, this.m_tables, UIArb.getString(605), "m_tables");
        this.m_helper.resLabel(this.m_lblColumns, this.m_scrCols, UIArb.getString(606), "m_scrCols");
        this.m_helper.resButton(this.m_radCopy, UIArb.getString(607), "m_radCopy");
        this.m_helper.resButton(this.m_radMove, UIArb.getString(608), "m_radMove");
        this.add((Component)this.m_lblSchema, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_lblTable, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_lblColumns, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_schemas, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tables, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_scrCols, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.m_schemas.setProvider(pro);
        this.m_schemas.setDBObject((DBObject)this.m_table.getSchema());
        this.m_tables.setDBObject((DBObject)this.m_table);
        this.updateColumns();
        this.m_schemas.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                CopyColumnPanel.this.updateColumns();
            }
        });
        this.m_tables.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                CopyColumnPanel.this.updateColumns();
            }
        });
        this.m_radCopy.setSelected(true);
        this.setPreferredSize(new Dimension(400, 200));
        HelpUtils.setHelpID((JComponent)this, (String)"f1_odbtacopycolumns_html");
    }

    private void updateColumns() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.m_radMove.setEnabled(true);
        if (this.m_tables.getDBObject() != null) {
            this.m_sourceTable = (Relation)this.m_tables.getDBObject();
            if (this.m_sourceTable == null || this.m_sourceTable.getSchema().getName().equals(this.m_table.getSchema().getName()) && this.m_sourceTable.getName().equals(this.m_table.getName())) {
                this.m_sourceTable = this.m_table;
                this.m_radCopy.setSelected(true);
                this.m_radMove.setEnabled(false);
            }
            for (Column col : this.m_sourceTable.getColumns()) {
                model.addElement(col.getName() + " " + DataTypeHelper.getDDL((DataTypeUsage)col.getDataTypeUsage()));
            }
        }
        this.m_columns.setModel(model);
    }

    public List<Column> getSelectedColumns() {
        ArrayList<Column> retval = new ArrayList<Column>();
        if (this.m_tables.getDBObject() != null) {
            Column[] tabCols = this.m_sourceTable.getColumns();
            for (int idx : this.m_columns.getSelectedIndices()) {
                Column copy = (Column)tabCols[idx].copyTo(null);
                if (this.m_radMove.isSelected()) {
                    copy.setProperty("ColumnMoveExpander.SOURCE_COLUMN_ID", (Object)tabCols[idx].getID());
                }
                retval.add(copy);
            }
        }
        return retval;
    }
}

