/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers.table;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.table.AbstractTableVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleStorageProperties;

public class EditStorageInfoVerifier
extends AbstractTableVerifier
implements StorageInfoVerifier {
    @Override
    public boolean canChangeTablespace() {
        return this.isOffline() || !this.isPartitioned() && !(this.getModifiedObject() instanceof MaterializedView);
    }

    @Override
    public boolean canEditTablespace() {
        return this.isOffline();
    }

    @Override
    public boolean canChangePercentFree() {
        return this.isOffline() || !this.isIOT() || !this.isPartitioned();
    }

    @Override
    public boolean canChangePercentUsed() {
        return true;
    }

    @Override
    public boolean canChangeInitrans() {
        return true;
    }

    @Override
    public boolean canChangeMaxtrans() {
        return true;
    }

    @Override
    public boolean canChangeInitialExtent() {
        return this.isOffline() || !this.isPartitioned();
    }

    @Override
    public boolean canChangeNextExtent() {
        return this.isOffline() || !this.isPartitioned();
    }

    @Override
    public boolean canChangeMinExtent() {
        return this.isOffline() || !this.isPartitioned();
    }

    @Override
    public boolean canChangeMaxExtent() {
        return this.isOffline() || !this.isPartitioned();
    }

    @Override
    public boolean canChangePercentIncrease() {
        return this.isOffline() || !this.isPartitioned();
    }

    @Override
    public boolean canChangeLogging() {
        return true;
    }

    @Override
    public boolean canChangeFreelists() {
        return this.isOffline();
    }

    @Override
    public boolean canChangeFreelistGroups() {
        return this.isOffline();
    }

    @Override
    public boolean canChangeBufferMode() {
        return true;
    }

    @Override
    public void verifyStorage(OracleStorageProperties oProps) throws TraversalException {
        if (oProps != null) {
            int i;
            int iUsed;
            int iFree;
            Integer pctFree = oProps.getPercentFree();
            int n = iFree = pctFree != null ? pctFree : 0;
            if (iFree < 0 || iFree > 99) {
                throw new TraversalException(UIArb.getString(728), UIArb.getString(733), null);
            }
            Integer pctUsed = oProps.getPercentUsed();
            int n2 = iUsed = pctUsed != null ? pctUsed : 0;
            if (iUsed < 0 || iUsed > 99) {
                throw new TraversalException(UIArb.getString(729), UIArb.getString(733), null);
            }
            if (iFree + iUsed > 100) {
                throw new TraversalException(UIArb.getString(730), UIArb.getString(733), null);
            }
            Integer iniTrans = oProps.getInitrans();
            int n3 = i = iniTrans != null ? iniTrans : 1;
            if (i < 1 || i > 255) {
                throw new TraversalException(UIArb.getString(731), UIArb.getString(733), null);
            }
            Integer maxTrans = oProps.getMaxtrans();
            int n4 = i = maxTrans != null ? maxTrans : 1;
            if (i < 1 || i > 255) {
                throw new TraversalException(UIArb.getString(732), UIArb.getString(733), null);
            }
        }
    }

    protected boolean isOffline() {
        return !(this.getProvider() instanceof Database);
    }

    private boolean isPartitioned() {
        SchemaObject so = this.getOriginalObject() != null ? this.getOriginalObject() : this.getModifiedObject();
        return so instanceof Relation && Boolean.TRUE.equals(so.getProperty("PARTITIONED TABLE"));
    }

    private boolean isIOT() {
        SchemaObject so = this.getOriginalObject() != null ? this.getOriginalObject() : this.getModifiedObject();
        return so instanceof Relation && so.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED;
    }
}

