/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers.table;

import oracle.ideimpl.db.ora.verifiers.table.EditStorageInfoVerifier;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;

public class EditIndexStorageInfoVerifier
extends EditStorageInfoVerifier {
    private boolean isNewIndex() {
        SchemaObject original = this.getOriginalObject();
        Relation originalRel = this.getOriginalRelation();
        DBObjectProvider prov = this.getProvider();
        try {
            DBObject existing;
            Relation rel = (Relation)prov.getObject(originalRel.getType(), originalRel.getSchema(), originalRel.getName());
            if (rel != null && (existing = rel.findOwnedObject("INDEX", original.getName())) != null) {
                return false;
            }
        }
        catch (DBException dbe) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean canChangeInitialExtent() {
        return this.isOffline() || this.isNewIndex();
    }

    @Override
    public boolean canChangeNextExtent() {
        return this.isOffline() || this.isNewIndex();
    }

    @Override
    public boolean canChangeMinExtent() {
        return this.isOffline() || this.isNewIndex();
    }

    @Override
    public boolean canChangeMaxExtent() {
        return this.isOffline() || this.isNewIndex();
    }

    @Override
    public boolean canChangePercentIncrease() {
        return this.isOffline() || this.isNewIndex();
    }

    @Override
    protected Relation getOriginalRelation() {
        Table relation = null;
        Index index = (Index)this.getOriginalObject();
        if (index != null) {
            relation = index.getTable();
        }
        return relation;
    }

    @Override
    protected Relation getModifiedRelation() {
        Table relation = null;
        Index index = (Index)this.getModifiedObject();
        if (index != null) {
            relation = index.getTable();
        }
        return relation;
    }
}

