/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.view.AbstractViewInfoVerifier;
import oracle.ide.db.verifiers.view.ViewVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.javatools.util.ModelUtil;

public class CreateViewVerifier
extends AbstractViewInfoVerifier
implements ViewVerifier {
    private View _view;

    public CreateViewVerifier() {
    }

    public CreateViewVerifier(DBObjectProvider prov, View view) {
        this.initializeVerifier(prov, null, (SchemaObject)view);
    }

    @Override
    public void verifyView(boolean replace) throws TraversalException {
        try {
            Schema schema = this._view.getSchema();
            String name = this._view.getName();
            if (!replace && this.getProvider().getObject("VIEW", schema, name) != null) {
                throw new TraversalException(UIArb.format(761, name), UIArb.getString(759), null);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    @Override
    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject change) {
        super.initializeVerifier(prov, orig, change);
        this._view = (View)change;
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public void verifySchemaName(String name) throws TraversalException {
        if (!this.isValidName(name)) {
            throw new TraversalException(UIArb.format(563, name), UIArb.getString(762), null);
        }
    }

    @Override
    protected String getErrorTitle() {
        return UIArb.getString(762);
    }

    @Override
    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 760 : 763, name);
    }
}

