/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.javatools.util.ModelUtil;

public class CreateTriggerVerifier
extends AbstractSchemaObjectVerifier
implements TriggerVerifier,
SchemaObjectInfoVerifier {
    private DBObjectProvider m_prov;
    private Trigger m_trigger;
    private boolean m_canChangeSchema;

    @Override
    public void verifyTrigger(boolean replace) throws TraversalException {
        Schema owner = this.m_trigger.getSchema();
        if (owner == null) {
            throw new TraversalException(UIArb.getString(792), UIArb.getString(791), null);
        }
        switch (this.m_trigger.getBaseType()) {
            case TABLE: 
            case VIEW: {
                DBObjectID id = this.m_trigger.getTableID();
                String tableName = DBUtil.getDBObjectName((DBObjectID)id);
                if (!ModelUtil.hasLength((String)tableName)) {
                    throw new TraversalException(UIArb.getString(796), UIArb.getString(791), null);
                }
                String schemaName = DBUtil.getSchemaName((DBObjectID)id);
                if (ModelUtil.hasLength((String)schemaName)) break;
                throw new TraversalException(UIArb.getString(797), UIArb.getString(791), null);
            }
            case SCHEMA: {
                String schemaName = this.m_trigger.getBaseSchemaName();
                if (schemaName != null) break;
                throw new TraversalException(UIArb.getString(799), UIArb.getString(791), null);
            }
        }
        String[] events = this.m_trigger.getEvents();
        if (events.length == 0) {
            throw new TraversalException(UIArb.getString(798), UIArb.getString(791), null);
        }
    }

    @Override
    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject change) {
        super.initializeVerifier(prov, orig, change);
        this.m_prov = prov;
        this.m_trigger = (Trigger)change;
        Schema schema = this.m_trigger.getSchema();
        Schema otherSchema = null;
        try {
            for (Schema s : prov.listSchemas()) {
                if (!ModelUtil.areDifferent((Object)s, (Object)schema)) continue;
                otherSchema = s;
                break;
            }
        }
        catch (DBException ex) {
            // empty catch block
        }
        this.m_canChangeSchema = otherSchema != null ? prov.hasPriviledge("TRIGGER", otherSchema, "CREATE") : false;
    }

    @Override
    public void verifyName(String name) throws TraversalException {
        if (!this.m_prov.isValidName("TRIGGER", name)) {
            throw new TraversalException(UIArb.format(800, name), UIArb.getString(791), null);
        }
    }

    @Override
    public boolean canChangeName() {
        return true;
    }

    @Override
    public boolean canChangeSchema() {
        return this.m_canChangeSchema;
    }

    @Override
    public boolean canCreateSchema() {
        if (this.getProvider() instanceof Database) {
            return super.canCreateSchema();
        }
        return true;
    }

    @Override
    public void verifySchemaName(String name) throws TraversalException {
    }

    @Override
    public void verifyObject() throws TraversalException {
    }

    @Override
    public boolean canChangeBaseObject() {
        return !(this.getProvider() instanceof Database) || this.getOriginalObject() == null;
    }
}

