/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.controls.AbstractComboBasedChooser;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.property.Metadata;

public class SchemaObjectChooserDelegate
extends AbstractComboBasedChooser {
    @Override
    protected boolean accept(DBObjectChooser chooser, DBObjectProvider prov) {
        boolean childObjects = false;
        boolean schemaObjects = false;
        boolean nonSchemaSystemObjects = false;
        for (String type : chooser.getTypes()) {
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (ChildDBObject.class.isAssignableFrom(clz)) {
                childObjects = true;
                continue;
            }
            if (SchemaObject.class.isAssignableFrom(clz)) {
                schemaObjects = true;
                continue;
            }
            if (!SystemObject.class.isAssignableFrom(clz)) continue;
            nonSchemaSystemObjects = true;
        }
        return !childObjects && schemaObjects && !nonSchemaSystemObjects;
    }

    public SchemaObjectChooserDelegate() {
        this(false);
    }

    public SchemaObjectChooserDelegate(boolean editable) {
        super(editable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    List<DBObjectID> getEntries(boolean loadsubset) {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
        DBObjectFilter filter = this.getChooser().getFilter();
        try {
            if (loadsubset && this.subsetAvailable()) {
                DBObjectID id = this.getContextDBObjectID();
                DBObject obj = id.resolveID();
                if (obj instanceof Schema) {
                    Schema schema = (Schema)obj;
                    TreeSet<ComplexType> sortedSet = new TreeSet<ComplexType>(DBUtil.getNameComparator());
                    for (ComplexType dt : DataTypeRegistry.getInstance().listComplexTypes("SYS", this.getProvider().getClass())) {
                        sortedSet.add(dt);
                    }
                    for (DataType dataType : sortedSet) {
                        retval.add(dataType.getID());
                    }
                }
            } else {
                BaseObjectID bid;
                DBObjectCriteria crit = DBObjectCriteria.createCriteria();
                crit.setTypes(this.getTypes());
                DBObjectID cid = this.getContextDBObjectID();
                String schemaName = null;
                if (cid instanceof TemporaryObjectID) {
                    DBObject co = cid.resolveID();
                    if (co instanceof Schema) {
                        schemaName = co.getName();
                    }
                } else if (cid instanceof BaseObjectID && "SCHEMA".equals((bid = (BaseObjectID)cid).getType())) {
                    schemaName = DBUtil.getDBObjectName((DBObjectID)bid);
                }
                crit.setSchemaName(schemaName);
                for (SystemObject sysOb : this.getProvider().listObjects(crit)) {
                    void var9_17;
                    if (filter != null && !filter.accept((DBObject)sysOb)) continue;
                    DBObjectID dBObjectID = sysOb.getID();
                    if (dBObjectID == null) {
                        DBObjectID dBObjectID2 = TemporaryObjectID.createID((DBObject)sysOb);
                    }
                    retval.add((DBObjectID)var9_17);
                }
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        return retval;
    }

    @Override
    protected boolean subsetAvailable() {
        String schemaName = this.getStringFromID(this.getContextDBObjectID());
        return "SYS".equals(schemaName) && this.getTypes().length == 1 && this.getTypes()[0].equals("TYPE") && this.getProvider() instanceof Database;
    }
}

