/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.DBSizeChooser;

public final class DBUILayoutHelper {
    private DBUILayoutHelper m_parent;
    private List<DBUILayoutHelper> m_children = new ArrayList<DBUILayoutHelper>();
    private JPanel m_panel;
    private Map<Component, GridBagConstraints> m_componentMap = new HashMap<Component, GridBagConstraints>();
    private List<List<Component>> m_grid = new ArrayList<List<Component>>();
    private List<Component> m_lastRow;
    private List<Component> m_extras = new ArrayList<Component>();
    private final int CELL_SPACING = 2;
    private int m_x = 0;
    private int m_y = -2;
    private int m_maxx = 0;
    private int m_verticalGap = 0;
    private int m_marginTop = 6;
    private int m_marginLeft = 0;
    private int m_marginBottom = 6;
    private int m_marginRight = 0;
    private static List<Class<? extends Component>> s_fillHorizontalClz = new ArrayList<Class<? extends Component>>();
    private static List<Class<? extends Component>> s_fillVerticalClz;
    private static List<Class<? extends Component>> s_allKnownClz;

    private DBUILayoutHelper(JPanel panel, DBUILayoutHelper parent) {
        this.m_panel = panel;
        this.m_parent = parent;
        if (parent != null) {
            parent.m_children.add(this);
        }
    }

    public DBUILayoutHelper(JPanel panel) {
        this(panel, null);
    }

    public DBUILayoutHelper newChildHelper(int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        JPanel panel = new JPanel();
        DBUILayoutHelper child = this.newChildHelperImpl(panel, panel, cellWidth, cellHeight, fillHorizontal, fillVertical);
        child.setMargins(0);
        return child;
    }

    public DBUILayoutHelper newTitledBorderHelper(String title, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(title));
        return this.newChildHelperImpl(panel, panel, cellWidth, cellHeight, fillHorizontal, fillVertical);
    }

    public DBUILayoutHelper newCheckboxBorderHelper(JCheckBox cbx, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        JComboCardPanel cardPanel = new JComboCardPanel(new JLabel(), (JComponent)cbx);
        JPanel panel = new JPanel();
        cardPanel.showSubPanel((JComponent)panel);
        return this.newChildHelperImpl((JPanel)cardPanel, panel, cellWidth, cellHeight, fillHorizontal, fillVertical);
    }

    private DBUILayoutHelper newChildHelperImpl(JPanel panelToAdd, JPanel panelForChild, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        this.add(panelToAdd, cellWidth, cellHeight, fillHorizontal, fillVertical);
        DBUILayoutHelper child = new DBUILayoutHelper(panelForChild, this);
        child.setMarginTop(6);
        child.setMarginLeft(10);
        child.setMarginRight(6);
        child.setMarginBottom(10);
        return child;
    }

    public void add(Component comp) {
        this.add(comp, 1, 1);
    }

    public void add(Component comp, int cellWidth, int cellHeight) {
        boolean fillHorizontal = false;
        boolean fillVertical = false;
        if (comp != null) {
            boolean known = false;
            for (Class<? extends Component> clz : s_allKnownClz) {
                if (!clz.isAssignableFrom(comp.getClass())) continue;
                known = true;
                break;
            }
            if (!known) {
                throw new IllegalArgumentException("Don't know how to fill componenet of class " + comp.getClass().getCanonicalName());
            }
            for (Class<? extends Component> clz : s_fillHorizontalClz) {
                if (!clz.isAssignableFrom(comp.getClass())) continue;
                fillHorizontal = true;
                break;
            }
            for (Class<? extends Component> clz : s_fillVerticalClz) {
                if (!clz.isAssignableFrom(comp.getClass())) continue;
                fillVertical = true;
                break;
            }
        }
        this.add(comp, cellWidth, cellHeight, fillHorizontal, fillVertical);
    }

    public void add(Component comp, int cellWidth, int cellHeight, boolean fillHorizontal, boolean fillVertical) {
        if (comp == null) {
            throw new IllegalArgumentException("Component is null");
        }
        if (this.m_y < 0) {
            this.nextRowImpl(this.m_marginTop);
        }
        int fill = 0;
        if (fillHorizontal && fillVertical) {
            fill = 1;
        } else if (fillHorizontal) {
            fill = 2;
        } else if (fillVertical) {
            fill = 3;
        }
        int top = this.m_verticalGap;
        int left = 16;
        if (this.m_y == 0) {
            top = this.m_marginTop;
        }
        if (this.m_x == 0) {
            left = this.m_marginLeft;
        } else if (this.m_lastRow != null && this.m_lastRow.size() > 0) {
            Component prevComp = this.m_lastRow.get(this.m_lastRow.size() - 1);
            if (prevComp instanceof JLabel) {
                if (((JLabel)prevComp).getLabelFor() == comp) {
                    left = 8;
                }
            } else if (prevComp instanceof JRadioButton && comp instanceof JRadioButton) {
                left = 16;
            } else if (prevComp instanceof JCheckBox && comp instanceof JCheckBox) {
                left = 16;
            } else if (prevComp instanceof AbstractButton && comp instanceof AbstractButton) {
                left = 8;
            }
        }
        GridBagConstraints constr = new GridBagConstraints(this.m_x, this.m_y, 1 + (cellWidth - 1) * 2, 1 + (cellHeight - 1) * 2, fillHorizontal ? 1.0 : 0.0, fillVertical ? 1.0 : 0.0, 17, fill, new Insets(top, left, 0, 0), 0, 0);
        this.m_componentMap.put(comp, constr);
        this.m_lastRow.add(comp);
        this.m_x += cellWidth * 2;
        if (this.m_x > this.m_maxx) {
            this.m_maxx = this.m_x;
        }
    }

    public void nextRow() {
        this.nextRowImpl(6);
    }

    public void nextRowWithGap() {
        this.nextRowImpl(16);
    }

    private void nextRowImpl(int gap) {
        if (this.m_lastRow != null && this.m_lastRow.size() > 0) {
            GridBagConstraints constr = this.getConstraints(this.m_lastRow.get(this.m_lastRow.size() - 1));
            constr.insets.right = this.m_marginRight == 0 ? 1 : this.m_marginRight;
        }
        this.m_x = 0;
        this.m_y += 2;
        this.m_lastRow = new ArrayList<Component>();
        this.m_grid.add(this.m_lastRow);
        this.m_verticalGap = gap;
    }

    public void nextColumn() {
        this.m_x += 2;
        if (this.m_x > this.m_maxx) {
            this.m_maxx = this.m_x;
        }
    }

    public void pushUp() {
        this.nextRowImpl(0);
        this.add(Box.createVerticalGlue(), 1, 1, false, true);
    }

    public void pushLeft() {
        this.m_x = this.m_maxx;
        this.add(Box.createHorizontalGlue(), 1, 1, true, false);
    }

    public void indent(Component comp) {
        GridBagConstraints constr = this.getConstraints(comp);
        constr.insets.left += 16;
    }

    public GridBagConstraints getConstraints(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Component is null");
        }
        GridBagConstraints constr = this.m_componentMap.get(comp);
        if (constr == null) {
            throw new IllegalStateException("Component has not been added");
        }
        return constr;
    }

    public void setMinWidth(Component comp, int width) {
        GridBagConstraints compConstr = this.getConstraints(comp);
        if (compConstr != null) {
            Component filler = Box.createHorizontalStrut(width);
            GridBagConstraints fillerConstr = (GridBagConstraints)compConstr.clone();
            ++fillerConstr.gridy;
            fillerConstr.insets.top = 0;
            fillerConstr.insets.bottom = 0;
            this.m_componentMap.put(filler, fillerConstr);
            this.m_extras.add(filler);
        }
    }

    public void setMinHeight(Component comp, int height) {
        GridBagConstraints compConstr = this.getConstraints(comp);
        if (compConstr != null) {
            Component filler = Box.createVerticalStrut(height);
            GridBagConstraints fillerConstr = (GridBagConstraints)compConstr.clone();
            ++fillerConstr.gridx;
            fillerConstr.insets.left = 0;
            fillerConstr.insets.right = 0;
            this.m_componentMap.put(filler, fillerConstr);
            this.m_extras.add(filler);
        }
    }

    public void layout() {
        if (this.m_parent != null) {
            return;
        }
        for (DBUILayoutHelper dBUILayoutHelper : this.m_children) {
            dBUILayoutHelper.m_parent = null;
            dBUILayoutHelper.layout();
        }
        this.m_children.clear();
        if (this.m_panel != null && this.m_grid != null) {
            this.m_panel.setLayout(new GridBagLayout());
            if (this.m_lastRow != null && this.m_lastRow.size() > 0) {
                for (int i = 0; i < this.m_lastRow.size(); ++i) {
                    GridBagConstraints gridBagConstraints = this.getConstraints(this.m_lastRow.get(i));
                    if (gridBagConstraints == null) continue;
                    gridBagConstraints.insets.bottom = this.m_marginBottom;
                    if (i != this.m_lastRow.size() - 1) continue;
                    gridBagConstraints.insets.right = this.m_marginRight == 0 ? 1 : this.m_marginRight;
                }
            }
            for (List list : this.m_grid) {
                for (Component comp : list) {
                    this.m_panel.add(comp, this.getConstraints(comp));
                    this.showDebug(comp);
                }
            }
            for (Component component : this.m_extras) {
                this.m_panel.add(component, this.getConstraints(component));
                this.showDebug(component);
            }
            this.showDebug(this.m_panel);
        }
        this.m_componentMap.clear();
        this.m_extras.clear();
        this.m_grid.clear();
        this.m_lastRow.clear();
        this.m_panel = null;
    }

    private void showDebug(Component c) {
        boolean tooltip = false;
        boolean border = false;
        if (tooltip && c instanceof JComponent) {
            final JComponent comp = (JComponent)c;
            if (tooltip) {
                if (c != this.m_panel) {
                    GridBagConstraints constr = this.getConstraints(comp);
                    StringBuffer sb = new StringBuffer("Debug");
                    sb.append(": gridx=").append(constr.gridx);
                    sb.append(": gridy=").append(constr.gridy);
                    sb.append(": gridwidth=").append(constr.gridwidth);
                    sb.append(": gridheight=").append(constr.gridheight);
                    sb.append(": fill=").append(constr.fill);
                    sb.append(": insets.top=").append(constr.insets.top);
                    sb.append(": insets.left=").append(constr.insets.left);
                    sb.append(": insets.bottom=").append(constr.insets.bottom);
                    sb.append(": insets.right=").append(constr.insets.right);
                    comp.setToolTipText(sb.toString());
                } else {
                    comp.setToolTipText("the panel");
                }
            }
            if (border) {
                comp.addMouseListener(new MouseListener(){
                    Border m_border = null;

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        this.m_border = comp.getBorder();
                        comp.setBorder(new LineBorder(Color.RED));
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        comp.setBorder(this.m_border);
                    }
                });
            }
        }
    }

    public void setMarginTop(int marginTop) {
        this.m_marginTop = marginTop;
    }

    public int getMarginTop() {
        return this.m_marginTop;
    }

    public void setMarginLeft(int marginLeft) {
        this.m_marginLeft = marginLeft;
    }

    public int getMarginLeft() {
        return this.m_marginLeft;
    }

    public void setMarginBottom(int marginBottom) {
        this.m_marginBottom = marginBottom;
    }

    public int getMarginBottom() {
        return this.m_marginBottom;
    }

    public void setMarginRight(int marginRight) {
        this.m_marginRight = marginRight;
    }

    public int getMarginRight() {
        return this.m_marginRight;
    }

    public void setMargins(int margin) {
        this.m_marginTop = margin;
        this.m_marginLeft = margin;
        this.m_marginBottom = margin;
        this.m_marginRight = margin;
    }

    static {
        s_fillHorizontalClz.add(JList.class);
        s_fillHorizontalClz.add(JTextField.class);
        s_fillHorizontalClz.add(JTextArea.class);
        s_fillHorizontalClz.add(JComboBox.class);
        s_fillHorizontalClz.add(DBObjectChooser.class);
        s_fillHorizontalClz.add(DBSizeChooser.class);
        s_fillHorizontalClz.add(JScrollPane.class);
        s_fillVerticalClz = new ArrayList<Class<? extends Component>>();
        s_fillVerticalClz.add(JList.class);
        s_fillVerticalClz.add(JTextArea.class);
        s_fillVerticalClz.add(JScrollPane.class);
        s_allKnownClz = new ArrayList<Class<? extends Component>>();
        s_allKnownClz.add(JLabel.class);
        s_allKnownClz.add(JPanel.class);
        s_allKnownClz.add(AbstractButton.class);
        s_allKnownClz.addAll(s_fillHorizontalClz);
    }
}

