/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class DBUIHelper {
    private static final String LIVE_VALIDATE_SYSPROP = "ide.db.liveValidate";
    private final DBUIResourceHelper m_resHelp;
    private String m_basePath;
    private AbstractDBObjectProvider m_pro;
    private Component m_parent;
    private List<Component> m_components;
    private DBValidationHandler m_validationHandler;
    private List<String> m_paths;
    private boolean m_done;
    private final boolean m_skipValidation;
    private boolean m_editable = true;
    private boolean m_allowRecreate = true;

    public DBUIHelper(String panelName, Component parent) {
        this(panelName, parent, false);
    }

    public DBUIHelper(String panelName, Component parent, boolean skipValidation) {
        this.m_resHelp = new DBUIResourceHelper(panelName);
        this.m_parent = parent;
        this.m_skipValidation = !DBUIHelper.isLiveValidateEnabled();
    }

    public static final boolean isLiveValidateEnabled() {
        return ModelUtil.areEqual((Object)System.getProperty(LIVE_VALIDATE_SYSPROP), (Object)"true");
    }

    public void setBasePath(String basePath) {
        this.m_basePath = Property.createPath((String[])new String[]{basePath});
    }

    private String getCompletePath(String path) {
        String retval = path;
        if (this.m_basePath != null) {
            retval = Property.createPath((String[])new String[]{this.m_basePath, retval});
        }
        return retval;
    }

    public Collection<String> getPaths() {
        HashSet<String> retval = new HashSet<String>();
        if (this.m_paths != null) {
            retval.addAll(this.m_paths);
        }
        return retval;
    }

    public void setProvider(DBObjectProvider pro) {
        this.m_pro = (AbstractDBObjectProvider)pro;
    }

    public void setAllowRecreate(boolean allow) {
        this.m_allowRecreate = allow;
    }

    public void setSuspendValidation(boolean suspend) {
        if (this.m_validationHandler != null) {
            this.m_validationHandler.setSuspendValidation(suspend);
        }
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public void setEditable(boolean edit) {
        this.m_editable = edit;
    }

    public DBValidationHandler getValidationHandler() {
        if (this.m_validationHandler == null) {
            this.m_validationHandler = new DBValidationHandler();
            if (!this.m_skipValidation) {
                for (int i = 0; i < this.m_components.size(); ++i) {
                    Component comp = this.m_components.get(i);
                    String path = this.m_paths.get(i);
                    this.m_validationHandler.registerComponent(comp, path);
                }
            }
        }
        return this.m_validationHandler;
    }

    public synchronized void processComponents(DBObject orig, DBObject update) {
        if (this.m_pro == null) {
            new IllegalStateException("no DBObjectProvider has been set!").printStackTrace();
        }
        if (this.m_done) {
            return;
        }
        if (this.m_pro != null && update != null && this.m_components != null) {
            this.m_done = true;
            PropertyManager pm = this.m_pro.getPropertyManager();
            if (pm != null) {
                for (int i = 0; i < this.m_components.size(); ++i) {
                    Component comp = this.m_components.get(i);
                    String path = this.getCompletePath(this.m_paths.get(i));
                    this.processComponentImpl(pm, comp, orig, update, path);
                }
            }
        }
    }

    public void processComponent(Component comp, DBObject orig, DBObject update) {
        int i = this.m_components.indexOf(comp);
        if (i < 0) {
            throw new IllegalStateException("Cannot process Component " + comp.getName() + ": it is not registered");
        }
        PropertyManager pm = this.m_pro.getPropertyManager();
        String path = this.getCompletePath(this.m_paths.get(i));
        this.processComponentImpl(pm, comp, orig, update, path);
    }

    private void processComponentImpl(PropertyManager pm, Component comp, DBObject orig, DBObject update, String propertyPath) {
        String type = update.getType();
        if (pm.supportsProperty(type, propertyPath)) {
            boolean disable;
            boolean bl = disable = !this.m_editable;
            if (!disable) {
                PropertyAction.Type actionType;
                PropertyAction action = pm.canChangeProperty(orig, update, propertyPath);
                PropertyAction.Type type2 = actionType = action == null ? null : action.getType();
                if (orig == null) {
                    if (actionType != PropertyAction.Type.CREATE) {
                        disable = true;
                    }
                } else if (actionType != PropertyAction.Type.ALTER) {
                    if (actionType == PropertyAction.Type.REPLACE) {
                        DBLog.getLogger((Object)this).log(Level.FINE, "will need replace for: " + propertyPath);
                        disable = !this.m_allowRecreate;
                    } else {
                        disable = true;
                    }
                }
            }
            comp.setEnabled(!disable);
            comp.setVisible(true);
        } else {
            comp.setVisible(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void canCommit(DBObject orig, DBObject update, Namespace tc) throws TraversalException {
        PropertyAction.Type actionType;
        PropertyManager pm = this.m_pro.getPropertyManager();
        PropertyAction action = pm.canUpdateObject(orig, update);
        PropertyAction.Type type = actionType = action == null ? null : action.getType();
        if (actionType == PropertyAction.Type.CREATE || actionType == PropertyAction.Type.REPLACE) {
            if (orig == null || tc.find("allowReplaceForUpdate") == Boolean.TRUE) return;
            StringBuilder props = new StringBuilder();
            for (String s : action.getProperties()) {
                props.append(PropertyDisplayRegistry.getDisplayName(s)).append("\n");
            }
            String propText = props.toString();
            if (!MessageDialog.confirm((Component)this.m_parent, (Object)UIArb.format(114, propText), (String)UIArb.getString(113), null, (boolean)true)) throw new TraversalException(null);
            tc.put("allowReplaceForUpdate", (Object)Boolean.TRUE);
            return;
        } else {
            if (actionType != PropertyAction.Type.ALTER) return;
            tc.remove("allowReplaceForUpdate");
        }
    }

    public boolean hasComponents() {
        return this.m_components == null || !this.m_components.isEmpty();
    }

    public synchronized void registerComponent(Component comp, String propPath) {
        if (this.m_components == null) {
            this.m_components = new ArrayList<Component>();
            this.m_paths = new ArrayList<String>();
        }
        this.m_components.add(comp);
        this.m_paths.add(propPath);
        if (this.m_validationHandler != null) {
            this.m_validationHandler.registerComponent(comp, propPath);
        }
    }

    public void registerComponent(Component comp, String componentName, String path) {
        if (ModelUtil.hasLength((String)path)) {
            this.registerComponent(comp, path);
        }
        this.m_resHelp.setName(comp, componentName);
    }

    public void registerComponent(AbstractButton button, String buttonText, String propPath) {
        this.registerComponent(button, buttonText, propPath, propPath);
    }

    public void registerComponent(AbstractButton button, String buttonText, String componentName, String propPath) {
        if (ModelUtil.hasLength((String)propPath)) {
            this.registerComponent(button, propPath);
        }
        this.m_resHelp.resButton(button, buttonText, componentName);
    }

    public void registerComponent(JLabel label, Component component, String labelText, String propPath) {
        this.registerComponent(label, component, labelText, propPath, propPath);
    }

    public void registerComponent(JLabel label, Component component, String labelText, String componentName, String propPath) {
        if (ModelUtil.hasLength((String)propPath)) {
            this.registerComponent(component, propPath);
            this.registerComponent(label, propPath);
        }
        this.m_resHelp.resLabel(label, component, labelText, componentName);
    }
}

