/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.DBObjectActions;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;

class DBObjectActionsController
implements Controller {
    DBObjectActionsController() {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        DBObjectNode node;
        boolean retval = false;
        int cmdID = action.getCommandId();
        if (cmdID == DBObjectActions.getDuplicateAction().getCommandId()) {
            retval = true;
            DBObjectNode node2 = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
            if (node2 != null) {
                DBObject obj = node2.getDBObject();
                DBObjectProvider pro = node2.getProvider();
                SystemObject sysObj = DBUtil.getSystemObject((DBObject)obj);
                if (sysObj != null) {
                    try {
                        obj = DBUtil.getProviderDefinition((DBObject)obj, (DBObjectProvider)pro);
                    }
                    catch (DBException e) {
                        DBLog.getLogger((Object)this).log(Level.WARNING, "Error checking object is latest version: " + e.getMessage());
                    }
                    DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory((DBObject)sysObj, pro);
                    if (fac != null) {
                        if (sysObj == obj) {
                            fac.createDBObject(DBUtil.getSchema((DBObject)sysObj), pro, sysObj, true);
                        } else {
                            fac.createDBObject(pro, obj, (DBObject)sysObj, true);
                        }
                    }
                }
            }
        } else if (cmdID == DBObjectActions.getPropertiesAction().getCommandId() && (node = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class)) != null) {
            retval = true;
            DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory(node);
            if (fac != null) {
                fac.editDBObject(node);
            }
        }
        return retval;
    }

    public boolean update(IdeAction action, Context context) {
        DBObjectNode node;
        boolean retval = false;
        boolean enabled = false;
        int cmdID = action.getCommandId();
        if (cmdID == DBObjectActions.getDuplicateAction().getCommandId()) {
            retval = true;
            DBObjectNode node2 = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
            if (node2 != null) {
                enabled = DBEditorFactoryRegistry.getEditFactory(node2) != null;
            }
        } else if (cmdID == DBObjectActions.getPropertiesAction().getCommandId() && (node = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class)) != null) {
            retval = true;
            boolean bl = enabled = DBEditorFactoryRegistry.getEditFactory(node) != null;
        }
        if (retval) {
            action.setEnabled(enabled);
        }
        return retval;
    }
}

