/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.table;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.table.AbstractTableVerifier;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.util.ModelUtil;

public class AbstractIndexInfoVerifier
extends AbstractTableVerifier
implements IndexInfoVerifier {
    @Override
    protected String getErrorTitle() {
        return UIArb.format(391, this.getModifiedRelationName());
    }

    @Override
    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 392 : 393, name);
    }

    @Override
    protected String getChildType() {
        return "INDEX";
    }

    @Override
    public void verifyIndex(Index oldIndex, Index newIndex) throws TraversalException {
        try {
            this.getProvider().validateObject((DBObject)oldIndex, (DBObject)newIndex);
        }
        catch (ValidationException ve) {
            this.processValidationException(ve);
        }
    }

    @Override
    public boolean canRenameIndex(Index index) {
        return this.getOriginalIndex(index) == null;
    }

    @Override
    public boolean canRemoveIndexes() {
        return this.isEditable();
    }

    @Override
    public boolean canRemoveIndex(Index index) {
        return this.isEditable();
    }

    @Override
    public boolean canReorderIndexes() {
        return this.getOriginalRelation() == null;
    }

    @Override
    public boolean canMoveIndexUp(Index index) {
        return this.getOriginalRelation() == null;
    }

    @Override
    public boolean canMoveIndexDown(Index index) {
        return this.getOriginalRelation() == null;
    }

    @Override
    public boolean canAddIndexes() {
        return this.getOriginalRelation() == null;
    }

    @Override
    public boolean canAddIndex(Index index) {
        return this.getOriginalIndex(index) == null;
    }

    @Override
    public boolean canEditIndex(Index index) {
        return true;
    }

    @Override
    public boolean canAddIndexEntry(Index index) {
        int maxExpressions = 32;
        if (index.getIndexType() == Index.IndexType.BITMAP) {
            maxExpressions = 30;
        }
        return index.getColumnExpressions().length < maxExpressions;
    }

    protected Index getOriginalIndex(Index index) {
        Index result = null;
        Table original = (Table)this.getOriginalRelation();
        if (index != null && original != null) {
            result = original.getIndex(index.getName());
        }
        return result;
    }

    protected boolean hasNewIndex() {
        boolean result = true;
        if (this.getOriginalRelation() != null) {
            result = false;
            Index[] changeIndexes = ((Table)this.getModifiedRelation()).getIndexes();
            for (int i = 0; i < changeIndexes.length; ++i) {
                if (null != this.getOriginalIndex(changeIndexes[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected String getModifiedRelationName() {
        String result = "";
        SchemaObject dbo = this.getModifiedObject();
        if (dbo instanceof Index) {
            dbo = ((Index)dbo).getTable();
        }
        if (null != dbo) {
            result = dbo.getName();
        }
        return result;
    }

    @Override
    public boolean canChangeName() {
        return true;
    }

    @Override
    public boolean canChangeSchema() {
        return this.isEditable();
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public boolean canChangeComment() {
        return false;
    }

    @Override
    public boolean canEditUniqueness(Index index) {
        return this.isEditable();
    }

    @Override
    public boolean canEditDomain(Index index) {
        Table table = index != null ? index.getTable() : null;
        Table.TableType type = table != null ? (Table.TableType)table.getProperty("TableType") : null;
        return this.isEditable() && (type == null || type != Table.TableType.SESSION_TEMP && type != Table.TableType.TRANSACTION_TEMP);
    }

    @Override
    public boolean canEditParallel(Index index) {
        return true;
    }

    @Override
    public boolean canEditCompress(Index index) {
        return index.getIndexType() != Index.IndexType.BITMAP;
    }

    @Override
    public void verifySchemaName(String name) throws TraversalException {
        if (!this.isValidName(name)) {
            throw new TraversalException(UIArb.format(408, name), UIArb.getString(406), null);
        }
    }

    @Override
    public void verifyObject() throws TraversalException {
    }

    protected boolean isNewIndex(Index index) {
        boolean retval = true;
        DBObjectID id = index.getID();
        if (id instanceof TemporaryObjectID) {
            try {
                retval = TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)id)) != null;
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return retval;
    }
}

