/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.index;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.util.ModelUtil;

public class AbstractTopLevelIndexVerifier
extends AbstractSchemaObjectVerifier
implements IndexInfoVerifier {
    @Override
    public void verifyIndex(Index oldIndex, Index newIndex) throws TraversalException {
        try {
            this.getProvider().validateObject((DBObject)oldIndex, (DBObject)newIndex);
        }
        catch (ValidationException ve) {
            this.processValidationException(ve);
        }
    }

    @Override
    public boolean canRenameIndex(Index index) {
        return null == ((Index)this.getModifiedObject()).getTable();
    }

    @Override
    public boolean canRemoveIndexes() {
        return false;
    }

    @Override
    public boolean canRemoveIndex(Index index) {
        return false;
    }

    @Override
    public boolean canReorderIndexes() {
        return false;
    }

    @Override
    public boolean canMoveIndexUp(Index index) {
        return false;
    }

    @Override
    public boolean canMoveIndexDown(Index index) {
        return false;
    }

    @Override
    public boolean canAddIndexes() {
        return this.getOriginalTable() == null;
    }

    @Override
    public boolean canAddIndex(Index index) {
        return this.getOriginalTable() == null;
    }

    @Override
    public boolean canEditIndex(Index index) {
        return this.isEditable();
    }

    @Override
    public boolean canAddIndexEntry(Index index) {
        int maxExpressions = 32;
        if (index.getIndexType() == Index.IndexType.BITMAP) {
            maxExpressions = 30;
        }
        return this.isEditable() && index.getColumnExpressions().length < maxExpressions;
    }

    @Override
    public boolean canEditUniqueness(Index index) {
        return this.isEditable();
    }

    @Override
    public boolean canEditDomain(Index index) {
        return this.isEditable();
    }

    @Override
    public boolean canEditParallel(Index index) {
        Table table = index != null ? index.getTable() : null;
        return this.isEditable() && table != null && (table.getProperty("TableType") == Table.TableType.NORMAL || table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED);
    }

    @Override
    public boolean canEditCompress(Index index) {
        return this.canEditParallel(index) && index.getIndexType() != Index.IndexType.BITMAP;
    }

    @Override
    public boolean canChangeName() {
        return true;
    }

    @Override
    public boolean canChangeSchema() {
        return this.canEditIndex(null);
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public boolean canChangeComment() {
        return false;
    }

    @Override
    public void verifyRelation() {
    }

    @Override
    public void verifySchemaName(String name) throws TraversalException {
        if (!this.isValidName(name)) {
            throw new TraversalException(UIArb.format(408, name), UIArb.getString(406), null);
        }
    }

    @Override
    public void verifyObject() throws TraversalException {
    }

    @Override
    protected String getErrorTitle() {
        return UIArb.format(391, this.getModifiedRelationName());
    }

    @Override
    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 392 : 393, name);
    }

    protected String getChildType() {
        return "INDEX";
    }

    protected String getModifiedRelationName() {
        String result = "";
        SchemaObject dbo = this.getModifiedObject();
        if (null != dbo) {
            dbo = ((Index)dbo).getTable();
        }
        if (null != dbo) {
            result = dbo.getName();
        }
        return result;
    }

    protected Table getOriginalTable() {
        Table result = null;
        Index oi = (Index)this.getOriginalObject();
        if (null != oi) {
            result = oi.getTable();
        }
        return result;
    }

    protected Table getModifiedTable() {
        Index mi = (Index)this.getModifiedObject();
        return mi.getTable();
    }
}

