/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers;

import java.math.BigInteger;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.Sequence;
import oracle.javatools.util.ModelUtil;

public class SequenceInfoVerifier
extends AbstractSchemaObjectVerifier {
    public void verifySequence() throws TraversalException {
        this.verifySchemaObject();
    }

    @Override
    protected String getErrorTitle() {
        return UIArb.format(149, this.getModifiedObject().getName());
    }

    @Override
    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 151 : 150, name);
    }

    public boolean canChangeIncrement() {
        return this.isEditable();
    }

    public boolean canChangeMinValue() {
        return this.isEditable();
    }

    public boolean canChangeMaxValue() {
        return this.isEditable();
    }

    public boolean canChangeCycle() {
        return this.isEditable();
    }

    public boolean canChangeOrder() {
        return this.isEditable();
    }

    public boolean canChangeCache() {
        return this.isEditable();
    }

    public boolean canChangeCacheSize() {
        return this.isEditable();
    }

    public boolean canEditStartWith() {
        return this.getOriginalObject() == null;
    }

    public void verifyMinValue() throws TraversalException {
        Sequence orig = (Sequence)this.getOriginalObject();
        if (orig != null) {
            Sequence seq = (Sequence)this.getModifiedObject();
            BigInteger minValue = seq.getMinValue();
            BigInteger omin = orig.getMinValue();
            if (null == omin && null != minValue || null != omin && null != minValue && minValue.compareTo(omin) > 0) {
                throw new TraversalException(DBArb.format((int)109, (Object)minValue.toString(), (Object)(null == omin ? "NOMINVALUE" : omin.toString())), UIArb.format(149, seq.getName()));
            }
        }
    }

    public void verifyMaxValue() throws TraversalException {
        Sequence orig = (Sequence)this.getOriginalObject();
        if (orig != null) {
            Sequence seq = (Sequence)this.getModifiedObject();
            BigInteger maxValue = seq.getMaxValue();
            BigInteger omax = orig.getMaxValue();
            if (null == omax && null != maxValue || null != omax && null != maxValue && maxValue.compareTo(omax) < 0) {
                throw new TraversalException(DBArb.format((int)110, (Object)maxValue.toString(), (Object)(null == omax ? "NOMAXVALUE" : omax.toString())), DBArb.format((int)149, (Object)seq.getName()));
            }
        }
    }
}

