/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers;

import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;

public abstract class AbstractSchemaObjectVerifier
implements SchemaObjectInfoVerifier {
    private DBObjectProvider m_prov;
    private SchemaObject m_orig;
    private SchemaObject m_change;
    private boolean m_editable = true;

    protected AbstractSchemaObjectVerifier() {
    }

    protected String getObjectType() {
        return this.m_change == null ? (this.m_orig == null ? null : this.m_orig.getType()) : this.m_change.getType();
    }

    @Override
    public void verifyName(String name) throws TraversalException {
        try {
            this.m_prov.validateName(this.getObjectType(), name);
        }
        catch (InvalidNameException ine) {
            String reason = ine.getMessage();
            throw new TraversalException(this.getInvalidNameMessage(name) + " " + reason, this.getErrorTitle());
        }
    }

    protected void verifySchemaObject() throws TraversalException {
        try {
            if (this.m_orig == null) {
                this.m_prov.validateObject((DBObject)this.m_change);
            } else {
                this.m_prov.validateObject((DBObject)this.m_orig, (DBObject)this.m_change);
            }
        }
        catch (ValidationException ve) {
            this.processValidationException(ve);
        }
    }

    protected boolean isValidName(String name) {
        return this.m_prov.isValidName(this.getObjectType(), name);
    }

    protected String getInvalidNameMessage(String name) {
        return "";
    }

    protected String getErrorTitle() {
        return "";
    }

    protected void processValidationException(ValidationException ve) throws TraversalException {
        String title = ve.getTitle();
        throw new TraversalException(ve.getMessage(), title == null ? this.getErrorTitle() : title);
    }

    @Override
    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject change) {
        this.m_prov = prov;
        this.m_orig = orig;
        this.m_change = change;
    }

    @Override
    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public SchemaObject getOriginalObject() {
        return this.m_orig;
    }

    public SchemaObject getModifiedObject() {
        return this.m_change;
    }

    protected DBObjectProvider getProvider() {
        return this.m_prov;
    }

    protected boolean isEditable() {
        return this.m_editable;
    }

    @Override
    public boolean canChangeName() {
        return null == this.m_orig;
    }

    @Override
    public boolean canChangeSchema() {
        return null == this.m_orig;
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public void verifySchemaName(String name) throws TraversalException {
    }

    @Override
    public void verifyObject() throws TraversalException {
    }
}

