/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SynonymUsage;

public class TreeNodeMaker {
    private boolean m_showChildren;
    private String[] m_childTypes;
    private boolean m_fkDeep;

    public TreeNodeMaker() {
    }

    public TreeNodeMaker(boolean showChildren) {
        this.m_showChildren = showChildren;
    }

    public TreeNodeMaker(boolean showChildren, String[] childTypes) {
        this.m_showChildren = showChildren;
        this.m_childTypes = childTypes;
    }

    public void setShowChildren(boolean boo) {
        this.m_showChildren = boo;
    }

    public boolean getShowChildren() {
        return this.m_showChildren;
    }

    public void setChildTypes(String[] childTypes) {
        this.m_childTypes = childTypes;
    }

    public void setDeepFKs(boolean boo) {
        this.m_fkDeep = boo;
    }

    public DefaultMutableTreeNode createTreeNode(DBObject obj) {
        if (obj instanceof Relation && this.m_showChildren || obj instanceof FKConstraint && this.m_fkDeep) {
            return new LazyTreeNode(obj);
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
        return node;
    }

    private void createChildNodes(DBObject obj, DefaultMutableTreeNode node) {
        if (this.m_childTypes == null) {
            DBObject[] kids = obj.getOwnedObjects();
            for (int i = 0; i < kids.length; ++i) {
                DefaultMutableTreeNode newNode = this.createTreeNode(kids[i]);
                if (newNode == null) continue;
                node.add(newNode);
            }
        } else {
            DBObject[] kids = obj.getOwnedObjects(this.m_childTypes);
            for (int j = 0; j < kids.length; ++j) {
                DefaultMutableTreeNode newNode = this.createTreeNode(kids[j]);
                if (newNode == null) continue;
                node.add(newNode);
            }
        }
    }

    public DefaultMutableTreeNode createTreeNode(SQLFragment obj) {
        return this.createTreeNode(obj, false);
    }

    public DefaultMutableTreeNode createTreeNode(SQLFragment obj, boolean showAvailKids) {
        DefaultMutableTreeNode node;
        block10: {
            SQLFragment exp;
            block11: {
                SchemaObject refObj;
                node = new DefaultMutableTreeNode(obj);
                if (obj instanceof FromObject && this.m_showChildren && (exp = ((FromObject)obj).getExpression()) instanceof JoinObject) {
                    DefaultMutableTreeNode leftnode = this.createTreeNode((SQLFragment)((JoinObject)exp).getLeftExpression());
                    DefaultMutableTreeNode rightnode = this.createTreeNode((SQLFragment)((JoinObject)exp).getRightExpression());
                    node.add(leftnode);
                    node.add(rightnode);
                }
                if (!showAvailKids || !(obj instanceof FromObject) || (exp = ((FromObject)obj).getExpression()) == null) break block10;
                if (!(exp instanceof DBObjectUsage)) break block11;
                Relation rel = null;
                if (exp instanceof RelationUsage) {
                    DBObjectID id = ((RelationUsage)exp).getObjectID();
                    if (id != null) {
                        try {
                            rel = (Relation)id.resolveID();
                        }
                        catch (DBException dbe) {}
                    }
                } else if (exp instanceof SynonymUsage && (refObj = ((SynonymUsage)exp).getReferencedObject()) instanceof Relation) {
                    rel = (Relation)refObj;
                }
                if (rel == null) break block10;
                Column[] cols = rel.getColumns();
                for (int i = 0; cols != null && i < cols.length; ++i) {
                    node.add(this.createTreeNode((DBObject)cols[i]));
                }
                break block10;
            }
            if (exp instanceof SQLQuery) {
                SelectObject[] sels = ((SQLQuery)exp).getSelectObjects();
                for (int i = 0; i < sels.length; ++i) {
                    node.add(this.createTreeNode((SQLFragment)new SelectObjectUsage(sels[i], (FromObject)obj)));
                }
            }
        }
        return node;
    }

    private class LazyTreeNode
    extends DefaultMutableTreeNode {
        private boolean m_init;

        LazyTreeNode(DBObject obj) {
            super(obj);
        }

        private void init() {
            if (!this.m_init) {
                try {
                    this.m_init = true;
                    DBObject obj = (DBObject)this.getUserObject();
                    if (obj instanceof FKConstraint) {
                        DBObjectID id;
                        DBObject refobj;
                        if (TreeNodeMaker.this.m_fkDeep && (refobj = (id = ((FKConstraint)obj).getReferenceID()).resolveID()) != null && refobj instanceof Constraint) {
                            this.add(TreeNodeMaker.this.createTreeNode((DBObject)((Constraint)refobj).getRelation()));
                        }
                    } else if (TreeNodeMaker.this.m_showChildren) {
                        TreeNodeMaker.this.createChildNodes(obj, this);
                    }
                }
                catch (DBException dbe) {
                    dbe.printStackTrace();
                }
            }
        }

        public Enumeration children() {
            this.init();
            return super.children();
        }

        @Override
        public TreeNode getChildAfter(TreeNode aChild) {
            this.init();
            return super.getChildAfter(aChild);
        }

        @Override
        public TreeNode getChildAt(int index) {
            this.init();
            return super.getChildAt(index);
        }

        @Override
        public TreeNode getChildBefore(TreeNode aChild) {
            this.init();
            return super.getChildBefore(aChild);
        }

        @Override
        public int getChildCount() {
            this.init();
            return super.getChildCount();
        }

        @Override
        public TreeNode getLastChild() {
            this.init();
            return super.getLastChild();
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            this.init();
            super.insert(newChild, childIndex);
        }

        @Override
        public boolean isLeaf() {
            if (this.m_init) {
                return super.isLeaf();
            }
            return false;
        }
    }
}

