/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.util.Holder;

public class SchemaObjectBuilder {
    private boolean m_cancellable;
    private DBObjectProvider m_pro;
    private static final Stack<SystemObject> STACK = new Stack();

    public SchemaObjectBuilder(boolean cancellable) {
        this.m_cancellable = cancellable;
    }

    public void buildDerivedProperties(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public boolean ensureObjectBuilt(SystemObject ... objs) {
        if (objs != null && objs.length > 0) {
            try {
                this.ensureObjectBuiltImpl(objs);
                return true;
            }
            catch (CancelledException ce) {
            }
            catch (DBException dbe) {
                DBObject obj = dbe.getObject();
                String title = obj == null ? UIArb.getString(999) : UIArb.format(998, obj.getName());
                DBExceptionDialog.showErrorDialog((Component)IdeUtil.getMainWindow(), title, dbe);
            }
        }
        return false;
    }

    private Collection<SystemObject> getObjectsToBuild(SystemObject[] objs) {
        ArrayList<SystemObject> retval = new ArrayList<SystemObject>();
        for (SystemObject obj : objs) {
            if (!DBUtil.needsBuilding((SystemObject)obj) && (this.m_pro == null || !DBUtil.needsDerivedPropertiesBuilding((SystemObject)obj))) continue;
            if (SchemaObjectBuilder.stackContains(obj)) {
                DBLog.getLogger().log(Level.FINE, "Attempt made to build {0} {1} synchronously on separate threads.", new Object[]{obj.getType(), obj.getName()});
                continue;
            }
            retval.add(obj);
        }
        return retval;
    }

    private String getProgressText(DBObject obj) {
        return UIArb.format(996, DBTypeDisplayRegistry.getSingularDisplayName(obj.getType()), obj.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureObjectBuiltImpl(SystemObject ... objs) throws DBException {
        Collection<SystemObject> toBuild = this.getObjectsToBuild(objs);
        if (toBuild.size() > 0) {
            ProgressBar pb;
            final Holder dbe = new Holder();
            if (SwingUtilities.isEventDispatchThread()) {
                Frame parent = IdeUtil.getMainWindow();
                pb = new ProgressBar((Component)parent, UIArb.getString(995), null, true);
                pb.setCancelable(this.m_cancellable);
                Stack<SystemObject> stack = STACK;
                synchronized (stack) {
                    for (SystemObject so : toBuild) {
                        STACK.push(so);
                    }
                }
            } else {
                pb = null;
            }
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Stack stack = STACK;
                        synchronized (stack) {
                            while (!STACK.isEmpty()) {
                                block15: {
                                    SystemObject obj = (SystemObject)STACK.pop();
                                    try {
                                        if (pb != null) {
                                            pb.updateProgress(SchemaObjectBuilder.this.getProgressText((DBObject)obj), null);
                                        }
                                        DBUtil.ensureObjectBuilt((SystemObject)obj);
                                        if (SchemaObjectBuilder.this.m_pro == null) break block15;
                                        try {
                                            DBUtil.ensureDerivedPropertiesBuilt((SystemObject)obj, (DBObjectProvider)SchemaObjectBuilder.this.m_pro);
                                        }
                                        catch (DBException dbe2) {
                                            DBLog.getLogger().log(Level.WARNING, UIArb.format(1000, DBTypeDisplayRegistry.getSingularDisplayName(obj.getType()), obj.getName(), dbe2.getMessage()));
                                        }
                                    }
                                    catch (DBException ex) {
                                        dbe.set((Object)ex);
                                        break;
                                    }
                                    catch (Throwable t) {
                                        dbe.set((Object)new DBException((DBObject)obj, t));
                                        break;
                                    }
                                }
                                if (pb == null || !pb.hasUserCancelled()) continue;
                                break;
                            }
                        }
                    }
                    finally {
                        if (pb != null) {
                            if (pb.hasUserCancelled()) {
                                StatementWrapper.getExecutionProxy().setCancelling(false);
                            }
                            pb.setDoneStatus();
                        }
                    }
                }
            };
            if (pb == null) {
                r.run();
            } else {
                pb.setRunnable(r);
                pb.start(this.getProgressText((DBObject)toBuild.iterator().next()), null, 1500);
                if (pb.hasUserCancelled()) {
                    StatementWrapper.getExecutionProxy().setCancelling(true);
                    throw new CancelledException();
                }
            }
            if (dbe.get() != null) {
                throw (DBException)((Object)dbe.get());
            }
        }
    }

    private static boolean stackContains(SystemObject obj) {
        for (SystemObject inStack : STACK) {
            if (obj != inStack) continue;
            return true;
        }
        return false;
    }
}

