/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.Component;
import java.util.Comparator;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.UIArb;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class DBObjectRenderer
implements TableCellRenderer,
ListCellRenderer,
TreeCellRenderer,
Comparator {
    private static final String EMPTY = "<" + UIArb.getString(159) + ">";
    private TableCellRenderer _tableDelegate;
    private ListCellRenderer _listDelegate;
    private TreeCellRenderer _treeDelegate;
    private String _nullLabel;
    private DBObjectProvider _prov;
    private boolean _iconify;
    private boolean _typeCompare;
    private boolean m_showSchema;

    public DBObjectRenderer() {
    }

    public DBObjectRenderer(boolean includeIcon) {
        this._iconify = includeIcon;
    }

    public String getNullLabel() {
        return this._nullLabel;
    }

    public void setNullLabel(String lbl) {
        this._nullLabel = lbl;
    }

    public void setProvider(DBObjectProvider prov) {
        this._prov = prov;
    }

    public void setIncludeIcon(boolean boo) {
        this._iconify = boo;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof DBObject && (value = ((DBObject)value).getName()) == null) {
            value = this._nullLabel;
        }
        if (this._tableDelegate == null) {
            this._tableDelegate = new DefaultTableCellRenderer();
        }
        return this._tableDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this._listDelegate == null) {
            this._listDelegate = new DefaultListCellRenderer();
        }
        Object renderMe = value;
        String type = null;
        if (value instanceof SQLFragment) {
            renderMe = ((SQLFragment)value).getSQLText();
        } else if (value instanceof DBObject) {
            type = ((DBObject)value).getType();
            renderMe = ((DBObject)value).getName();
            if (null != this._prov) {
                Schema s;
                String quotedName = null;
                try {
                    quotedName = this._prov.quoteIdentifier((String)renderMe, false);
                }
                catch (DBException e) {
                    quotedName = (String)renderMe;
                }
                renderMe = quotedName;
                if (this.m_showSchema && value instanceof SchemaObject && (s = ((SchemaObject)value).getSchema()) != null) {
                    renderMe = s.getName() + "." + (String)renderMe;
                }
            }
            if (!ModelUtil.hasLength((String)((String)renderMe)) && value instanceof Schema && ((Schema)value).getProperty("isDefaultSchema", (Object)Boolean.FALSE).equals(Boolean.TRUE)) {
                renderMe = UIArb.getString(145);
            }
            if (renderMe == null) {
                renderMe = this._nullLabel;
            }
        } else if (value instanceof SchemaObjectDescriptor) {
            renderMe = ((SchemaObjectDescriptor)value).getName();
            String otherName = ((SchemaObjectDescriptor)value).getOtherName();
            if (otherName != null && !otherName.equals(renderMe)) {
                renderMe = (String)renderMe + " (" + otherName + ")";
            }
            String schema = ((SchemaObjectDescriptor)value).getSchema();
            if (this.m_showSchema && ModelUtil.hasLength((String)schema)) {
                renderMe = schema + "." + (String)renderMe;
            }
            type = ((SchemaObjectDescriptor)value).getType();
        }
        JLabel retval = (JLabel)this._listDelegate.getListCellRendererComponent(list, renderMe, index, isSelected, cellHasFocus);
        if (this._iconify && type != null) {
            retval.setIcon(DBTypeDisplayRegistry.getNodeIcon(type));
        }
        if (value instanceof AliasFragment) {
            this.setupAliasFragmentLabel(retval, (AliasFragment)value);
        } else if (value instanceof OrderByObject && (renderMe == null || ((OrderByObject)value).getExpression() == null)) {
            retval.setText(EMPTY);
        }
        return retval;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon icon;
        if (this._treeDelegate == null) {
            this._treeDelegate = new DefaultTreeCellRenderer();
        }
        JLabel retval = (JLabel)this._treeDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        String type = null;
        if (value instanceof DefaultMutableTreeNode) {
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            if (obj instanceof SchemaObjectDescriptor) {
                retval.setText(((SchemaObjectDescriptor)obj).getName());
                type = ((SchemaObjectDescriptor)obj).getType();
            } else if (obj instanceof AliasFragment) {
                if (obj instanceof FromObject && ((FromObject)obj).getExpression() instanceof JoinObject) {
                    JoinObject join = (JoinObject)((FromObject)obj).getExpression();
                    String joinType = join.getJoinType();
                    String text = "JOIN";
                    if (joinType != null) {
                        text = joinType + " " + text;
                    }
                    retval.setText(text);
                    if (this._iconify) {
                        retval.setIcon(DBTypeDisplayRegistry.getNodeIcon("CONSTRAINT"));
                    }
                } else {
                    this.setupAliasFragmentLabel(retval, (AliasFragment)obj);
                }
            } else if (obj instanceof FKUsage) {
                FromObject right;
                String text = null;
                DBObjectID id = ((FKUsage)obj).getObjectID();
                if (id != null) {
                    try {
                        DBObject fk = id.resolveID();
                        text = fk.getName();
                    }
                    catch (DBException dbe) {
                        // empty catch block
                    }
                }
                if ((right = ((FKUsage)obj).resolveRightFromObject()) != null) {
                    text = text + " (" + right.getName() + ")";
                }
                retval.setText(text);
                if (this._iconify) {
                    retval.setIcon(DBTypeDisplayRegistry.getNodeIcon("CONSTRAINT"));
                }
            } else if (obj instanceof SQLFragment) {
                String sql = ((SQLFragment)obj).getSQLText();
                retval.setText(sql);
                DBObjectRenderer.setToolTipText(retval, sql);
                if (obj instanceof ColumnUsage) {
                    retval.setIcon(OracleIcons.getIcon((String)"column.png"));
                } else {
                    retval.setIcon(OracleIcons.getIcon((String)"function.png"));
                }
            } else if (obj instanceof DBObject) {
                if (this.m_showSchema && obj instanceof SchemaObject) {
                    Schema schema = ((SchemaObject)obj).getSchema();
                    if (schema != null) {
                        retval.setText(schema.getName() + "." + ((DBObject)obj).getName());
                    } else {
                        retval.setText(((DBObject)obj).getName());
                    }
                } else {
                    retval.setText(((DBObject)obj).getName());
                }
                DBObjectRenderer.setToolTipText(retval, DBUtil.getFullyQualifiedName((DBObject)((DBObject)obj)));
                if (obj instanceof FKConstraint) {
                    retval.setIcon(OracleIcons.getIcon((String)"foreignkey.png"));
                } else if (obj instanceof CheckConstraint) {
                    retval.setIcon(OracleIcons.getIcon((String)"constraint.png"));
                } else if (obj instanceof PKConstraint || obj instanceof UniqueConstraint) {
                    retval.setIcon(OracleIcons.getIcon((String)"key.png"));
                } else {
                    type = ((DBObject)obj).getType();
                }
            } else if (obj instanceof String && this._iconify && !leaf) {
                Icon icon2 = DBTypeDisplayRegistry.getFolderIcon((String)obj);
                if (icon2 == null) {
                    retval.setIcon(OracleIcons.getIcon((String)"folder.png"));
                } else {
                    retval.setIcon(icon2);
                }
            }
        }
        if (this._iconify && type != null && (icon = DBTypeDisplayRegistry.getNodeIcon(type)) != null) {
            retval.setIcon(icon);
        }
        return retval;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof AliasFragment) {
            if (o2 instanceof AliasFragment) {
                return this.compare(((AliasFragment)o1).getName(), ((AliasFragment)o2).getName());
            }
            return -100;
        }
        if (o1 instanceof SQLFragment) {
            if (o2 instanceof SQLFragment) {
                return this.compare(((SQLFragment)o1).getSQLText(), ((SQLFragment)o2).getSQLText());
            }
            return -100;
        }
        if (o1 instanceof FunctionDefinition) {
            if (o2 instanceof FunctionDefinition) {
                return this.compare(((FunctionDefinition)o1).getName(), ((FunctionDefinition)o2).getName());
            }
            return 100;
        }
        if (o1 instanceof DBObject) {
            if (o2 instanceof DBObject) {
                return this.compare((DBObject)o1, (DBObject)o2);
            }
            return 100;
        }
        return 100;
    }

    public int compare(DBObject o1, DBObject o2) {
        String t2;
        String t1;
        int i;
        if (this._typeCompare && (i = this.compare(t1 = o1.getType(), t2 = o2.getType())) != 0) {
            return i;
        }
        String n1 = o1.getName();
        String n2 = o2.getName();
        return this.compare(n1, n2);
    }

    private int compare(String s1, String s2) {
        return s1 == null ? (s2 == null ? 0 : 1) : s1.compareTo(s2);
    }

    public void setCompareByType(boolean boo) {
        this._typeCompare = boo;
    }

    public void setShowSchema(boolean showSchema) {
        this.m_showSchema = showSchema;
    }

    private void setupAliasFragmentLabel(JLabel label, AliasFragment fo) {
        DBObjectID id;
        String alias = fo.getAlias();
        SQLFragment exp = fo.getExpression();
        String text = null;
        if (exp != null) {
            text = exp.getSQLText();
        }
        FastStringBuffer buff = new FastStringBuffer();
        if (ModelUtil.hasLength((String)alias)) {
            buff.append(alias);
            buff.append(" (");
            buff.append(text);
            buff.append(")");
        } else if (ModelUtil.hasLength((String)text)) {
            buff.append(text);
        } else {
            buff.append(EMPTY);
        }
        label.setText(buff.toString());
        if (this._iconify && exp instanceof DBObjectUsage && (id = ((DBObjectUsage)exp).getObjectID()) != null) {
            String type = id.getType();
            label.setIcon(DBTypeDisplayRegistry.getNodeIcon(type));
        }
    }

    public static void setToolTipText(JComponent widget, String text) {
        widget.setToolTipText(text);
        AccessibleContext actx = widget.getAccessibleContext();
        if (actx != null) {
            actx.setAccessibleDescription(text);
        }
    }

    @Deprecated
    public static DefaultMutableTreeNode createTreeNode(DBObject obj, boolean showChildren) {
        return DBObjectRenderer.createTreeNode(obj, showChildren, null);
    }

    @Deprecated
    public static DefaultMutableTreeNode createTreeNode(DBObject obj, boolean showChildren, String[] includeChildTypes) {
        TreeNodeMaker tnm = new TreeNodeMaker(true, includeChildTypes);
        return tnm.createTreeNode(obj);
    }

    @Deprecated
    public static DefaultMutableTreeNode createTreeNode(SQLFragment obj, boolean showChildren) {
        TreeNodeMaker tnm = new TreeNodeMaker(true);
        return tnm.createTreeNode(obj);
    }
}

