/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.panels.trigger.BaseTriggerPanel;
import oracle.ide.db.panels.trigger.DMLSubPanel;
import oracle.ide.db.panels.trigger.TriggerPanel;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.View;
import oracle.javatools.util.ModelUtil;

public class ViewTriggerPanel
extends BaseTriggerPanel {
    private GridBagLayout m_layMain = new GridBagLayout();
    private JLabel m_lblOwner = new JLabel();
    private DBObjectChooser m_cmbOwner = new DBObjectChooser("SCHEMA");
    private JLabel m_lblName = new JLabel();
    private DBObjectChooser m_cmbView = new DBObjectChooser(this.m_cmbOwner, "VIEW");
    private DMLSubPanel m_pnlDML = new DMLSubPanel();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("ViewTriggerPanel");

    public ViewTriggerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layMain);
        this.m_resHelper.resLabel(this.m_lblOwner, this.m_cmbOwner, UIArb.getString(786), "_cmbOwner");
        this.m_resHelper.resLabel(this.m_lblName, this.m_cmbView, UIArb.getString(787), "_cmbView");
        this.add(this.m_lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_cmbOwner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_lblName, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add(this.m_cmbView, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlDML), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void commit() throws TraversalException {
        Schema tableOwner = (Schema)this.m_cmbOwner.getOrCreateDBObject();
        View view = (View)this.m_cmbView.getDBObject();
        String viewName = null;
        if (view != null) {
            viewName = view.getName();
        }
        if (!ModelUtil.hasLength(viewName)) {
            throw new TraversalException(UIArb.getString(788));
        }
        Trigger trigger = this.getTrigger();
        trigger.setTableID(view.getID());
        trigger.setTiming(Trigger.Timing.INSTEAD_OF);
        this.m_pnlDML.commit();
    }

    @Override
    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canEditTrigger, boolean canChangeSchema, TriggerVerifier verifier) {
        super.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        Schema viewOwner = trigger.getSchema();
        DBObject view = null;
        try {
            if (trigger.getTableID() != null) {
                view = trigger.getTableID().resolveID();
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        this.m_cmbOwner.setProvider(prov);
        this.m_cmbOwner.setDBObject((DBObject)viewOwner);
        this.m_cmbOwner.setEnabled(canChangeSchema);
        if (view != null && view instanceof View) {
            viewOwner = ((View)view).getSchema();
            this.m_cmbView.setDBObject(view);
        }
        this.m_cmbOwner.setEnabled(canChangeSchema);
        this.m_pnlDML.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        if (!canEditTrigger || verifier != null && !verifier.canChangeBaseObject()) {
            this.m_lblOwner.setEnabled(false);
            this.m_cmbOwner.setEnabled(false);
            this.m_lblName.setEnabled(false);
            this.m_cmbView.setEnabled(false);
        }
    }

    @Override
    void setParent(TriggerPanel parent) {
        super.setParent(parent);
        this.m_pnlDML.setParent(parent);
    }

    @Override
    protected boolean getCurrentOKState() {
        return this.m_pnlDML.getCurrentOKState();
    }
}

