/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.panels.trigger.BaseTriggerPanel;
import oracle.ide.db.panels.trigger.DMLSubPanel;
import oracle.ide.db.panels.trigger.TriggerPanel;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.util.ModelUtil;

public class TableTriggerPanel
extends BaseTriggerPanel
implements ItemListener {
    private GridBagLayout m_layMain = new GridBagLayout();
    private JLabel m_lblOwner = new JLabel();
    private DBObjectChooser m_cmbOwner = new DBObjectChooser("SCHEMA");
    private JLabel m_lblTable = new JLabel();
    private DBObjectChooser m_cmbTable = new DBObjectChooser(this.m_cmbOwner, "TABLE");
    private JRadioButton m_radBefore = new JRadioButton();
    private JRadioButton m_radAfter = new JRadioButton();
    private ButtonGroup m_grpTiming = new ButtonGroup();
    private JRadioButton m_radStatement = new JRadioButton();
    private JRadioButton m_radRow = new JRadioButton();
    private ButtonGroup m_grpLevel = new ButtonGroup();
    private DMLSubPanel m_pnlDMLOption = new DMLSubPanel();
    private JLabel m_lblAvail = new JLabel();
    private JList m_lstAvail = new JList();
    private ListPicker m_pckAvail = new ListPicker(this.m_lstAvail);
    private JLabel m_lblSel = new JLabel();
    private JList m_lstSel = new JList();
    private ListPicker m_pckSel = new ListPicker(this.m_lstSel);
    private Shuttle m_shtCols = new Shuttle();
    private JLabel m_lblWhen = new JLabel();
    private JTextField m_fldWhen = new JTextField();
    private Table m_lastTable = null;
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("TableTriggerPanel");

    public TableTriggerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void commit() throws TraversalException {
        Schema tableOwner = (Schema)this.m_cmbOwner.getOrCreateDBObject();
        Table table = (Table)this.m_cmbTable.getDBObject();
        String tableName = null;
        if (table != null) {
            tableName = table.getName();
        }
        if (!ModelUtil.hasLength(tableName)) {
            throw new TraversalException(UIArb.getString(779));
        }
        Trigger.Timing timing = this.m_radBefore.isSelected() ? Trigger.Timing.BEFORE : Trigger.Timing.AFTER;
        boolean stmtTrigger = this.m_radStatement.isSelected();
        ArrayList<DBObjectID> colIDs = new ArrayList<DBObjectID>();
        if (this.m_pnlDMLOption.isUpdateSelected() && this.m_lstAvail.getModel().getSize() > 0) {
            ListModel model = this.m_lstSel.getModel();
            int count = model.getSize();
            for (int i = 0; i < count; ++i) {
                colIDs.add(table.getColumn((String)model.getElementAt(i)).getID());
            }
        }
        Trigger trigger = this.getTrigger();
        trigger.setTableID(table.getID());
        trigger.setTiming(timing);
        trigger.setStatementLevel(stmtTrigger);
        trigger.setColumnIDs(colIDs.toArray(new DBObjectID[colIDs.size()]));
        String whenClause = this.m_fldWhen.getText();
        if (this.m_fldWhen.isEnabled() && ModelUtil.hasLength((String)whenClause)) {
            trigger.setWhenClause(whenClause);
        } else {
            trigger.setWhenClause(null);
        }
        this.m_pnlDMLOption.commit();
    }

    @Override
    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canEditTrigger, boolean canChangeSchema, TriggerVerifier verifier) {
        Schema schema;
        super.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        DBObject table = null;
        try {
            if (trigger.getTableID() != null) {
                table = trigger.getTableID().resolveID();
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        Schema schema2 = schema = table instanceof SchemaObject ? ((SchemaObject)table).getSchema() : null;
        if (schema == null) {
            schema = trigger.getSchema();
        }
        this.m_cmbOwner.setProvider(prov);
        this.m_cmbOwner.setDBObject((DBObject)schema);
        this.m_cmbOwner.setEnabled(canChangeSchema);
        if (table != null && table instanceof Table) {
            this.m_cmbTable.setDBObject(table);
            this.setColumnList(schema, (Table)table);
        }
        boolean before = trigger.getTiming() == null ? true : trigger.getTiming() == Trigger.Timing.BEFORE;
        this.m_radBefore.setSelected(before);
        this.m_radAfter.setSelected(!before);
        this.m_radStatement.setSelected(trigger.isStatementLevel());
        this.m_radRow.setSelected(!trigger.isStatementLevel());
        this.m_pnlDMLOption.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        this.updateShuttle(this.m_pnlDMLOption.isUpdateSelected());
        this.m_fldWhen.setText(trigger.getWhenClause());
        if (verifier != null && !verifier.canChangeBaseObject()) {
            this.m_lblOwner.setEnabled(false);
            this.m_cmbOwner.setEnabled(false);
            this.m_lblTable.setEnabled(false);
            this.m_cmbTable.setEnabled(false);
        } else if (!canEditTrigger) {
            this.m_lblOwner.setEnabled(false);
            this.m_cmbOwner.setEnabled(false);
            this.m_lblTable.setEnabled(false);
            this.m_cmbTable.setEnabled(false);
            this.m_radBefore.setEnabled(false);
            this.m_radAfter.setEnabled(false);
            this.m_radStatement.setEnabled(false);
            this.m_radRow.setEnabled(false);
            this.m_lblAvail.setEnabled(false);
            this.m_lstAvail.setEnabled(false);
            this.m_lblSel.setEnabled(false);
            this.m_lstSel.setEnabled(false);
            this.m_shtCols.setEnabled(false);
            this.m_lblWhen.setEnabled(false);
            this.m_fldWhen.setEnabled(false);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layMain);
        this.m_resHelper.resLabel(this.m_lblOwner, this.m_cmbOwner, UIArb.getString(772), "_cmbOwner");
        this.m_cmbOwner.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                TableTriggerPanel.this.updateSchema((Schema)TableTriggerPanel.this.m_cmbOwner.getDBObject());
            }
        });
        this.m_resHelper.resLabel(this.m_lblTable, this.m_cmbTable, UIArb.getString(773), "_cmbTable");
        this.m_cmbTable.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                TableTriggerPanel.this.updateTable((Schema)TableTriggerPanel.this.m_cmbOwner.getOrCreateDBObject(), (Table)TableTriggerPanel.this.m_cmbTable.getDBObject());
            }
        });
        this.m_resHelper.resButton(this.m_radBefore, UIArb.getString(770), "_radBefore");
        this.m_grpTiming.add(this.m_radBefore);
        this.m_resHelper.resButton(this.m_radAfter, UIArb.getString(771), "_radAfter");
        this.m_grpTiming.add(this.m_radAfter);
        this.m_radBefore.setSelected(true);
        this.m_resHelper.resButton(this.m_radStatement, UIArb.getString(774), "_radStatement");
        this.m_grpLevel.add(this.m_radStatement);
        this.m_radStatement.addItemListener(this);
        this.m_resHelper.resButton(this.m_radRow, UIArb.getString(775), "_radRow");
        this.m_grpLevel.add(this.m_radRow);
        this.m_radStatement.setSelected(true);
        this.m_pnlDMLOption.addUpdateItemListener(this);
        this.m_resHelper.resLabel(this.m_lblAvail, this.m_lstAvail, UIArb.getString(776), "_lstAvail");
        this.m_shtCols.setFromPicker((ItemPicker)this.m_pckAvail);
        this.m_lstAvail.addFocusListener(this);
        this.m_resHelper.resLabel(this.m_lblSel, this.m_lstSel, UIArb.getString(777), "_lstSel");
        this.m_shtCols.setToPicker((ItemPicker)this.m_pckSel);
        this.m_lstSel.addFocusListener(this);
        this.m_resHelper.resLabel(this.m_lblWhen, this.m_fldWhen, UIArb.getString(778), "_fldWhen");
        this.add(this.m_lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_cmbOwner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_lblTable, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add(this.m_cmbTable, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlDMLOption), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel pnlWhen = new JPanel();
        pnlWhen.setLayout(new GridBagLayout());
        pnlWhen.add((Component)this.m_radBefore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        pnlWhen.add((Component)this.m_radAfter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlWhen.add((Component)this.m_radStatement, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0));
        pnlWhen.add((Component)this.m_radRow, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        JPanel pnlSubWhen = new JPanel();
        pnlSubWhen.setLayout(new GridBagLayout());
        pnlSubWhen.add((Component)this.m_lblWhen, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlSubWhen.add((Component)this.m_fldWhen, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        pnlWhen.add((Component)pnlSubWhen, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(pnlWhen, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.m_shtCols.add((Component)this.m_lblAvail, (Object)"FromHeader");
        this.m_shtCols.add((Component)this.m_lblSel, (Object)"ToHeader");
        this.add((Component)this.m_shtCols, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this.m_radStatement) {
            boolean row = !this.m_radStatement.isSelected();
            this.m_fldWhen.setEnabled(row);
        }
        this.updateShuttle(this.m_pnlDMLOption.isUpdateSelected());
    }

    private void updateShuttle(boolean enabled) {
        this.m_shtCols.setEnabled(enabled);
        this.m_lstAvail.setEnabled(enabled);
        this.m_lstSel.setEnabled(enabled);
        this.m_lblAvail.setEnabled(enabled);
        this.m_lblSel.setEnabled(enabled);
    }

    private void updateSchema(Schema schema) {
        this.updateTable(schema, (Table)this.m_cmbTable.getDBObject());
    }

    private void updateTable(Schema schema, Table table) {
        if (this.m_lastTable != null && this.m_lastTable != table) {
            this.getTrigger().setColumnIDs(new DBObjectID[0]);
            this.m_lastTable = table;
        }
        this.setColumnList(schema, table);
    }

    private void setColumnList(Schema schema, Table table) {
        DefaultListModel<String> availModel = new DefaultListModel<String>();
        DefaultListModel<String> selectedModel = new DefaultListModel<String>();
        if (table != null) {
            Column[] tableCols = table.getColumns();
            DBObjectID[] updateColumnIds = this.getTrigger().getColumnIDs();
            for (int i = 0; i < tableCols.length; ++i) {
                boolean selected = false;
                if (updateColumnIds == null || updateColumnIds.length == 0) {
                    selected = true;
                } else {
                    for (DBObjectID id : updateColumnIds) {
                        if (!id.equals(tableCols[i].getID())) continue;
                        selected = true;
                        break;
                    }
                }
                if (selected) {
                    selectedModel.addElement(tableCols[i].getName());
                    continue;
                }
                availModel.addElement(tableCols[i].getName());
            }
        }
        this.m_lstAvail.setModel(availModel);
        this.m_lstSel.setModel(selectedModel);
    }

    private String getKey(Schema schema, String tableName) {
        FastStringBuffer buf = new FastStringBuffer();
        if (schema != null) {
            buf.append(schema.getName()).append('.');
        }
        buf.append(tableName);
        return buf.toString();
    }

    @Override
    void setParent(TriggerPanel parent) {
        super.setParent(parent);
        this.m_pnlDMLOption.setParent(parent);
    }

    @Override
    protected boolean getCurrentOKState() {
        return this.m_pnlDMLOption.getCurrentOKState() && (!this.m_pnlDMLOption.isUpdateSelected() || this.m_lstSel.getModel().getSize() > 0);
    }
}

