/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.trigger.BaseTriggerPanel;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;

public class DMLSubPanel
extends BaseTriggerPanel {
    private GridBagLayout m_layMain = new GridBagLayout();
    private JCheckBox m_chkInsert = new JCheckBox();
    private JCheckBox m_chkDelete = new JCheckBox();
    private JCheckBox m_chkUpdate = new JCheckBox();
    private JPanel m_pnlReferencing = new JPanel();
    private GridBagLayout m_layReferencing = new GridBagLayout();
    private Border m_bdrReferencing = BorderFactory.createTitledBorder(UIArb.getString(783));
    private JLabel m_lblOld = new JLabel();
    private JTextField m_fldOld = new JTextField();
    private JLabel m_lblNew = new JLabel();
    private JTextField m_fldNew = new JTextField();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("DMLSubPanel");

    public DMLSubPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layMain);
        this.m_pnlReferencing.setLayout(this.m_layReferencing);
        this.m_resHelper.resButton(this.m_chkInsert, UIArb.getString(780), "_chkInsert");
        this.m_resHelper.resButton(this.m_chkDelete, UIArb.getString(781), "_chkDelete");
        this.m_resHelper.resButton(this.m_chkUpdate, UIArb.getString(782), "_chkUpdate");
        this.m_resHelper.resLabel(this.m_lblOld, this.m_fldOld, UIArb.getString(785), "_fldOld");
        this.m_resHelper.resLabel(this.m_lblNew, this.m_fldNew, UIArb.getString(784), "_fldNew");
        this.m_pnlReferencing.setBorder(this.m_bdrReferencing);
        this.m_pnlReferencing.add((Component)this.m_lblOld, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 12), 0, 0));
        this.m_pnlReferencing.add((Component)this.m_fldOld, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlReferencing.add((Component)this.m_lblNew, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 12), 0, 0));
        this.m_pnlReferencing.add((Component)this.m_fldNew, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_chkInsert, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_chkDelete, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_chkUpdate, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_pnlReferencing, new GridBagConstraints(1, 0, 1, 3, 1.0, 0.0, 10, 1, new Insets(0, 24, 0, 0), 0, 0));
    }

    @Override
    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canEditTrigger, boolean canChangeSchema, TriggerVerifier verifier) {
        super.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        this.m_chkInsert.setSelected(false);
        this.m_chkDelete.setSelected(false);
        this.m_chkUpdate.setSelected(false);
        for (String event : trigger.getEvents()) {
            if ("INSERT".equals(event)) {
                this.m_chkInsert.setSelected(true);
                continue;
            }
            if ("DELETE".equals(event)) {
                this.m_chkDelete.setSelected(true);
                continue;
            }
            if (!"UPDATE".equals(event)) continue;
            this.m_chkUpdate.setSelected(true);
        }
        this.m_fldOld.setText(trigger.getReferencingOldAs());
        this.m_fldNew.setText(trigger.getReferencingNewAs());
        if (!canEditTrigger) {
            this.m_chkInsert.setEnabled(false);
            this.m_chkDelete.setEnabled(false);
            this.m_chkUpdate.setEnabled(false);
            this.m_lblOld.setEnabled(false);
            this.m_fldOld.setEnabled(false);
            this.m_lblNew.setEnabled(false);
            this.m_fldNew.setEnabled(false);
        }
    }

    public void addUpdateItemListener(ItemListener l) {
        this.m_chkUpdate.addItemListener(l);
    }

    public void removeUpdateItemListener(ItemListener l) {
        this.m_chkUpdate.removeItemListener(l);
    }

    public void setUpdateSelected(boolean sel) {
        this.m_chkUpdate.setSelected(sel);
    }

    public boolean isUpdateSelected() {
        return this.m_chkUpdate.isSelected();
    }

    @Override
    public void commit() throws TraversalException {
        ArrayList<String> events = new ArrayList<String>();
        if (this.m_chkInsert.isSelected()) {
            events.add("INSERT");
        }
        if (this.m_chkDelete.isSelected()) {
            events.add("DELETE");
        }
        if (this.m_chkUpdate.isSelected()) {
            events.add("UPDATE");
        }
        Trigger trigger = this.getTrigger();
        trigger.setReferencingOldAs(this.m_fldOld.getText());
        trigger.setReferencingNewAs(this.m_fldNew.getText());
        trigger.setEvents(events.toArray(new String[events.size()]));
    }

    @Override
    protected boolean getCurrentOKState() {
        return this.m_chkDelete.isSelected() || this.m_chkInsert.isSelected() || this.m_chkUpdate.isSelected();
    }
}

