/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.db.UIArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Table;

public class TableTypePanel
extends JPanel
implements ActionListener {
    private ActionListener m_actionListener;
    private ButtonGroup m_group = new ButtonGroup();
    private JRadioButton m_normalRadio = new JRadioButton();
    private JRadioButton m_externalRadio = new JRadioButton();
    private JRadioButton m_iotRadio = new JRadioButton();
    private JRadioButton m_tempTxnRadio = new JRadioButton();
    private JRadioButton m_tempSessionRadio = new JRadioButton();

    public TableTypePanel(boolean incTitle) {
        try {
            this.layoutComponents(incTitle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents(boolean incTitle) {
        this.m_normalRadio.setName("RDB_TABLE");
        this.m_externalRadio.setName("RDB_EXTERNAL_TABLE");
        this.m_iotRadio.setName("RDB_IOT");
        this.m_tempTxnRadio.setName("RDB_TXN_TEM_TABLE");
        this.m_tempSessionRadio.setName("RDB_SESSION_TEMP_TABLE");
        this.m_group.add(this.m_normalRadio);
        this.m_group.add(this.m_externalRadio);
        this.m_group.add(this.m_iotRadio);
        this.m_group.add(this.m_tempTxnRadio);
        this.m_group.add(this.m_tempSessionRadio);
        this.m_normalRadio.addActionListener(this);
        this.m_iotRadio.addActionListener(this);
        this.m_externalRadio.addActionListener(this);
        this.m_tempTxnRadio.addActionListener(this);
        this.m_tempSessionRadio.addActionListener(this);
        this.m_normalRadio.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this.m_normalRadio, (String)UIArb.getString(543));
        ResourceUtils.resButton((AbstractButton)this.m_tempTxnRadio, (String)UIArb.getString(540));
        ResourceUtils.resButton((AbstractButton)this.m_tempSessionRadio, (String)UIArb.getString(539));
        ResourceUtils.resButton((AbstractButton)this.m_externalRadio, (String)UIArb.getString(541));
        ResourceUtils.resButton((AbstractButton)this.m_iotRadio, (String)UIArb.getString(542));
        this.setLayout(new GridBagLayout());
        int y = 0;
        int x = 0;
        if (incTitle) {
            JLabel title = new JLabel(UIArb.getString(538));
            this.add((Component)title, new GridBagConstraints(x, y, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        }
        this.add((Component)this.m_normalRadio, new GridBagConstraints(x, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_externalRadio, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_iotRadio, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_tempTxnRadio, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_tempSessionRadio, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(++x, y, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void enableAllComponents(boolean boo) {
        this.m_normalRadio.setEnabled(boo);
        this.m_externalRadio.setEnabled(boo);
        this.m_iotRadio.setEnabled(boo);
        this.m_tempTxnRadio.setEnabled(boo);
        this.m_tempSessionRadio.setEnabled(boo);
    }

    public Table.TableType getTableType() {
        if (this.m_externalRadio.isSelected()) {
            return Table.TableType.EXTERNAL;
        }
        if (this.m_iotRadio.isSelected()) {
            return Table.TableType.INDEX_ORGANIZED;
        }
        if (this.m_tempTxnRadio.isSelected()) {
            return Table.TableType.TRANSACTION_TEMP;
        }
        if (this.m_tempSessionRadio.isSelected()) {
            return Table.TableType.SESSION_TEMP;
        }
        return Table.TableType.NORMAL;
    }

    public void setTableType(Table.TableType type) {
        switch (type) {
            case INDEX_ORGANIZED: {
                this.m_iotRadio.setSelected(true);
                break;
            }
            case EXTERNAL: {
                this.m_externalRadio.setSelected(true);
                break;
            }
            case SESSION_TEMP: {
                this.m_tempSessionRadio.setSelected(true);
                break;
            }
            case TRANSACTION_TEMP: {
                this.m_tempTxnRadio.setSelected(true);
                break;
            }
            default: {
                this.m_normalRadio.setSelected(true);
            }
        }
        this.actionPerformed(null);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.m_actionListener = AWTEventMulticaster.add(this.m_actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.m_actionListener = AWTEventMulticaster.remove(this.m_actionListener, l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            e.setSource(this);
            this.m_actionListener.actionPerformed(e);
        }
    }
}

