/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import oracle.ide.Ide;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaAdvancedEditor;
import oracle.ide.db.panels.table.TableTypePanel;
import oracle.ide.db.verifiers.table.TableInfoVerifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.property.Property;
import oracle.javatools.dialogs.MessageDialog;

public class TableInfoPanel
extends NameAndSchemaAdvancedEditor<Table> {
    private JLabel m_tableTypeLabel = new JLabel(UIArb.getString(538));
    private TableTypePanel m_tableTypePanel = new TableTypePanel(false);
    private TableInfoVerifier m_tableVerifier;
    private Table.TableType m_lastType;
    private final Map<String, Object> m_cachedProps = new HashMap<String, Object>();

    public TableInfoPanel() {
        this.getHelper().setAllowRecreate(false);
        this.getHelper().registerComponent(this.m_tableTypeLabel, Property.createPath((String[])new String[]{"properties", "TableType"}));
        this.getHelper().registerComponent(this.m_tableTypePanel, Property.createPath((String[])new String[]{"properties", "TableType"}));
        this.m_tableTypePanel.addActionListener(this);
    }

    private void removeTypePanel() {
        this.remove(this.m_tableTypeLabel);
        this.remove(this.m_tableTypePanel);
    }

    private void addTypePanel() {
        this.removeTypePanel();
        this.add(this.m_tableTypeLabel, new GridBagConstraints(0, 30, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.m_tableTypePanel, new GridBagConstraints(1, 30, 0, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        if (this.isAdvancedLayout() || this.isEditing()) {
            this.addTypePanel();
        }
        Table table = (Table)this.getDBObject();
        this.m_lastType = (Table.TableType)table.getProperty("TableType", (Object)Table.TableType.NORMAL);
        this.m_tableTypePanel.setTableType(this.m_lastType);
        this.m_tableVerifier = (TableInfoVerifier)this.getDataContext().find("SchemaObjectInfoVerifier");
        boolean isEditable = this.isEditable();
        if (!isEditable) {
            this.m_tableTypePanel.enableAllComponents(false);
        } else if (this.m_tableVerifier != null && !this.m_tableVerifier.canChangeTempState()) {
            this.m_tableTypePanel.enableAllComponents(false);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        this.commitType();
    }

    @Override
    protected void validateObject() throws TraversalException {
        boolean is11g;
        Table table = (Table)this.getDBObject();
        Object tableType = table.getProperty("TableType");
        boolean bl = is11g = 110 <= this.getProvider().getDescriptor().getDatabaseVersion();
        if (tableType == Table.TableType.EXTERNAL || !is11g && (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP)) {
            this.nullProperties(table, "OracleStorageProperties");
        }
        super.validateObject();
        this.m_lastType = null;
    }

    private Table.TableType commitType() {
        Table table = (Table)this.getDBObject();
        Table.TableType type = this.m_tableTypePanel.getTableType();
        table.setProperty("TableType", (Object)type);
        return type;
    }

    @Override
    protected void showSimplePanel() throws TraversalException {
        super.showSimplePanel();
        this.removeTypePanel();
    }

    @Override
    protected void showAdvancedPanel() throws TraversalException {
        this.showPanelsForTableType((Table)this.getDBObject());
        this.addTypePanel();
    }

    private void showPanelsForTableType(Table table) throws TraversalException {
        Table.TableType defaultType;
        List<Navigable> navs = this.isEditing() ? this.getPanelLibrary().getEditNavigables((DBObject)table, this.getProvider()) : this.getPanelLibrary().getCreateNavigables((DBObject)table, this.getProvider());
        Table.TableType type = (Table.TableType)table.getProperty("TableType");
        String key = type == (defaultType = this.isEditing() ? (Table.TableType)((Table)this.getOriginalObject()).getProperty("TableType") : Table.TableType.NORMAL) ? "DEFAULT_PANEL" : (type == Table.TableType.TRANSACTION_TEMP || type == Table.TableType.SESSION_TEMP ? Table.TableType.SESSION_TEMP.toString() : type.toString());
        this.changePanels(key, navs.toArray(new Navigable[navs.size()]));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_tableTypePanel) {
            Table table = (Table)this.getDBObject();
            this.m_lastType = (Table.TableType)table.getProperty("TableType");
            Table.TableType type = this.commitType();
            if (this.m_lastType != type) {
                try {
                    this.showPanelsForTableType(table);
                }
                catch (TraversalException te) {
                    te.showMessageDialog((Component)((Object)this));
                    table.setProperty("TableType", (Object)this.m_lastType);
                    this.m_tableTypePanel.setTableType(this.m_lastType);
                }
            }
        } else {
            super.actionPerformed(ev);
        }
    }

    private void validateTableTypePanelChange(Table table) throws TraversalException {
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
        if (this.m_lastType != null && this.m_lastType != tableType) {
            if (!this.doTypeChange(table, this.m_lastType)) {
                throw new TraversalException(null);
            }
            try {
                this.getProvider().validateObjectProperty((DBObject)table, Property.createPath((String[])new String[]{"properties", "TableType"}));
                this.m_lastType = null;
            }
            catch (ValidationException ve) {
                table.setProperty("TableType", (Object)this.m_lastType);
                throw new TraversalException(ve.getMessage(), ve.getTitle());
            }
        }
    }

    @Override
    public void validatePanelChange(TraversableContext data) throws TraversalException {
        this.validateTableTypePanelChange((Table)this.getDBObject());
    }

    private boolean doTypeChange(Table table, Table.TableType oldType) {
        Table.TableType type = (Table.TableType)table.getProperty("TableType");
        boolean ok = true;
        if (type != oldType) {
            StringBuilder message = new StringBuilder();
            if (type == Table.TableType.SESSION_TEMP || type == Table.TableType.TRANSACTION_TEMP) {
                ArrayList<FKConstraint> toRemove = new ArrayList<FKConstraint>();
                for (Constraint c : table.getConstraints()) {
                    if (!(c instanceof FKConstraint)) continue;
                    toRemove.add((FKConstraint)c);
                }
                if (toRemove.size() > 0) {
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UIArb.getString(547), (String)UIArb.getString(545), null, (boolean)true)) {
                        for (FKConstraint fk : toRemove) {
                            table.removeConstraint((Constraint)fk);
                        }
                        table.setProperty("OracleIndexOrganizedTableProperties", null);
                        table.setProperty("OracleExternalTableProperties", null);
                    } else {
                        ok = false;
                    }
                }
                if (ok) {
                    this.nullProperties(table, "OracleStorageProperties", "OracleIndexOrganizedTableProperties", "OracleExternalTableProperties");
                }
            } else if (type == Table.TableType.EXTERNAL) {
                if (table.getConstraints().length > 0) {
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UIArb.getString(546), (String)UIArb.getString(545), null, (boolean)true)) {
                        table.setConstraints(null);
                    } else {
                        ok = false;
                    }
                }
                if (ok) {
                    this.nullProperties(table, "OracleStorageProperties", "OracleIndexOrganizedTableProperties");
                }
            } else if (oldType == Table.TableType.INDEX_ORGANIZED) {
                this.nullProperties(table, "OracleIndexOrganizedTableProperties");
            } else if (oldType == Table.TableType.EXTERNAL) {
                this.nullProperties(table, "OracleExternalTableProperties");
            }
            if (ok) {
                if (type == Table.TableType.INDEX_ORGANIZED) {
                    this.restoreProperties(table, "OracleIndexOrganizedTableProperties");
                }
                if (type == Table.TableType.EXTERNAL) {
                    this.restoreProperties(table, "OracleExternalTableProperties");
                } else if (type != Table.TableType.TRANSACTION_TEMP && type != Table.TableType.SESSION_TEMP) {
                    this.restoreProperties(table, "OracleStorageProperties");
                }
            }
        }
        return ok;
    }

    private void nullProperties(Table table, String ... keys) {
        for (String key : keys) {
            Object value = table.getProperty(key);
            if (value != null) {
                table.setProperty(key, null);
                this.m_cachedProps.put(key, value);
            }
            if (key != "OracleStorageProperties") continue;
            for (Column column : table.getColumns()) {
                column.setProperty("OracleColumnProperties", null);
            }
        }
    }

    private void restoreProperties(Table table, String key) {
        if (this.m_cachedProps.containsKey(key)) {
            table.setProperty(key, this.m_cachedProps.get(key));
        }
    }
}

