/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageClausePanel;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.property.PropertyFilter;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public final class StorageInfoPanel
extends BaseInfoPanel
implements ActionListener {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_EMBED_IN_LOB_DESCRIPTOR = 1;
    public static final String DEFAULT_OPTION = "<DEFAULT>";
    public static final String[] LOGGING_OPTIONS = new String[]{"<DEFAULT>", "ON", "OFF"};
    private BorderLayout layMain = new BorderLayout();
    private JMultiLineLabel lblTop = new JMultiLineLabel();
    private JCheckBox cbxSegAttrs = new JCheckBox();
    private JPanel pnlCenter = null;
    private GridBagLayout layCenter = new GridBagLayout();
    private JLabel lblTablespace = new JLabel();
    private DBObjectChooser cmbTablespace = new DBObjectChooser("TABLESPACE");
    private JLabel lblPctFree = new JLabel();
    private JLabel lblPctUsed = new JLabel();
    private JLabel lblIniTrans = new JLabel();
    private JLabel lblMaxTrans = new JLabel();
    private StorageNumberField fldPctFree = new StorageNumberField();
    private StorageNumberField fldPctUsed = new StorageNumberField();
    private StorageNumberField fldIniTrans = new StorageNumberField();
    private StorageNumberField fldMaxTrans = new StorageNumberField();
    private JLabel lblLogging = new JLabel();
    private JComboBox cmbLogging = new JComboBox();
    private NonNullableComboBoxModel mdlLogging = new NonNullableComboBoxModel((Object[])LOGGING_OPTIONS);
    private StorageClausePanel _pnlSubLobStorage = new StorageClausePanel();
    private OracleStorageProperties _oProps = null;
    private boolean _isIOT = false;
    private DBObject m_contextObject;
    private boolean m_readonly = false;
    private boolean m_pctusedSupported = true;
    private StorageInfoFor m_storageInfoFor;
    private static OracleStorageProperties s_osp;
    private static Component s_comp;

    private StorageInfoPanel(StorageInfoFor storageInfoFor) {
        this.m_storageInfoFor = storageInfoFor;
        JPanel panel = new JPanel();
        try {
            this.jbInit(panel, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JComboCardPanel cardPanel = new JComboCardPanel(new JLabel(), (JComponent)this.cbxSegAttrs);
        ResourceUtils.resButton((AbstractButton)this.cbxSegAttrs, (String)UIArb.getString(708));
        cardPanel.showSubPanel((JComponent)this.pnlCenter);
        this.add((Component)cardPanel, "North");
        this.cbxSegAttrs.addActionListener(this);
    }

    public StorageInfoPanel() {
        this(null);
    }

    private void jbInit(JPanel PnlCenter, int layoutOption) throws Exception {
        this.pnlCenter = PnlCenter;
        this.pnlCenter.setLayout(this.layCenter);
        this.setLayout(this.layMain);
        this.lblTop.setPreferredAspectRatio(0.0f);
        this.lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        ResourceUtils.resLabel((JLabel)this.lblTablespace, (Component)this.cmbTablespace, (String)UIArb.getString(709));
        ResourceUtils.resLabel((JLabel)this.lblPctFree, (Component)((Object)this.fldPctFree), (String)UIArb.getString(710));
        this.fldPctFree.setMaximumValue(99);
        this.fldPctFree.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblPctUsed, (Component)((Object)this.fldPctUsed), (String)UIArb.getString(711));
        this.fldPctUsed.setMaximumValue(99);
        this.fldPctUsed.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblIniTrans, (Component)((Object)this.fldIniTrans), (String)UIArb.getString(712));
        this.fldIniTrans.setMaximumValue(255);
        this.fldIniTrans.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblMaxTrans, (Component)((Object)this.fldMaxTrans), (String)UIArb.getString(713));
        this.fldMaxTrans.setMaximumValue(255);
        this.fldMaxTrans.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblLogging, (Component)this.cmbLogging, (String)UIArb.getString(727));
        this.cmbLogging.setModel(this.mdlLogging);
        this.add((Component)this.lblTop, "North");
        this.pnlCenter.add((Component)this.lblTablespace, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.cmbTablespace, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.lblPctFree, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldPctFree), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.lblPctUsed, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldPctUsed), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (this.m_storageInfoFor != StorageInfoFor.MATERIALIZED_VIEW_INDEX) {
            this.pnlCenter.add((Component)this.lblLogging, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.pnlCenter.add((Component)this.cmbLogging, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        this.pnlCenter.add((Component)this.lblIniTrans, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldIniTrans), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.lblMaxTrans, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldMaxTrans), new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pnlCenter.add((Component)((Object)this._pnlSubLobStorage), new GridBagConstraints(0, 2, 6, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setComponentNames(String baseName) {
        this._pnlSubLobStorage.setComponentNames(baseName);
        if (ModelUtil.hasLength((String)baseName)) {
            this.setName(baseName);
            baseName = baseName + '.';
        }
        this.cbxSegAttrs.setName(baseName + "CBX_SEG_ATTRS");
        this.cmbTablespace.setName(baseName + "CMB_TABLESPACE");
        this.cmbLogging.setName(baseName + "CMB_LOGGING");
        this.fldPctFree.setName(baseName + "FLD_PCT_FREE");
        this.fldPctUsed.setName(baseName + "FLD_PCT_USED");
        this.fldIniTrans.setName(baseName + "FLD_INI_TRANS");
        this.fldMaxTrans.setName(baseName + "FLD_MAX_TRANS");
    }

    private void init(DBObjectProvider prov, OracleStorageProperties oProps, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, boolean pctusedSupported, boolean readonly) {
        super.init(prov, verifier);
        this.m_contextObject = contextObject;
        this.m_pctusedSupported = pctusedSupported;
        this.m_readonly = readonly;
        if (prov instanceof Database) {
            this.cbxSegAttrs.setSelected(true);
            this.cbxSegAttrs.setEnabled(false);
        } else {
            this.cbxSegAttrs.setSelected(oProps != null);
            this.cbxSegAttrs.setEnabled(true);
        }
        boolean showMaxTrans = prov.getDescriptor().supportsFeature("MAXTRANS");
        this.fldMaxTrans.setVisible(showMaxTrans);
        this.lblMaxTrans.setVisible(showMaxTrans);
        this._oProps = oProps != null ? oProps : this._oProps;
        this.cmbTablespace.setFilter((DBObjectFilter)new PropertyFilter("properties/TablespaceType", (Object)Tablespace.TablespaceType.PERMANENT));
        this.cmbTablespace.setProvider(prov);
        this.cmbTablespace.setNullText(DEFAULT_OPTION);
        this.cmbTablespace.setDBObjectID(null);
        if (this._oProps != null) {
            this.cmbTablespace.setDBObjectID(this._oProps.getTablespaceID());
            this.fldPctFree.setNumber(this._oProps.getPercentFree());
            this.fldPctUsed.setNumber(this._oProps.getPercentUsed());
            this.fldIniTrans.setNumber(this._oProps.getInitrans());
            this.fldMaxTrans.setNumber(this._oProps.getMaxtrans());
            Boolean b = this._oProps.getLogging();
            int logIdx = b == null ? 0 : (b != false ? 1 : 2);
            this.cmbLogging.setSelectedIndex(logIdx);
            this._pnlSubLobStorage.init(prov, this._oProps, verifier);
        }
        this.enableAllComponents(verifier, true);
    }

    private boolean commit(OracleStorageProperties oProps) throws TraversalException {
        if (!this.cbxSegAttrs.isSelected()) {
            return false;
        }
        if (oProps == null) {
            oProps = new OracleStorageProperties();
        }
        this._oProps = oProps;
        DBObjectID tbspId = this.cmbTablespace.getDBObjectID();
        Integer pctFree = (Integer)this.fldPctFree.getNumber();
        Integer pctUsed = (Integer)this.fldPctUsed.getNumber();
        Integer iniTrans = (Integer)this.fldIniTrans.getNumber();
        Integer maxTrans = (Integer)this.fldMaxTrans.getNumber();
        Boolean logging = null;
        switch (this.cmbLogging.getSelectedIndex()) {
            case 1: {
                logging = Boolean.TRUE;
                break;
            }
            case 2: {
                logging = Boolean.FALSE;
            }
        }
        oProps.setTablespaceID(tbspId);
        oProps.setPercentFree(pctFree);
        oProps.setPercentUsed(pctUsed);
        oProps.setInitrans(iniTrans);
        oProps.setMaxtrans(maxTrans);
        oProps.setLogging(logging);
        this._pnlSubLobStorage.commit(oProps);
        StorageInfoVerifier verifier = (StorageInfoVerifier)this.getVerifier();
        if (verifier != null) {
            verifier.verifyStorage(oProps);
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.cbxSegAttrs) {
            if (this.cbxSegAttrs.isSelected() && this.getVerifier() != null) {
                this.enableAllComponents((StorageInfoVerifier)this.getVerifier(), true);
            } else {
                this.enableAllComponents(this.cbxSegAttrs.isSelected(), true);
            }
        }
    }

    private void enableAllComponents(boolean boo, boolean incLabels) {
        boo = boo && this.cbxSegAttrs.isSelected() && !this.m_readonly;
        this.cmbLogging.setEnabled(boo);
        this.cmbTablespace.setEnabled(boo);
        this.fldIniTrans.setEnabled(boo);
        this.fldMaxTrans.setEnabled(boo);
        this.fldPctFree.setEnabled(boo);
        this.fldPctUsed.setEnabled(boo && this.m_pctusedSupported);
        if (boo || incLabels) {
            this.lblIniTrans.setEnabled(boo);
            this.lblLogging.setEnabled(boo);
            this.lblMaxTrans.setEnabled(boo);
            this.lblPctFree.setEnabled(boo);
            this.lblPctUsed.setEnabled(boo && this.m_pctusedSupported);
            this.lblTablespace.setEnabled(boo);
        }
        this._pnlSubLobStorage.enableAllComponents(boo, incLabels);
    }

    private void enableAllComponents(StorageInfoVerifier siv, boolean incLabels) {
        if (this.m_readonly || !this.cbxSegAttrs.isSelected()) {
            this.enableAllComponents(false, incLabels);
        } else if (siv != null) {
            this.cmbTablespace.setEnabled(siv.canChangeTablespace());
            this.fldPctFree.setEnabled(siv.canChangePercentFree());
            this.fldPctUsed.setEnabled(this.m_pctusedSupported);
            this.fldIniTrans.setEnabled(siv.canChangeInitrans());
            this.fldMaxTrans.setEnabled(siv.canChangeMaxtrans());
            this.cmbLogging.setEnabled(siv.canChangeLogging());
            if (incLabels) {
                this.lblTablespace.setEnabled(siv.canChangeTablespace());
                this.lblPctFree.setEnabled(siv.canChangePercentFree());
                this.lblPctUsed.setEnabled(this.m_pctusedSupported);
                this.lblIniTrans.setEnabled(siv.canChangeInitrans());
                this.lblMaxTrans.setEnabled(siv.canChangeMaxtrans());
                this.lblLogging.setEnabled(siv.canChangeLogging());
            }
            this._pnlSubLobStorage.enableAllComponents(siv, incLabels);
        } else {
            this.enableAllComponents(true, incLabels);
        }
    }

    public static OracleStorageProperties edit(OracleStorageProperties osp, StorageInfoFor storageInfoFor, DBObjectProvider pro, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, Component parentComp) {
        return StorageInfoPanel.edit(osp, storageInfoFor, pro, contextObject, parentObject, verifier, parentComp, false);
    }

    public static void view(OracleStorageProperties osp, StorageInfoFor storageInfoFor, DBObjectProvider pro, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, Component parentComp) {
        StorageInfoPanel.edit(osp, storageInfoFor, pro, contextObject, parentObject, verifier, parentComp, true);
    }

    @Deprecated
    public static OracleStorageProperties edit(OracleStorageProperties osp, StorageInfoFor storageInfoFor, DBObjectProvider pro, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, String[] tablespaces, Component parentComp) {
        return StorageInfoPanel.edit(osp, storageInfoFor, pro, contextObject, parentObject, verifier, parentComp);
    }

    @Deprecated
    public static void view(OracleStorageProperties osp, StorageInfoFor storageInfoFor, DBObjectProvider pro, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, String[] tablespaces, Component parentComp) {
        StorageInfoPanel.view(osp, storageInfoFor, pro, contextObject, parentObject, verifier, parentComp);
    }

    private static OracleStorageProperties edit(OracleStorageProperties osp, StorageInfoFor storageInfoFor, DBObjectProvider pro, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, Component parentComp, boolean readonly) {
        String title;
        s_osp = osp;
        s_comp = parentComp;
        boolean pctusedSupported = true;
        StringBuffer abbotPrefix = new StringBuffer("StorageInfoPanel");
        if (storageInfoFor != null) {
            abbotPrefix = abbotPrefix.append(".").append(storageInfoFor.toString());
        }
        int buttonMask = 7;
        switch (storageInfoFor) {
            case TABLE: {
                title = UIArb.getString(976);
                if (contextObject.getProperty("TableType") != Table.TableType.INDEX_ORGANIZED) break;
                pctusedSupported = false;
                break;
            }
            case TABLE_PARTITION: {
                title = UIArb.getString(492);
                break;
            }
            case IOT_OVERFLOW: {
                title = UIArb.getString(461);
                break;
            }
            case MATERIALIZED_VIEW: {
                title = UIArb.getString(855);
                break;
            }
            case MATERIALIZED_VIEW_INDEX: {
                title = UIArb.getString(856);
                break;
            }
            case MATERIALIZED_VIEW_LOG: {
                title = UIArb.getString(884);
                break;
            }
            case INDEX: {
                title = UIArb.getString(409);
                pctusedSupported = false;
                break;
            }
            case INDEX_PARTITION: {
                title = UIArb.getString(492);
                pctusedSupported = false;
                break;
            }
            case TABLESPACE: {
                title = UIArb.getString(280);
                pctusedSupported = false;
                break;
            }
            default: {
                title = UIArb.getString(976);
            }
        }
        JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)parentComp), (String)title, (int)buttonMask);
        final StorageInfoPanel panel = new StorageInfoPanel(storageInfoFor);
        panel.setPreferredSize(new Dimension(600, 220));
        panel.init(pro, osp, contextObject, parentObject, verifier, pctusedSupported, readonly);
        panel.setComponentNames(abbotPrefix.toString());
        StorageInfoPanel.nameButtons(abbotPrefix.toString(), (Container)dialog);
        panel.setHelpID("f1_odbtasegattr_html");
        dialog.setContent((Component)((Object)panel));
        dialog.setResizable(true);
        VetoableChangeListener list = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    try {
                        if (s_osp == null) {
                            s_osp = new OracleStorageProperties();
                        }
                        if (!panel.commit(s_osp)) {
                            s_osp = null;
                        }
                    }
                    catch (TraversalException te) {
                        MessageDialog.error((Component)s_comp, (Object)te.getMessage(), null, null);
                        throw new PropertyVetoException(te.getMessage(), evt);
                    }
                }
            }
        };
        dialog.addVetoableChangeListener(list);
        dialog.runDialog();
        return s_osp;
    }

    private static boolean nameButtons(String prefix, Container c) {
        if (c instanceof DialogButtonBar) {
            for (Component button : c.getComponents()) {
                String name = button.getName();
                button.setName(prefix + name);
            }
            return true;
        }
        if (c != null) {
            Component[] children;
            for (Component child : children = c.getComponents()) {
                boolean done;
                if (!(child instanceof Container) || !(done = StorageInfoPanel.nameButtons(prefix, (Container)child))) continue;
                return true;
            }
        }
        return false;
    }

    static class StorageNumberField
    extends NumberTextField {
        private int _maxValue = Integer.MAX_VALUE;

        public StorageNumberField() {
            this.setDataType(Integer.class);
            this.setSigned(false);
        }

        protected boolean validateNumber(Number n) {
            return n == null || n.intValue() >= 0 && n.intValue() <= this._maxValue;
        }

        public int getMaximumValue() {
            return this._maxValue;
        }

        public void setMaximumValue(int max) {
            this._maxValue = max;
        }
    }

    public static enum StorageInfoFor {
        TABLE,
        TABLE_PARTITION,
        TABLESPACE,
        IOT_OVERFLOW,
        MATERIALIZED_VIEW,
        MATERIALIZED_VIEW_INDEX,
        MATERIALIZED_VIEW_LOG,
        INDEX,
        INDEX_PARTITION;

    }
}

