/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.util.ModelUtil;

public class StorageClausePanel
extends BaseInfoPanel
implements ItemListener {
    public static final String DEFAULT_OPTION = "<DEFAULT>";
    public static final OracleStorageProperties.BufferModes[] BUFFER_OPTIONS = OracleStorageProperties.BufferModes.values();
    private JPanel pnlExtents = new JPanel();
    private JLabel lblInitExtents = new JLabel();
    private JLabel lblNextExtents = new JLabel();
    private JLabel lblMinExtents = new JLabel();
    private JLabel lblMaxExtents = new JLabel();
    private JLabel lblPctIncrease = new JLabel();
    private StorageNumberField fldInitExtents = new StorageNumberField();
    private StorageNumberField fldNextExtents = new StorageNumberField();
    private StorageNumberField fldMinExtents = new StorageNumberField();
    private StorageNumberField fldMaxExtents = new StorageNumberField();
    private StorageNumberField fldPctIncrease = new StorageNumberField();
    private JComboBox cmbInitExtents = new JComboBox();
    private JComboBox cmbNextExtents = new JComboBox();
    private JCheckBox chkUnlimited = new JCheckBox();
    private JLabel lblFreeLists = new JLabel();
    private JLabel lblFreeListGroups = new JLabel();
    private StorageNumberField fldFreeLists = new StorageNumberField();
    private StorageNumberField fldFreeListGroups = new StorageNumberField();
    private JLabel lblBufferPool = new JLabel();
    private JComboBox cmbBufferPool = new JComboBox();
    private NonNullableComboBoxModel mdlInitExtents = new NonNullableComboBoxModel((Object[])EXTENTS_SIZES);
    private NonNullableComboBoxModel mdlNextExtents = new NonNullableComboBoxModel((Object[])EXTENTS_SIZES);
    private NonNullableComboBoxModel mdlBufferPool = new NonNullableComboBoxModel((Object[])BUFFER_OPTIONS);
    private OracleStorageProperties _oProps = null;
    private static final String[] EXTENTS_SIZES = new String[]{"", "K", "M"};
    private static final int K = 1024;
    private static final int M = 0x100000;

    public StorageClausePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StorageClausePanel(OracleStorageProperties osp) {
        this();
        this._oProps = osp;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.pnlExtents.setLayout(new GridBagLayout());
        this.pnlExtents.setBorder(BorderFactory.createTitledBorder(UIArb.getString(714)));
        ResourceUtils.resLabel((JLabel)this.lblInitExtents, (Component)((Object)this.fldInitExtents), (String)UIArb.getString(716));
        ResourceUtils.resLabel((JLabel)this.lblNextExtents, (Component)((Object)this.fldNextExtents), (String)UIArb.getString(718));
        ResourceUtils.resLabel((JLabel)this.lblMinExtents, (Component)((Object)this.fldMinExtents), (String)UIArb.getString(720));
        ResourceUtils.resLabel((JLabel)this.lblMaxExtents, (Component)((Object)this.fldMaxExtents), (String)UIArb.getString(721));
        ResourceUtils.resLabel((JLabel)this.lblPctIncrease, (Component)((Object)this.fldPctIncrease), (String)UIArb.getString(723));
        ResourceUtils.resButton((AbstractButton)this.chkUnlimited, (String)UIArb.getString(722));
        ResourceUtils.resLabel((JLabel)this.lblFreeLists, (Component)((Object)this.fldFreeLists), (String)UIArb.getString(724));
        ResourceUtils.resLabel((JLabel)this.lblFreeListGroups, (Component)((Object)this.fldFreeListGroups), (String)UIArb.getString(725));
        ResourceUtils.resLabel((JLabel)this.lblBufferPool, (Component)this.cmbBufferPool, (String)UIArb.getString(726));
        AccessibleContext ac = this.cmbInitExtents.getAccessibleContext();
        if (ac != null) {
            ac.setAccessibleName(UIArb.getString(717));
        }
        if ((ac = this.cmbNextExtents.getAccessibleContext()) != null) {
            ac.setAccessibleName(UIArb.getString(719));
        }
        this.cmbInitExtents.setModel(this.mdlInitExtents);
        this.cmbNextExtents.setModel(this.mdlNextExtents);
        this.chkUnlimited.addItemListener(this);
        this.cmbBufferPool.setModel(this.mdlBufferPool);
        this.pnlExtents.add((Component)this.lblInitExtents, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldInitExtents), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.cmbInitExtents, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.lblNextExtents, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldNextExtents), new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.cmbNextExtents, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.lblMinExtents, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldMinExtents), new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.lblMaxExtents, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldMaxExtents), new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.chkUnlimited, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.pnlExtents.add((Component)this.lblPctIncrease, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldPctIncrease), new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 10, 0), 0, 0));
        this.add(this.pnlExtents, new GridBagConstraints(1, 1, 6, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        int x = 1;
        this.add(this.lblBufferPool, new GridBagConstraints(x++, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.cmbBufferPool, new GridBagConstraints(x++, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.lblFreeLists, new GridBagConstraints(x++, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)((Object)this.fldFreeLists), new GridBagConstraints(x++, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.lblFreeListGroups, new GridBagConstraints(x++, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)((Object)this.fldFreeListGroups), new GridBagConstraints(x++, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.setComponentNames("");
    }

    public void setComponentNames(String baseName) {
        if (ModelUtil.hasLength((String)baseName)) {
            this.setName(baseName);
            baseName = baseName + '.';
        }
        this.cmbBufferPool.setName(baseName + "CMB_BUFFER_POOL");
        this.cmbInitExtents.setName(baseName + "CMB_INIT_EXTENTS");
        this.cmbNextExtents.setName(baseName + "CMB_NEXT_EXTENTS");
        this.chkUnlimited.setName(baseName + "CHK_UNLIMITED");
        this.fldPctIncrease.setName(baseName + "FLD_PCT_INCREASE");
        this.fldInitExtents.setName(baseName + "FLD_INIT_EXTENTS");
        this.fldNextExtents.setName(baseName + "FLD_NEXT_EXTENTS");
        this.fldMinExtents.setName(baseName + "FLD_MIN_EXTENTS");
        this.fldMaxExtents.setName(baseName + "FLD_MAX_EXTENTS");
        this.fldFreeListGroups.setName(baseName + "FLD_FREELIST_GROUPS");
        this.fldFreeLists.setName(baseName + "FLD_FREELISTS");
    }

    protected void init(DBObjectProvider prov, OracleStorageProperties oProps, StorageInfoVerifier verifier) {
        super.init(prov, verifier);
        this.enableAllComponents(verifier, true);
        OracleStorageProperties oracleStorageProperties = this._oProps = oProps != null ? oProps : this._oProps;
        if (this._oProps != null) {
            int tmp;
            int i;
            Integer iVal = this._oProps.getInitialExtent();
            String val = EXTENTS_SIZES[0];
            if (iVal != null && (i = iVal.intValue()) >= 1024 && i == (tmp = i / 1024) * 1024) {
                i = tmp;
                val = EXTENTS_SIZES[1];
                tmp = i / 1024;
                if (i == tmp * 1024) {
                    i = tmp;
                    val = EXTENTS_SIZES[2];
                }
                iVal = new Integer(i);
            }
            this.fldInitExtents.setNumber(iVal);
            this.cmbInitExtents.setSelectedItem(val);
            iVal = this._oProps.getNextExtent();
            val = EXTENTS_SIZES[0];
            if (iVal != null && (i = iVal.intValue()) >= 1024 && i == (tmp = i / 1024) * 1024) {
                i = tmp;
                val = EXTENTS_SIZES[1];
                tmp = i / 1024;
                if (i == tmp * 1024) {
                    i = tmp;
                    val = EXTENTS_SIZES[2];
                }
                iVal = new Integer(i);
            }
            this.fldNextExtents.setNumber(iVal);
            this.cmbNextExtents.setSelectedItem(val);
            this.fldMinExtents.setNumber(this._oProps.getMinExtent());
            iVal = this._oProps.getMaxExtent();
            if (iVal != null && iVal == Integer.MAX_VALUE) {
                this.fldMaxExtents.setNumber(null);
                this.chkUnlimited.setSelected(true);
                this.fldMaxExtents.setEnabled(false);
            } else {
                this.fldMaxExtents.setNumber(iVal);
                this.chkUnlimited.setSelected(false);
            }
            this.fldPctIncrease.setNumber(this._oProps.getPercentIncrease());
            this.fldFreeLists.setNumber(this._oProps.getFreelists());
            this.fldFreeListGroups.setNumber(this._oProps.getFreelistGroups());
            this.cmbBufferPool.setSelectedItem(this._oProps.getBufferMode());
        }
    }

    protected void commit(OracleStorageProperties oProps) throws TraversalException {
        Integer nextExt;
        if (oProps == null) {
            oProps = new OracleStorageProperties();
        }
        this._oProps = oProps;
        Integer initExt = (Integer)this.fldInitExtents.getNumber();
        if (initExt != null) {
            switch (this.cmbInitExtents.getSelectedIndex()) {
                case 1: {
                    initExt = new Integer(initExt * 1024);
                    break;
                }
                case 2: {
                    initExt = new Integer(initExt * 0x100000);
                }
            }
        }
        if ((nextExt = (Integer)this.fldNextExtents.getNumber()) != null) {
            switch (this.cmbNextExtents.getSelectedIndex()) {
                case 1: {
                    nextExt = new Integer(nextExt * 1024);
                    break;
                }
                case 2: {
                    nextExt = new Integer(nextExt * 0x100000);
                }
            }
        }
        Integer minExt = (Integer)this.fldMinExtents.getNumber();
        Integer maxExt = this.chkUnlimited.isSelected() ? new Integer(Integer.MAX_VALUE) : (Integer)this.fldMaxExtents.getNumber();
        Integer pctInc = (Integer)this.fldPctIncrease.getNumber();
        Integer freeLists = (Integer)this.fldFreeLists.getNumber();
        Integer freeListGroups = (Integer)this.fldFreeListGroups.getNumber();
        OracleStorageProperties.BufferModes bufferPool = (OracleStorageProperties.BufferModes)this.cmbBufferPool.getSelectedItem();
        oProps.setInitialExtent(initExt);
        oProps.setNextExtent(nextExt);
        oProps.setMinExtent(minExt);
        oProps.setMaxExtent(maxExt);
        oProps.setPercentIncrease(pctInc);
        oProps.setFreelists(freeLists);
        oProps.setFreelistGroups(freeListGroups);
        oProps.setBufferMode(bufferPool);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fldMaxExtents.setEnabled(!this.chkUnlimited.isSelected());
    }

    protected void enableAllComponents(boolean boo, boolean incLabels) {
        this.chkUnlimited.setEnabled(boo);
        this.cmbBufferPool.setEnabled(boo);
        this.cmbInitExtents.setEnabled(boo);
        this.cmbNextExtents.setEnabled(boo);
        this.fldFreeListGroups.setEnabled(boo);
        this.fldFreeLists.setEnabled(boo);
        this.fldInitExtents.setEnabled(boo);
        this.fldMaxExtents.setEnabled(boo);
        this.fldMinExtents.setEnabled(boo);
        this.fldNextExtents.setEnabled(boo);
        this.fldPctIncrease.setEnabled(boo);
        if (boo || incLabels) {
            this.lblBufferPool.setEnabled(boo);
            this.lblFreeListGroups.setEnabled(boo);
            this.lblFreeLists.setEnabled(boo);
            this.lblInitExtents.setEnabled(boo);
            this.lblMaxExtents.setEnabled(boo);
            this.lblMinExtents.setEnabled(boo);
            this.lblNextExtents.setEnabled(boo);
            this.lblPctIncrease.setEnabled(boo);
            this.pnlExtents.setEnabled(boo);
        }
    }

    protected void enableAllComponents(StorageInfoVerifier siv, boolean incLabels) {
        if (siv != null) {
            this.fldInitExtents.setEnabled(siv.canChangeInitialExtent());
            this.cmbInitExtents.setEnabled(siv.canChangeInitialExtent());
            this.fldNextExtents.setEnabled(siv.canChangeNextExtent());
            this.cmbNextExtents.setEnabled(siv.canChangeNextExtent());
            this.fldMinExtents.setEnabled(siv.canChangeMinExtent());
            this.fldMaxExtents.setEnabled(siv.canChangeMaxExtent());
            this.chkUnlimited.setEnabled(siv.canChangeMaxExtent());
            this.fldPctIncrease.setEnabled(siv.canChangePercentIncrease());
            this.fldFreeLists.setEnabled(siv.canChangeFreelists());
            this.fldFreeListGroups.setEnabled(siv.canChangeFreelistGroups());
            this.cmbBufferPool.setEnabled(siv.canChangeBufferMode());
            if (incLabels) {
                this.lblInitExtents.setEnabled(siv.canChangeInitialExtent());
                this.lblNextExtents.setEnabled(siv.canChangeNextExtent());
                this.lblMinExtents.setEnabled(siv.canChangeMinExtent());
                this.lblMaxExtents.setEnabled(siv.canChangeMaxExtent());
                this.lblPctIncrease.setEnabled(siv.canChangePercentIncrease());
                this.lblFreeLists.setEnabled(siv.canChangeFreelists());
                this.lblFreeListGroups.setEnabled(siv.canChangeFreelistGroups());
                this.lblBufferPool.setEnabled(siv.canChangeBufferMode());
                this.pnlExtents.setEnabled(siv.canChangeInitialExtent() || siv.canChangeNextExtent() || siv.canChangeMinExtent() || siv.canChangeMaxExtent());
            }
        } else {
            this.enableAllComponents(true, incLabels);
        }
    }

    static class StorageNumberField
    extends NumberTextField {
        private int _maxValue = Integer.MAX_VALUE;

        public StorageNumberField() {
            this.setDataType(Integer.class);
            this.setSigned(false);
        }

        protected boolean validateNumber(Number n) {
            return n == null || n.intValue() >= 0 && n.intValue() <= this._maxValue;
        }

        public int getMaximumValue() {
            return this._maxValue;
        }

        public void setMaximumValue(int max) {
            this._maxValue = max;
        }
    }
}

