/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.PropertyFilter;

public class PartitionStoragePanel
extends BaseInfoPanel {
    private JLabel m_tblspaceLabel = new JLabel();
    private DBObjectChooser m_tblspaceChooser = new DBObjectChooser("TABLESPACE");

    public PartitionStoragePanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        ResourceUtils.resLabel((JLabel)this.m_tblspaceLabel, (Component)this.m_tblspaceChooser, (String)UIArb.getString(709));
        this.m_tblspaceChooser.setName("CMB_TABLESPACE");
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(this.m_tblspaceLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_tblspaceChooser, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
    }

    @Deprecated
    protected void init(DBObjectProvider pro, TablePartition part, String[] tablespaces) {
        this.init(pro, part);
    }

    protected void init(DBObjectProvider pro, TablePartition part) {
        this.m_tblspaceChooser.setFilter((DBObjectFilter)new PropertyFilter("properties/TablespaceType", (Object)Tablespace.TablespaceType.PERMANENT));
        this.m_tblspaceChooser.setNullText("<DEFAULT>");
        this.m_tblspaceChooser.setProvider(pro);
        OracleStorageProperties osp = part.getSegmentAttributes();
        if (osp != null) {
            this.m_tblspaceChooser.setDBObjectID(osp.getTablespaceID());
        }
    }

    protected void commit(DBObjectProvider pro, TablePartition part, Table table) throws ValidationException {
        OracleStorageProperties osp = part.getSegmentAttributes();
        if (osp == null) {
            osp = new OracleStorageProperties();
            part.setSegmentAttributes(osp);
        }
        osp.setTablespaceID(this.m_tblspaceChooser.getDBObjectID());
        pro.validateObjectProperty((DBObject)part, "segmentAttributes");
    }
}

