/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.BaseConstraintPanel;
import oracle.ide.db.panels.table.ConstraintColumnSelectionPanel;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sybase.AdaptiveServerDatabase;
import oracle.javatools.util.ModelUtil;

public class PKConstraintPanel
extends BaseInfoPanel {
    protected GridBagLayout layMain = new GridBagLayout();
    protected ConstraintColumnSelectionPanel pnlColumns;
    protected Relation _relation;
    private PKConstraint _pk;
    private PKConstraint _onEntryPk;
    private Namespace _cNamespace;

    public PKConstraintPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ConstraintColumnSelectionPanel createColumnPanel() {
        return new ConstraintColumnSelectionPanel(this.getPanelName());
    }

    private String getPanelName() {
        return "PKConstraintPanel";
    }

    private void jbInit() throws Exception {
        this.pnlColumns = this.createColumnPanel();
        this.setLayout(this.layMain);
        this.add(this.pnlColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void initialize(Namespace namespace) {
        this._cNamespace = namespace;
        this.setUp();
    }

    public void addShuttleListener(ShuttleListener listener) {
        this.pnlColumns.addShuttleListener(listener);
    }

    public void removeShuttleListener(ShuttleListener listener) {
        this.pnlColumns.removeShuttleListener(listener);
    }

    public void onEntry(TraversableContext dataContext) {
        this._cNamespace = new Namespace((Namespace)dataContext);
        this.setUp();
    }

    private void setUp() {
        this.init((DBObjectProvider)this._cNamespace.find("DBObjectProvider"), (ConstraintsInfoVerifier)this._cNamespace.find("ConstraintsInfoVerifier"));
        this._relation = (Relation)this._cNamespace.find("NewObject");
        this._pk = PKConstraintPanel._findPK(this._relation);
        if (this._pk == null) {
            this._pk = (PKConstraint)this.getProvider().getObjectFactory().newObject(PKConstraint.class, (DBObject)this._relation);
            if (this._pk.getName() == null) {
                DBObjectProvider pro = this.getProvider();
                String base = BaseConstraintPanel.getDefaultBaseName(this._relation.getName(), "PKConstraint", pro);
                String name = pro instanceof AdaptiveServerDatabase ? pro.getUniqueName("PKConstraint", (DBObject)this._relation, base) : pro.getUniqueName("PKConstraint", (DBObject)this._relation.getSchema(), base);
                this._pk.setName(name);
            }
            this._pk.setEnabled(true);
            this._pk.setID(TemporaryObjectID.createID((DBObject)this._pk));
            this._onEntryPk = null;
        } else {
            this._onEntryPk = (PKConstraint)this._pk.copyTo((DBObject)this._onEntryPk, true);
            this._onEntryPk.setRelation(this._relation);
        }
        ConstraintsInfoVerifier verifer = (ConstraintsInfoVerifier)this.getVerifier();
        boolean canModify = this._pk != null && (verifer == null || verifer.canModifyConstraint((Constraint)this._pk));
        this._cNamespace.put("NewChildObject", (Object)this._pk);
        this._cNamespace.put("Modifiable", (Object)canModify);
        this.pnlColumns.init(this._cNamespace);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
    }

    public boolean canCommit() {
        return this.pnlColumns.canCommit();
    }

    public void commit() throws TraversalException {
        TraversalException commitException = null;
        try {
            this.pnlColumns.commit();
        }
        catch (TraversalException ex) {
            commitException = ex;
        }
        PKConstraint oldPK = PKConstraintPanel._findPK(this._relation);
        Column[] pkCols = this._pk.getColumns();
        if (pkCols.length == 0) {
            if (oldPK != null) {
                this._relation.removeConstraint((Constraint)oldPK);
            }
        } else {
            if (commitException != null) {
                throw commitException;
            }
            if (ModelUtil.areDifferent((Object)this._onEntryPk, (Object)this._pk)) {
                if (oldPK != null) {
                    if (oldPK != this._pk) {
                        this._pk.copyTo((Object)oldPK);
                    }
                    DBObjectID oldID = oldPK.getID();
                    DBObject idRef = null;
                    try {
                        idRef = oldID.resolveID();
                    }
                    catch (DBException ex) {
                        // empty catch block
                    }
                    if (idRef != oldPK) {
                        oldPK.setID(TemporaryObjectID.createID((DBObject)oldPK, (DBObject)this._pk));
                    }
                } else {
                    this._relation.addConstraint((Constraint)this._pk);
                }
                ConstraintsInfoVerifier verifier = (ConstraintsInfoVerifier)this.getVerifier();
                if (verifier != null) {
                    verifier.verifyConstraint((Constraint)this._onEntryPk, (Constraint)this._pk);
                }
            }
        }
    }

    private static PKConstraint _findPK(Relation rel) {
        Constraint[] cons = rel.getConstraints();
        for (int i = 0; i < cons.length; ++i) {
            if (!"PKConstraint".equals(cons[i].getConstraintType())) continue;
            return (PKConstraint)cons[i];
        }
        return null;
    }
}

