/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.IndexEditorPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.dialogs.MessageDialog;

public class IndexPanel
extends BaseInfoPanel
implements ActionListener,
DocumentListener {
    private JMultiLineLabel m_lblTop = new JMultiLineLabel();
    private DefaultListModel m_mdlIndexes = new DefaultListModel();
    private JList m_lstIndexes = new JList(this.m_mdlIndexes);
    private ListButtons m_addRemoveButtons = new ListButtons(this.m_lstIndexes, new ButtonsHelper());
    private JButton m_btnEdit = new JButton();
    private JTextField m_fldName;
    private ListSelectionListener m_mdlIndexesListSelectionListener;
    private Table m_table;
    private int m_currentSelection = 0;
    IndexEditorPanel m_pnlDetails = new IndexEditorPanel();
    IndexInfoVerifier m_indexInfoVerifier;
    private boolean m_anyRealColumns = false;
    private Index m_failedIndex = null;
    private String m_indexBaseName;
    private static String WH_ADD_NEW_INDEX = "Add a new Index";
    private static String WH_REMOVE_AN_INDEX = "Remove an Index";
    private static String WH_EDIT_INDEX_NAME = "Edit index name";
    private static String WH_CHANGE_INDEX_SELECTION = "Change index selection";

    public IndexPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_lstIndexes.setName("IndexPanel.LST_INDEXES");
        this.m_btnEdit.setName("IndexPanel.BTN_EDIT");
        this.m_pnlDetails.setName("IndexPanel.PNL_DETAILS");
        this.m_addRemoveButtons.setName("IndexPanel.BTNS_ADD_REMOVE");
        this.m_fldName = this.m_pnlDetails.getNameField();
        this.m_fldName.getDocument().addDocumentListener(this);
        this.m_lblTop.setText(UIArb.getString(359));
        this.m_lblTop.setPreferredAspectRatio(0.0f);
        this.m_lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        JLabel lblIndexes = new JLabel();
        ResourceUtils.resLabel((JLabel)lblIndexes, (Component)this.m_lstIndexes, (String)UIArb.getString(360));
        JScrollPane scrIndexes = new JScrollPane();
        scrIndexes.setVerticalScrollBarPolicy(22);
        this.m_lstIndexes.setModel(this.m_mdlIndexes);
        this.m_lstIndexes.setSelectionMode(0);
        this.m_lstIndexes.setCellRenderer(new DBObjectRenderer());
        scrIndexes.getViewport().add((Component)this.m_lstIndexes, null);
        JPanel pnlList = new JPanel(new GridBagLayout());
        this.m_addRemoveButtons.setButtonNames("IndexPanelList");
        pnlList.add((Component)lblIndexes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add((Component)scrIndexes, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        pnlList.add((Component)this.m_addRemoveButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        pnlList.add(Box.createHorizontalStrut(150), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_btnEdit, (String)UIArb.getString(388));
        this.m_pnlDetails.add((Component)this.m_btnEdit, new GridBagConstraints(0, 20, 0, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.m_btnEdit.addActionListener(this);
        this.m_pnlDetails.setBorder(BorderFactory.createTitledBorder(UIArb.getString(375)));
        JPanel pnlCenter = new JPanel(new GridBagLayout());
        pnlCenter.add((Component)pnlList, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        pnlCenter.add((Component)this.m_pnlDetails, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 24, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(pnlCenter, "Center");
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_indexInfoVerifier = (IndexInfoVerifier)dataContext.find("IndexVerifier");
        this.m_pnlDetails.init((DBObjectProvider)dataContext.find("DBObjectProvider"), (Table)dataContext.find("NewObject"), this.m_indexInfoVerifier, (Table)dataContext.get("OriginalObject"), this.m_mdlIndexes.size() > 0);
        this.init((DBObjectProvider)dataContext.find("DBObjectProvider"), (Table)dataContext.find("NewObject"), (IndexInfoVerifier)dataContext.find("IndexVerifier"));
        if (this.m_failedIndex != null) {
            this.setInitialSelection(this.m_failedIndex);
            this.m_failedIndex = null;
        } else {
            this.setInitialSelection(dataContext.find("DefaultChild"));
        }
        this.m_anyRealColumns = false;
        Table tab = (Table)dataContext.find("NewObject");
        for (Column col : tab.getColumns()) {
            if (!(col instanceof ViewColumn)) {
                this.m_anyRealColumns = true;
                break;
            }
            if (col.getName().equals("*")) continue;
            this.m_anyRealColumns = true;
            break;
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit((Table)dataContext.find("NewObject"));
    }

    protected void init(DBObjectProvider prov, Table table, IndexInfoVerifier verifier) {
        super.init(prov, verifier);
        this.m_table = table;
        if (this.m_indexBaseName == null) {
            this.m_indexBaseName = prov.getDescriptor().getCasePolicy() == 1 ? "_index" : "_INDEX";
        }
        this.m_lstIndexes.getSelectionModel().removeListSelectionListener(this.m_mdlIndexesListSelectionListener);
        this.m_mdlIndexes.removeAllElements();
        this.m_mdlIndexesListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                IndexPanel.this.m_pnlDetails.logActionStart(WH_CHANGE_INDEX_SELECTION, true);
                IndexPanel.this.updateSelection(IndexPanel.this.m_lstIndexes.getSelectedValue());
                IndexPanel.this.m_pnlDetails.logActionEnd(WH_CHANGE_INDEX_SELECTION);
            }
        };
        this.m_lstIndexes.getSelectionModel().addListSelectionListener(this.m_mdlIndexesListSelectionListener);
        Index[] indexes = table.getIndexes();
        Arrays.sort(indexes, DBUtil.getNameComparator());
        for (int i = 0; i < indexes.length; ++i) {
            this.m_mdlIndexes.addElement(indexes[i]);
        }
        this.updateButtons();
        this.updateListContents(this.m_mdlIndexes);
        boolean haveIndex = this.m_mdlIndexes.size() > 0;
        this.m_btnEdit.setEnabled(haveIndex && this.canDoAdvancedEdit(indexes[0]));
        this.m_addRemoveButtons.enableButtons();
    }

    protected void commit(Table newTable) throws TraversalException {
        this.m_failedIndex = (Index)this.m_lstIndexes.getSelectedValue();
        this.m_pnlDetails.commit();
        int size = this.m_mdlIndexes.size();
        Index[] indexes = new Index[size];
        for (int i = 0; i < size; ++i) {
            indexes[i] = (Index)this.m_mdlIndexes.getElementAt(i);
        }
        Arrays.sort(indexes, DBUtil.getNameComparator());
        newTable.setIndexes(indexes);
        IndexInfoVerifier verifier = (IndexInfoVerifier)this.getVerifier();
        if (verifier != null) {
            verifier.verifyRelation();
        }
        this.m_failedIndex = null;
    }

    private void setInitialSelection(Object selObj) {
        int idx;
        int sel = 0;
        if (selObj != null && (idx = this.m_mdlIndexes.indexOf(selObj)) != -1) {
            sel = idx;
        }
        if (this.m_mdlIndexes.size() > 0) {
            this.setSelectedIndex(sel);
        }
    }

    private void updateSelection(Object sel) {
        if (sel != this.m_pnlDetails.getIndex()) {
            try {
                this.m_pnlDetails.commit();
            }
            catch (TraversalException e) {
                this.showIndexError(e);
                return;
            }
            this.m_pnlDetails.updateIndexData((Index)sel);
        }
        this.updateButtons();
        this.m_pnlDetails.updateButtons();
        this.m_pnlDetails.setFieldEnable(this.m_indexInfoVerifier, (Index)sel, sel != null);
    }

    private void showIndexError(TraversalException ex) {
        ex.showMessageDialog((Component)((Object)this));
        int indexOfSelectedIndex = this.m_lstIndexes.getSelectedIndex();
        if (indexOfSelectedIndex < 0 || this.m_mdlIndexes.elementAt(indexOfSelectedIndex).equals(this.m_mdlIndexes.elementAt(this.m_currentSelection))) {
            this.setSelectedIndex(this.m_currentSelection);
        } else if (this.m_currentSelection != indexOfSelectedIndex) {
            this.setSelectedIndex(this.m_pnlDetails.getIndex());
        }
    }

    private void updateButtons() {
        this.m_addRemoveButtons.enableButtons();
    }

    private void updateListContents(Object o) {
        boolean haveIndex;
        boolean bl = haveIndex = this.m_mdlIndexes.getSize() > 0;
        if (this.m_mdlIndexes == o) {
            this.m_lstIndexes.setFocusable(haveIndex);
            if (haveIndex) {
                int selectedIndexNo = this.m_lstIndexes.getSelectedIndex();
                int listSize = this.m_mdlIndexes.getSize();
                if (selectedIndexNo < 0) {
                    selectedIndexNo = 0;
                } else if (selectedIndexNo >= listSize) {
                    selectedIndexNo = listSize - 1;
                    this.setSelectedIndex(selectedIndexNo);
                }
                Index currentIndex = (Index)this.m_mdlIndexes.getElementAt(selectedIndexNo);
                this.m_pnlDetails.populateColumnExpressions(currentIndex);
                this.m_fldName.setEditable(true);
                this.m_fldName.setEnabled(true);
            } else {
                this.m_fldName.setEditable(false);
                this.m_fldName.setEnabled(false);
            }
        }
    }

    private void updateIndexName() {
        if (this.m_fldName.hasFocus()) {
            this.m_pnlDetails.logActionStart(WH_EDIT_INDEX_NAME, true);
            String indexName = this.m_fldName.getText();
            Index index = (Index)this.m_lstIndexes.getSelectedValue();
            if (index != null) {
                index.setName(indexName);
                this.m_lstIndexes.repaint();
            }
            this.m_fldName.requestFocusInWindow();
            this.m_pnlDetails.logActionEnd(WH_EDIT_INDEX_NAME);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.m_currentSelection = this.m_lstIndexes.getSelectedIndex();
        Object src = ae.getSource();
        if (src == this.m_btnEdit) {
            int selectedIndexNo = this.m_lstIndexes.getSelectedIndex();
            int listSize = this.m_mdlIndexes.getSize();
            if (selectedIndexNo < 0) {
                selectedIndexNo = 0;
            } else if (selectedIndexNo >= listSize) {
                selectedIndexNo = listSize - 1;
                this.setSelectedIndex(selectedIndexNo);
            }
            Index index = (Index)this.m_mdlIndexes.getElementAt(selectedIndexNo);
            try {
                this.m_pnlDetails.commit();
            }
            catch (TraversalException e) {
                // empty catch block
            }
            DBObject originalIndex = null;
            if (index.getID() instanceof TemporaryObjectID) {
                TemporaryObjectID id = (TemporaryObjectID)index.getID();
                Object origObj = null;
                try {
                    originalIndex = id.resolveOriginalID();
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            DBEditorFactory editFactory = DBEditorFactoryRegistry.getEditFactory((SchemaObject)index, this.getProvider());
            editFactory.editDBObject((DBObject)index, this.getProvider(), false);
            DBObjectID indexID = index.getID();
            if (indexID instanceof TemporaryObjectID) {
                index.setID(null);
                indexID = TemporaryObjectID.createID((DBObject)index, (DBObject)originalIndex);
                index.setID(indexID);
            }
            this.m_pnlDetails.updateIndexData(index);
            this.updateButtons();
            this.m_pnlDetails.updateButtons();
            this.m_pnlDetails.setFieldEnable(this.m_indexInfoVerifier, index, true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent p0) {
        this.updateIndexName();
    }

    @Override
    public void removeUpdate(DocumentEvent p0) {
        this.updateIndexName();
    }

    @Override
    public void changedUpdate(DocumentEvent p0) {
        this.updateIndexName();
    }

    private void setSelectedIndex(int indexOfIndex) {
        this.m_currentSelection = indexOfIndex;
        this.m_lstIndexes.setSelectedIndex(this.m_currentSelection);
    }

    private void setSelectedIndex(Index index) {
        this.m_lstIndexes.setSelectedValue(index, true);
        this.m_currentSelection = this.m_lstIndexes.getSelectedIndex();
    }

    private boolean canDoAdvancedEdit(Index index) {
        boolean result = false;
        DBObjectProvider pro = this.getProvider();
        PropertyManager pm = pro.getPropertyManager();
        if (pm != null) {
            boolean parallel = pm.canAlterProperty((DBObject)index, (DBObject)index, "parallelDegree");
            boolean compress = pm.canAlterProperty((DBObject)index, (DBObject)index, "keyCompression");
            boolean storage = pm.canAlterProperty((DBObject)index, (DBObject)index, Property.createPath((String[])new String[]{"OracleStorageProperties", "percentFree"}));
            result = parallel || compress || storage;
        }
        return result;
    }

    private class ButtonsHelper
    extends ListButtons.Controller {
        private ButtonsHelper() {
        }

        @Override
        public void addToList() {
            IndexPanel.this.m_currentSelection = IndexPanel.this.m_lstIndexes.getSelectedIndex();
            if (IndexPanel.this.m_anyRealColumns) {
                IndexPanel.this.m_pnlDetails.logActionStart(WH_ADD_NEW_INDEX, false);
                IndexPanel.this.m_lstIndexes.clearSelection();
                if (IndexPanel.this.m_lstIndexes.getSelectedValue() == null) {
                    Index index = (Index)IndexPanel.this.getProvider().getObjectFactory().newObject(Index.class, (DBObject)IndexPanel.this.m_table);
                    IndexPanel.this.m_table.addIndex(index);
                    if (index.getName() == null) {
                        String name = IndexPanel.getUniqueName(IndexPanel.this.m_table.getName() + IndexPanel.this.m_indexBaseName, IndexPanel.this.m_mdlIndexes);
                        index.setName(name);
                    }
                    IndexPanel.this.m_pnlDetails.setNewIndex(true);
                    IndexPanel.this.m_mdlIndexes.addElement(index);
                    IndexPanel.this.m_pnlDetails.populateColumnExpressions(index);
                    IndexPanel.this.setSelectedIndex(index);
                    IndexPanel.this.m_fldName.requestFocusInWindow();
                    IndexPanel.this.m_btnEdit.setEnabled(IndexPanel.this.canDoAdvancedEdit(index));
                }
                IndexPanel.this.m_pnlDetails.logActionEnd(WH_ADD_NEW_INDEX);
            } else {
                MessageDialog.error((Component)((Object)IndexPanel.this), (Object)UIArb.getString(396), (String)UIArb.format(391, IndexPanel.this.m_table.getName()), null);
            }
        }

        @Override
        public void removeFromList() {
            IndexPanel.this.m_pnlDetails.logActionStart(WH_REMOVE_AN_INDEX, false);
            int idx = IndexPanel.this.m_lstIndexes.getSelectedIndex();
            if (idx != -1) {
                IndexPanel.this.m_table.removeIndex(IndexPanel.this.m_pnlDetails.getIndex());
                IndexPanel.this.m_pnlDetails.setIndex(null);
                int newIdx = idx == IndexPanel.this.m_mdlIndexes.size() - 1 ? idx - 1 : idx + 1;
                IndexPanel.this.setSelectedIndex(newIdx);
                IndexPanel.this.m_mdlIndexes.removeElementAt(idx);
                if (newIdx > 0 && newIdx == IndexPanel.this.m_mdlIndexes.size()) {
                    IndexPanel.this.setSelectedIndex(newIdx - 1);
                }
                if (newIdx == -1) {
                    IndexPanel.this.updateSelection(null);
                    IndexPanel.this.m_pnlDetails.updateIndexData(null);
                    IndexPanel.this.m_btnEdit.setEnabled(false);
                }
            }
            IndexPanel.this.m_pnlDetails.logActionEnd(WH_REMOVE_AN_INDEX);
        }

        @Override
        public String getAddTooltipText() {
            return UIArb.getString(369);
        }

        @Override
        public String getRemoveTooltipText() {
            return UIArb.getString(370);
        }

        @Override
        public boolean includeReorderButtons() {
            return false;
        }

        public boolean canAdd(Object val) {
            IndexInfoVerifier verifier = (IndexInfoVerifier)IndexPanel.this.getVerifier();
            return verifier == null || verifier.canAddIndex((Index)val);
        }

        @Override
        public boolean canAdd() {
            IndexInfoVerifier verifier = (IndexInfoVerifier)IndexPanel.this.getVerifier();
            return verifier == null || verifier.canAddIndexes();
        }

        @Override
        public boolean canRemove() {
            IndexInfoVerifier verifier = (IndexInfoVerifier)IndexPanel.this.getVerifier();
            return verifier == null || verifier.canRemoveIndexes();
        }

        @Override
        public boolean canRemove(Object val) {
            IndexInfoVerifier verifier = (IndexInfoVerifier)IndexPanel.this.getVerifier();
            return verifier == null || verifier.canRemoveIndex((Index)val);
        }
    }
}

